/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.user;

import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.SelectFieldDefinitionUtils;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.SelectOption;
import com.inet.usersandgroups.api.ui.fields.SelectOptionResult;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.Map;

public class LanguageUserFieldDefinition
extends SelectUserFieldDefinition<String> {
    public LanguageUserFieldDefinition(int prio) {
        super("user.masterdata", HDUsersAndGroups.FIELD_LANGUAGE.getKey(), prio);
    }

    public SelectOption getValue(UserAccount userAccount) {
        String value = null;
        if (userAccount != null) {
            value = (String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE);
        }
        if (value == null) {
            value = (String)HDUsersAndGroups.FIELD_LANGUAGE.getDefaultValue();
        }
        Map languages = HDUsersAndGroups.FIELD_LANGUAGE.getSearchTag().getMapData();
        return new SelectOption(value, (String)languages.get(value));
    }

    public SelectOptionResult getOptions(UserAccount userAccount, String searchTerm, int currentSize, int chunkSize) {
        Map languages = HDUsersAndGroups.FIELD_LANGUAGE.getSearchTag().getMapData();
        return SelectFieldDefinitionUtils.getOptions(searchTerm, currentSize, chunkSize, languages);
    }

    public String convertFromString(String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            SelectOption option = (SelectOption)new Json().fromJson(value, SelectOption.class);
            try {
                return option.getValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "xx";
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.getDisplayNameForField(HDUsersAndGroups.FIELD_LANGUAGE.getKey());
    }
}

