/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.group;

import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldSettings;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.SelectFieldDefinitionUtils;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.fields.SelectOption;
import com.inet.usersandgroups.api.ui.fields.SelectOptionResult;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.SelectGroupFieldDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class TimerFromResSettingsGroupFieldDefinition
extends SelectGroupFieldDefinition<Integer> {
    private static final ResourceFieldSettings FIELD = HDUsersAndGroups.RES_FIELD_SETTINGS;

    public TimerFromResSettingsGroupFieldDefinition(String groupKey, int prio) {
        super(groupKey, FIELD.getKey() + "Timer", prio);
    }

    public SelectOption getValue(UserGroupInfo groupInfo) {
        Integer bitMask = null;
        if (groupInfo != null) {
            bitMask = (Integer)groupInfo.getValue((UserGroupField)FIELD);
        }
        if (bitMask == null) {
            bitMask = 0;
        }
        ArrayList<Integer> allRelevantBitValues = new ArrayList<Integer>(FIELD.getTimerBitValuesToDisplayNames().keySet());
        Collections.sort(allRelevantBitValues, Collections.reverseOrder());
        Integer relevantBitValue = 0;
        Iterator iterator = allRelevantBitValues.iterator();
        while (iterator.hasNext()) {
            int bitValue = (Integer)iterator.next();
            if (!this.isSet(bitMask, bitValue)) continue;
            relevantBitValue = bitValue;
            break;
        }
        return new SelectOption(relevantBitValue.toString(), FIELD.getTimerBitValuesToDisplayNames().get(relevantBitValue));
    }

    public SelectOptionResult getOptions(UserGroupInfo groupInfo, String searchTerm, int currentSize, int chunkSize) {
        return SelectFieldDefinitionUtils.getOptions(searchTerm, currentSize, chunkSize, FIELD.getTimerBitValuesToDisplayNames());
    }

    public Integer convertFromString(String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            SelectOption option = (SelectOption)new Json().fromJson(value, SelectOption.class);
            try {
                return Integer.parseInt(option.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.groupFieldDefinition.resource.resourcesettingstimer", new Object[0]);
    }

    public void validate(Object value) throws ClientMessageException {
        Integer bitValue = (Integer)value;
        if (!FIELD.getTimerBitValuesToDisplayNames().containsKey(bitValue)) {
            throw new ClientMessageException("Unknown option of resource timer settings: " + bitValue);
        }
    }

    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
        Integer bitValueOfSelectedOption = (Integer)value;
        MutableUserGroupData mutableData = userGroupUpdateData.getUserGroupData();
        Integer bitmask = (Integer)mutableData.get((UserGroupField)FIELD);
        if (bitmask == null && userGroup != null) {
            bitmask = (Integer)userGroup.getValue((UserGroupField)FIELD);
        }
        if (bitmask == null) {
            bitmask = (Integer)FIELD.getDefaultValue();
        }
        ArrayList<Integer> allRelevantBitValues = new ArrayList<Integer>(FIELD.getTimerBitValuesToDisplayNames().keySet());
        Collections.sort(allRelevantBitValues, Collections.reverseOrder());
        Iterator iterator = allRelevantBitValues.iterator();
        while (iterator.hasNext()) {
            int bitValue = (Integer)iterator.next();
            if (!this.isSet(bitmask, bitValue)) continue;
            bitmask = bitmask - bitValue;
            break;
        }
        mutableData.put((UserGroupField)FIELD, (Object)(bitmask + bitValueOfSelectedOption));
    }

    private boolean isSet(int valueToCheck, int expectedBitValue) {
        return (valueToCheck & expectedBitValue) == expectedBitValue;
    }
}

