/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui;

import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettings;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class UserFieldsWithClientSettingManager {
    private static final UserFieldsWithClientSettingManager manager = new UserFieldsWithClientSettingManager();

    public static UserFieldsWithClientSettingManager getInstance() {
        return manager;
    }

    public void saveUserFieldValues(ArrayList<UserField<String>> userFields, UserAccount userAccount) {
        HashMap<String, String> userFieldValues = new HashMap<String, String>();
        for (UserField<String> field : userFields) {
            userFieldValues.put(field.getKey(), (String)userAccount.getValue(field));
        }
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        MutableUserGroupData groupData = new MutableUserGroupData();
        groupData.put(UserFieldsWithClientSettings.USER_FIELDS_WITH_CLIENT_SETTINGS, (Object)new Json().toJson(userFieldValues));
        userGroupManager.updateGroupData(UsersAndGroups.GROUPID_ALLUSERS, groupData);
    }

    public String getDefaultValueForUserField(UserField<String> field) {
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        UserGroupInfo group = userGroupManager.getGroup(UsersAndGroups.GROUPID_ALLUSERS);
        String jsonData = (String)group.getValue(UserFieldsWithClientSettings.USER_FIELDS_WITH_CLIENT_SETTINGS);
        if (jsonData == null) {
            return null;
        }
        HashMap fromJson = (HashMap)new Json().fromJson(jsonData, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, String.class}));
        return (String)fromJson.get(field.getKey());
    }
}

