/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups.persistence;

import com.inet.error.PersistenceException;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.helpdesk.usersandgroups.groups.persistence.ResourceData;
import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.SuppressFBWarnings;

public class ResourcePersistence {
    private static String TBLUSER = "tblUser";
    private static String TBLBENUTZERGRUPPE = "tblBenutzerGruppe";
    private static String TBLRESSOURCEN = "tblRessourcen";
    private static String TBLRESSOURCENUSER = "tblRessourcenUser";

    public String loadNameOfResourceWithoutAssociatedGroupOrElseThrow(Connection connection, Integer resID) throws SQLException {
        String sql = String.format("SELECT GroupUUID, ResBezeichnung FROM %s WHERE ResID = ?", TBLRESSOURCEN);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            String string;
            block14: {
                pstm.setInt(1, resID);
                ResultSet rs = pstm.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new IllegalArgumentException(String.format("resource with ID %d does not exist", resID));
                    }
                    rs.getString(1);
                    boolean wasGroupIdNull = rs.wasNull();
                    if (!wasGroupIdNull) {
                        throw new IllegalArgumentException(String.format("resource with ID %d is already associated with user group", resID));
                    }
                    string = rs.getString(2);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return string;
        }
    }

    public void updateGroupID(Connection connection, int resID, GUID groupID) throws SQLException {
        String sql = String.format("UPDATE %s SET GroupUUID = ? WHERE ResID = ?", TBLRESSOURCEN);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setString(1, groupID.toString());
            pstm.setInt(2, resID);
            pstm.executeUpdate();
        }
    }

    public int insertIntoTblRessourcen(Connection connection, GUID groupID, String resourceName, MutableUserGroupData groupData) throws SQLException {
        String sql = String.format("SELECT * FROM %s WHERE 1 = 0", TBLRESSOURCEN);
        try (Statement stm = connection.createStatement(1005, 1008);){
            int n;
            block12: {
                ResultSet rs = stm.executeQuery(sql);
                try {
                    rs.moveToInsertRow();
                    rs.updateString("GroupUUID", groupID.toString());
                    rs.updateInt("ParentRes", (int)((Integer)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_PARENT_ID)));
                    rs.updateString("ResBezeichnung", resourceName);
                    rs.updateString("Email", (String)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_EMAIL));
                    rs.updateInt("geloescht", 0);
                    rs.updateObject("Eskalation", groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_ESC_RES_ID), 4);
                    rs.updateDouble("Stundensatz", (double)((Double)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_HOURLY_RATE)));
                    rs.updateInt("Rechte", (int)((Integer)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS)));
                    rs.updateInt("Msg", (int)((Integer)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_NOTIF_SETTINGS)));
                    rs.updateString("MsgText", "");
                    rs.updateTimestamp("MsgVon", null);
                    rs.updateTimestamp("MsgBis", null);
                    ResourceFieldWorkingHours.WorkingHours workingHours = (ResourceFieldWorkingHours.WorkingHours)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS);
                    this.updateWorkingHours(rs, workingHours);
                    rs.insertRow();
                    rs.last();
                    n = rs.getInt("ResID");
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
    }

    private Timestamp convertToTimestamp(LocalTime localTime) {
        long minutes = localTime.getHour() * 60 + localTime.getMinute();
        long millisPerMinute = 60000L;
        long millis = minutes * millisPerMinute - (long)Calendar.getInstance().get(15);
        return new Timestamp(millis);
    }

    private void updateWorkingHours(ResultSet rs, ResourceFieldWorkingHours.WorkingHours workingHours) throws SQLException {
        this.updateWorkingHours(rs, "Zeit00", "Zeit01", workingHours.getHourRange(DayOfWeek.SUNDAY));
        this.updateWorkingHours(rs, "Zeit10", "Zeit11", workingHours.getHourRange(DayOfWeek.MONDAY));
        this.updateWorkingHours(rs, "Zeit20", "Zeit21", workingHours.getHourRange(DayOfWeek.TUESDAY));
        this.updateWorkingHours(rs, "Zeit30", "Zeit31", workingHours.getHourRange(DayOfWeek.WEDNESDAY));
        this.updateWorkingHours(rs, "Zeit40", "Zeit41", workingHours.getHourRange(DayOfWeek.THURSDAY));
        this.updateWorkingHours(rs, "Zeit50", "Zeit51", workingHours.getHourRange(DayOfWeek.FRIDAY));
        this.updateWorkingHours(rs, "Zeit60", "Zeit61", workingHours.getHourRange(DayOfWeek.SATURDAY));
    }

    private void updateWorkingHours(ResultSet rs, String columnStart, String columnEnd, ResourceFieldWorkingHours.HourRange hourRange) throws SQLException {
        Timestamp start = null;
        Timestamp end = null;
        if (hourRange != null) {
            start = this.convertToTimestamp(hourRange.getStart());
            end = this.convertToTimestamp(hourRange.getEnd());
        }
        rs.updateTimestamp(columnStart, start);
        rs.updateTimestamp(columnEnd, end);
    }

    public ResourceData loadResourceData(Connection connection, GUID groupID) throws SQLException {
        String sql = String.format("SELECT * FROM %s WHERE GroupUUID = ?", TBLRESSOURCEN);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            ResourceData resourceData;
            block14: {
                pstm.setString(1, groupID.toString());
                ResultSet rs = pstm.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new PersistenceException("there is no resource matching group with ID " + groupID);
                    }
                    HashMap<UserGroupField, Object> fieldValues = new HashMap<UserGroupField, Object>();
                    int resID = rs.getInt("ResID");
                    fieldValues.put(HDUsersAndGroups.RES_FIELD_ID, resID);
                    int parentResID = rs.getInt("ParentRes");
                    fieldValues.put(HDUsersAndGroups.RES_FIELD_PARENT_ID, parentResID);
                    String email = rs.getString("Email");
                    fieldValues.put(HDUsersAndGroups.RES_FIELD_EMAIL, email == null ? "" : email);
                    int escalationResID = rs.getInt("Eskalation");
                    boolean wasEscalationResIdNullOrZero = rs.wasNull() || escalationResID == 0;
                    fieldValues.put(HDUsersAndGroups.RES_FIELD_ESC_RES_ID, wasEscalationResIdNullOrZero ? null : Integer.valueOf(escalationResID));
                    double hourlyRate = rs.getDouble("Stundensatz");
                    fieldValues.put(HDUsersAndGroups.RES_FIELD_HOURLY_RATE, hourlyRate);
                    int settings = rs.getInt("Rechte");
                    fieldValues.put(HDUsersAndGroups.RES_FIELD_SETTINGS, settings);
                    int notificationSettings = rs.getInt("Msg");
                    fieldValues.put(HDUsersAndGroups.RES_FIELD_NOTIF_SETTINGS, notificationSettings);
                    HashMap<DayOfWeek, ResourceFieldWorkingHours.HourRange> hourRanges = new HashMap<DayOfWeek, ResourceFieldWorkingHours.HourRange>();
                    BiConsumer<DayOfWeek, ResourceFieldWorkingHours.HourRange> putIfDefined = (day, range) -> {
                        if (range != null) {
                            hourRanges.put((DayOfWeek)day, (ResourceFieldWorkingHours.HourRange)range);
                        }
                    };
                    putIfDefined.accept(DayOfWeek.SUNDAY, this.readHourRangeFrom(rs, "Zeit00", "Zeit01"));
                    putIfDefined.accept(DayOfWeek.MONDAY, this.readHourRangeFrom(rs, "Zeit10", "Zeit11"));
                    putIfDefined.accept(DayOfWeek.TUESDAY, this.readHourRangeFrom(rs, "Zeit20", "Zeit21"));
                    putIfDefined.accept(DayOfWeek.WEDNESDAY, this.readHourRangeFrom(rs, "Zeit30", "Zeit31"));
                    putIfDefined.accept(DayOfWeek.THURSDAY, this.readHourRangeFrom(rs, "Zeit40", "Zeit41"));
                    putIfDefined.accept(DayOfWeek.FRIDAY, this.readHourRangeFrom(rs, "Zeit50", "Zeit51"));
                    putIfDefined.accept(DayOfWeek.SATURDAY, this.readHourRangeFrom(rs, "Zeit60", "Zeit61"));
                    ResourceFieldWorkingHours.WorkingHours workingHours = new ResourceFieldWorkingHours.WorkingHours(hourRanges);
                    if (workingHours.areLessThanOneHourPerWeek()) {
                        workingHours = ResourceFieldWorkingHours.DEFAULT_WORKING_HOURS;
                    }
                    fieldValues.put(HDUsersAndGroups.RES_FIELD_WORKING_HOURS, workingHours);
                    MutableUserGroupData groupData = MutableUserGroupData.createAndFillWithValidValues((GUID)groupID, new ArrayList(fieldValues.keySet()), fieldValues);
                    String name = rs.getString("ResBezeichnung");
                    resourceData = new ResourceData(name, groupData);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return resourceData;
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    public void updateResourceData(Connection connection, GUID groupID, MutableUserGroupData resourceData) throws SQLException {
        String sql = String.format("SELECT * FROM %s WHERE GroupUUID = %s", TBLRESSOURCEN, groupID.toSQLString());
        try (Statement stm = connection.createStatement(1005, 1008);
             ResultSet rs = stm.executeQuery(sql);){
            if (!rs.next()) {
                throw new PersistenceException("there is no resource matching group with ID " + groupID);
            }
            for (UserGroupField field : resourceData.getIncludedFields()) {
                Object value = resourceData.get(field);
                if (((Object)((Object)HDUsersAndGroups.RES_FIELD_EMAIL)).equals(field)) {
                    rs.updateString("Email", (String)value);
                    continue;
                }
                if (((Object)((Object)HDUsersAndGroups.RES_FIELD_HOURLY_RATE)).equals(field)) {
                    rs.updateDouble("Stundensatz", (double)((Double)value));
                    continue;
                }
                if (((Object)((Object)HDUsersAndGroups.RES_FIELD_ESC_RES_ID)).equals(field)) {
                    rs.updateObject("Eskalation", value, 4);
                    continue;
                }
                if (((Object)((Object)HDUsersAndGroups.RES_FIELD_PARENT_ID)).equals(field)) {
                    rs.updateInt("ParentRes", (int)((Integer)value));
                    continue;
                }
                if (((Object)((Object)HDUsersAndGroups.RES_FIELD_SETTINGS)).equals(field)) {
                    rs.updateInt("Rechte", (int)((Integer)value));
                    continue;
                }
                if (((Object)((Object)HDUsersAndGroups.RES_FIELD_NOTIF_SETTINGS)).equals(field)) {
                    rs.updateInt("Msg", (int)((Integer)value));
                    continue;
                }
                if (!((Object)((Object)HDUsersAndGroups.RES_FIELD_WORKING_HOURS)).equals(field)) continue;
                this.updateWorkingHours(rs, (ResourceFieldWorkingHours.WorkingHours)value);
            }
            rs.updateRow();
        }
    }

    private ResourceFieldWorkingHours.HourRange readHourRangeFrom(ResultSet rs, String columnStart, String columnEnd) throws SQLException {
        Timestamp start = rs.getTimestamp(columnStart);
        Timestamp end = rs.getTimestamp(columnEnd);
        if (start == null || end == null) {
            return null;
        }
        LocalTime startTime = LocalTime.of(start.getHours(), start.getMinutes());
        LocalTime endTime = LocalTime.of(end.getHours(), end.getMinutes());
        return new ResourceFieldWorkingHours.HourRange(startTime, endTime);
    }

    public Optional<Integer> findResourceByGroupId(Connection connection, GUID groupID) throws SQLException {
        String sql = String.format("SELECT ResID FROM %s WHERE GroupUUID = ?", TBLRESSOURCEN);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            Optional<Integer> optional;
            block16: {
                ResultSet rs;
                block14: {
                    Optional<Integer> optional2;
                    block15: {
                        pstm.setString(1, groupID.toString());
                        rs = pstm.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            optional2 = Optional.of(rs.getInt(1));
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (rs == null) break block16;
                rs.close();
            }
            return optional;
        }
    }

    public Map<GUID, Set<String>> loadMembersMap(Connection connection, int resID) throws SQLException {
        HashMap<GUID, Set<String>> membersMap = new HashMap<GUID, Set<String>>();
        String sql = String.format("SELECT ru.*, u.UserUUID FROM %s ru INNER JOIN %s u ON ru.UsrID = u.UsrID WHERE ru.ResID = ? ", TBLRESSOURCENUSER, TBLUSER);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, resID);
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    GUID userUUID;
                    try {
                        userUUID = GUID.valueOf((String)rs.getString("UserUUID"));
                    }
                    catch (IllegalArgumentException ex) {
                        UsersAndGroups.LOGGER.error((Object)String.format("Found resource member (resID=\"%d\") with invalid account ID:", resID));
                        UsersAndGroups.LOGGER.error((Object)ex);
                        continue;
                    }
                    boolean fullAccess = rs.getInt("ReadAccessOnly") == 0;
                    MembershipType membershipType = fullAccess ? HDUsersAndGroups.RESOURCE_MEMBERSHIPTYPE_WRITE : HDUsersAndGroups.RESOURCE_MEMBERSHIPTYPE_READ;
                    HashSet<String> types = new HashSet<String>();
                    types.add(membershipType.getKey());
                    membersMap.put(userUUID, types);
                }
            }
        }
        return membersMap;
    }

    public static Map<GUID, Boolean> convertToResourceMembershipMap(Map<GUID, Set<String>> membersMap) {
        HashMap<GUID, Boolean> map = new HashMap<GUID, Boolean>();
        for (Map.Entry<GUID, Set<String>> entry : membersMap.entrySet()) {
            String membershipType = entry.getValue().iterator().next();
            boolean fullAccess = HDUsersAndGroups.RESOURCE_MEMBERSHIPTYPE_WRITE.getKey().equalsIgnoreCase(membershipType);
            map.put(entry.getKey(), fullAccess);
        }
        return map;
    }

    public void updateMembershipData(Connection connection, int resID, Map<GUID, Boolean> membershipData) throws SQLException {
        this.deleteMembershipData(connection, resID);
        String sqlInsert = String.format("INSERT INTO %s (UsrID, ResID, ReadAccessOnly) (SELECT UsrID, ?, ? FROM %s WHERE UserUUID = ?)", TBLRESSOURCENUSER, TBLUSER);
        try (PreparedStatement pstm = connection.prepareStatement(sqlInsert);){
            for (Map.Entry<GUID, Boolean> entry : membershipData.entrySet()) {
                pstm.setInt(1, resID);
                pstm.setInt(2, entry.getValue() != false ? 0 : 1);
                pstm.setString(3, entry.getKey().toString());
                pstm.executeUpdate();
            }
        }
    }

    private void deleteMembershipData(Connection connection, int resID) throws SQLException {
        String sqlDelete = String.format("DELETE FROM %s WHERE ResID = ?", TBLRESSOURCENUSER);
        try (PreparedStatement pstm = connection.prepareStatement(sqlDelete);){
            pstm.setInt(1, resID);
            pstm.executeUpdate();
        }
    }

    public void deactivateResource(Connection connection, GUID groupID, boolean removeMembershipData) throws SQLException {
        PreparedStatement pstm;
        Optional<Integer> matchedResID = this.findResourceByGroupId(connection, groupID);
        if (!matchedResID.isPresent()) {
            throw new PersistenceException("there is no resource matching group with ID " + groupID);
        }
        int resID = matchedResID.get();
        if (removeMembershipData) {
            String sql = String.format("DELETE FROM %s WHERE ResID = ?", TBLRESSOURCENUSER);
            pstm = connection.prepareStatement(sql);
            try {
                pstm.setInt(1, resID);
                pstm.executeUpdate();
            }
            finally {
                if (pstm != null) {
                    pstm.close();
                }
            }
        }
        String sqlBgr = String.format("UPDATE %s SET ResID = 0 WHERE ResID = ?", TBLBENUTZERGRUPPE);
        pstm = connection.prepareStatement(sqlBgr);
        try {
            pstm.setInt(1, resID);
            pstm.executeUpdate();
        }
        finally {
            if (pstm != null) {
                pstm.close();
            }
        }
        String sql = String.format("UPDATE %s SET geloescht = ? WHERE ResID = ?", TBLRESSOURCEN);
        try (PreparedStatement pstm2 = connection.prepareStatement(sql);){
            pstm2.setInt(1, 1);
            pstm2.setInt(2, resID);
            pstm2.executeUpdate();
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    public void deleteAllResourcesWithMembershipData(Connection connection) throws SQLException {
        try (Statement stm = connection.createStatement();){
            stm.executeUpdate("DELETE FROM " + TBLRESSOURCENUSER);
            stm.executeUpdate("DELETE FROM " + TBLRESSOURCEN);
        }
    }

    public void setParentResourceID(Connection connection, int resID, int parentResID) throws SQLException {
        String sql = String.format("UPDATE %s SET ParentRes = ? WHERE ResID = ?", TBLRESSOURCEN);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, parentResID);
            pstm.setInt(2, resID);
            pstm.executeUpdate();
        }
    }

    public void updateResourceName(Connection connection, GUID groupID, String newResourceName) throws SQLException {
        String sql = String.format("UPDATE %s SET ResBezeichnung = ? WHERE GroupUUID = ?", TBLRESSOURCEN);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setString(1, newResourceName);
            pstm.setString(2, groupID.toString());
            pstm.executeUpdate();
        }
    }
}

