/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.Field;
import com.inet.usersandgroups.api.FieldDisplayNameProvider;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;

public class HDFieldDisplayNameProvider {
    public static final String PLUGIN_ID = "helpdesk";
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.usersandgroups.i18n.LanguageResources", HDFieldDisplayNameProvider.class);

    public static String getDisplayNameForField(String fieldKey) {
        return FieldDisplayNameProvider.getDisplayNameFor((I18nMessages)MSG, (String)fieldKey);
    }

    public static String getDisplayNameForCustomField(Field<?> field) {
        return HDFieldDisplayNameProvider.getDisplayNameForCustomField(field, ClientLocale.getThreadLocale());
    }

    public static String getDisplayNameForCustomField(Field<?> field, Locale locale) {
        TranslationTextConnector connector = (TranslationTextConnector)ServerPluginManager.getInstance().getSingleInstance(TranslationTextConnector.class);
        try {
            Map<String, String> texts = connector.getTranslationTexts(PLUGIN_ID, HDFieldLocator.getTranslationKeyForNewField(field));
            String displayName = texts.get(locale.getLanguage());
            if (displayName != null) {
                return displayName;
            }
            return texts.getOrDefault(Locale.ENGLISH.getLanguage(), "$" + field.getKey() + "$");
        }
        catch (SQLException ex) {
            HDLogger.error("Could not load display name for field with key \"" + field.getKey() + "\" because of following problem:");
            HDLogger.error(ex);
            return "!" + field.getKey() + "!";
        }
    }
}

