/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.standardviews;

import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.ticketmanager.search.SearchTagWorkflowSlave;
import com.inet.id.GUID;
import com.inet.plugin.image.UserAvatar;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;

public class OwnTicketViewDefinition
implements TicketViewFactory {
    public static final String KEY = "mytickets";
    public static final SearchCondition NO_WORKFLOW = new SearchCondition("workflowslave", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagWorkflowSlave.valueAsInt(false));

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getCategoryKey() {
        return "globalviews";
    }

    @Override
    public String getIconKey() {
        GUID currentUserAccountID = UserManager.getRecoveryEnabledInstance().getCurrentUserAccountID();
        if (currentUserAccountID != null) {
            return currentUserAccountID.toString();
        }
        return TicketViewFactory.super.getIconKey();
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        byte[] encode = Base64.getEncoder().encode(UserAvatar.getCircleAvatar((GUID)UserManager.getRecoveryEnabledInstance().getCurrentUserAccountID(), (int)32));
        String encodeToString = "data:image/png;base64," + new String(encode, StandardCharsets.UTF_8);
        try {
            return new URL(encodeToString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public SearchCommand createSearchCommand(GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
        SearchCommand command = new SearchCommand(locale, new SearchExpression[]{new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString()), NO_WORKFLOW});
        return command;
    }
}

