/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.id.GUID;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

class JoinIndexIterator
implements Iterator<Integer> {
    private final Set<Integer> mainIds;
    private final IndexSearchEngine<Integer> mainEngine;
    private final String mainColumn;
    private final boolean forward;
    private final Iterator<Set<GUID>> subIterator;
    private Iterator<Integer> nextIds;
    private Integer next;

    JoinIndexIterator(Set<Integer> mainIds, IndexSearchEngine<Integer> mainEngine, String mainColumn, final IndexSearchEngine<GUID> subEngine, final String subColumn, final boolean forward) {
        this.mainIds = mainIds;
        this.mainEngine = mainEngine;
        this.mainColumn = mainColumn;
        this.forward = forward;
        final SearchTag tag = subEngine.getTag(subColumn);
        switch (tag.getDataType()) {
            case IntegerMap: 
            case StringMap: {
                Map mapData = tag.getMapData();
                final ArrayList entries = new ArrayList(mapData.entrySet());
                Comparator<Map.Entry> comp = Comparator.comparing(Map.Entry::getValue, Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER));
                if (!forward) {
                    comp = Collections.reverseOrder(comp);
                }
                entries.sort(comp);
                this.subIterator = new Iterator<Set<GUID>>(){
                    private Iterator<Map.Entry<Object, String>> it;
                    {
                        this.it = entries.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Set<GUID> next() {
                        Map.Entry<Object, String> entry = this.it.next();
                        return subEngine.simpleSearch(new SearchCommand(subColumn, SearchCondition.SearchTermOperator.Equals, entry.getKey()));
                    }
                };
                break;
            }
            default: {
                this.subIterator = new Iterator<Set<GUID>>(){
                    private Iterator<GUID> it;
                    {
                        this.it = subEngine.createIdsIterator(tag, forward);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Set<GUID> next() {
                        return Collections.singleton(this.it.next());
                    }
                };
            }
        }
    }

    @Nullable
    private Iterator<Integer> getNextIds() {
        if (this.nextIds != null && this.nextIds.hasNext()) {
            return this.nextIds;
        }
        while (this.subIterator.hasNext()) {
            Set<GUID> guid = this.subIterator.next();
            SearchCommand command = new SearchCommand(this.mainColumn, SearchCondition.SearchTermOperator.IN, guid);
            Set ids = this.mainEngine.simpleSearch(command);
            if (ids.size() == 0) continue;
            ArrayList list = new ArrayList(ids);
            list.sort(this.forward ? Comparator.naturalOrder() : Comparator.reverseOrder());
            this.nextIds = list.iterator();
            return this.nextIds;
        }
        this.nextIds = null;
        return null;
    }

    @Override
    public boolean hasNext() {
        Integer nextVal;
        if (this.next != null) {
            return true;
        }
        block0: while (true) {
            Iterator<Integer> ids;
            if ((ids = this.getNextIds()) == null) {
                return false;
            }
            do {
                if (!ids.hasNext()) continue block0;
            } while (!this.mainIds.contains(nextVal = ids.next()));
            break;
        }
        this.next = nextVal;
        return true;
    }

    @Override
    public Integer next() {
        if (this.hasNext()) {
            Integer val = this.next;
            this.next = null;
            return val;
        }
        throw new NoSuchElementException();
    }
}

