/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.SearchTagTicketTags;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeHasAttachments;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOWithCache;
import com.inet.helpdesk.ticketmanager.internal.TicketChangeCollector;
import com.inet.helpdesk.ticketmanager.search.SearchTagBundleSlave;
import com.inet.helpdesk.ticketmanager.search.SearchTagReaStepText;
import com.inet.helpdesk.ticketmanager.search.SearchTagWorkflowSlave;
import com.inet.helpdesk.ticketmanager.search.TicketDataForIndexingVO;
import com.inet.helpdesk.ticketmanager.search.TicketMap;
import com.inet.id.GUID;
import com.inet.plugin.veto.VetoManager;
import com.inet.plugin.veto.VetoType;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.usersandgroups.api.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketSearchDataCache
extends AbstractSearchDataCache<Integer> {
    private TicketReadDAO readDAO;
    private TicketReadDAO readDAOWithoutCache;
    private boolean useCachedDAO = true;
    private List<SearchTag> allSearchTags;
    private List<PluggableTicketSearchTag> pluggableSearchTags;
    private List<SearchTagTicketTags.TicketTag> ticketTags;
    private Map<String, TicketAttribute> attributeMap;
    private Map<String, TicketField> fieldMap;
    private SlaveInfoSearchDataCache slaveInfoSearchDataCache;

    public void init(TicketReadDAO readDAO, List<TicketAttribute<Object>> ticketAttributes, List<TicketField<Object>> ticketFields, List<PluggableTicketSearchTag<Object>> pluggableSearchTags, List<SearchTagTicketTags.TicketTag> ticketTags) {
        if (readDAO == null) {
            throw new IllegalArgumentException("DAO must not be null");
        }
        if (ticketAttributes == null) {
            throw new IllegalArgumentException("list of attributes must not be null");
        }
        if (ticketFields == null) {
            throw new IllegalArgumentException("list of fields must not be null");
        }
        if (pluggableSearchTags == null) {
            throw new IllegalArgumentException("list of pluggable ticket search tags must not be null");
        }
        if (ticketTags == null) {
            throw new IllegalArgumentException("list of ticket tags must not be null");
        }
        if (this.readDAO != null) {
            throw new IllegalStateException("already initialized");
        }
        this.readDAO = readDAO;
        this.readDAOWithoutCache = readDAO instanceof TicketReadDAOWithCache ? ((TicketReadDAOWithCache)readDAO).getInstanceWithoutCache() : readDAO;
        this.attributeMap = Collections.unmodifiableMap(ticketAttributes.stream().collect(Collectors.toMap(Field::getKey, Function.identity())));
        this.fieldMap = Collections.unmodifiableMap(ticketFields.stream().collect(Collectors.toMap(Field::getKey, Function.identity())));
        this.pluggableSearchTags = Collections.unmodifiableList(new ArrayList<PluggableTicketSearchTag<Object>>(pluggableSearchTags));
        this.ticketTags = Collections.unmodifiableList(new ArrayList<SearchTagTicketTags.TicketTag>(ticketTags));
        List indexedAttributes = Collections.unmodifiableList(ticketAttributes.stream().filter(f -> f.getSearchTag() != null).collect(Collectors.toList()));
        List indexedFields = Collections.unmodifiableList(ticketFields.stream().filter(f -> f.getSearchTag() != null).collect(Collectors.toList()));
        List tags = indexedFields.stream().map(Field::getSearchTag).collect(Collectors.toList());
        tags.addAll(indexedAttributes.stream().map(Field::getSearchTag).collect(Collectors.toList()));
        tags.add(new SearchTagReaStepText());
        tags.add(new SearchTagWorkflowSlave());
        tags.add(new SearchTagBundleSlave());
        tags.add(new SearchTagTicketTags());
        for (PluggableTicketSearchTag<Object> pst : pluggableSearchTags) {
            tags.add(pst.getSearchTag());
            pst.addValueChangeListener((ticketID, oldValue, newValue) -> {
                String searchTagKey = pst.getSearchTag().getTag();
                Map<String, Object> oldData = Collections.singletonMap(searchTagKey, oldValue);
                Map<String, Object> newData = Collections.singletonMap(searchTagKey, newValue);
                for (SearchDataCacheChangeListener listener : this.getListeners()) {
                    listener.entryChanged((Object)ticketID, oldData, newData);
                }
            });
        }
        this.allSearchTags = Collections.unmodifiableList(tags);
        this.slaveInfoSearchDataCache = new SlaveInfoSearchDataCache();
    }

    List<SearchTag> getSearchTags() {
        return this.allSearchTags;
    }

    public Map<String, Object> getCacheEntry(@Nonnull Integer ticketID) {
        TicketReadDAO dao = this.useCachedDAO ? this.readDAO : this.readDAOWithoutCache;
        TicketVO ticket = TicketChangeCollector.loadTicketData(dao, ticketID);
        if (ticket == null) {
            return null;
        }
        Supplier<Set<ReaStepTextVO>> reaStepTextsProvider = () -> new HashSet<ReaStepTextVO>(dao.getReaStepTextsForTicket(ticketID).values());
        return this.toMap(ticket, reaStepTextsProvider);
    }

    public Iterator<Integer> iterator() {
        this.useCachedDAO = false;
        return new Iterator<Integer>(){
            private final Iterator<Integer> it;
            {
                this.it = TicketSearchDataCache.this.readDAOWithoutCache.getTicketIdIterator();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = this.it.hasNext();
                if (!hasNext) {
                    TicketSearchDataCache.this.useCachedDAO = true;
                }
                return hasNext;
            }

            @Override
            public Integer next() {
                return this.it.next();
            }
        };
    }

    public void ticketCreated(@Nonnull TicketDataForIndexingVO ticketData) {
        TicketVO ticket = ticketData.getTicket();
        Map<String, Object> data = this.toMap(ticket, () -> ticketData.getReaStepTexts());
        for (SearchDataCacheChangeListener listener : this.getListeners()) {
            listener.entryAdded((Object)ticket.getID(), data);
        }
    }

    public void ticketDeleted(@Nonnull TicketDataForIndexingVO ticketData) {
        TicketVO ticket = ticketData.getTicket();
        Map<String, Object> data = this.toMap(ticket, () -> ticketData.getReaStepTexts());
        Integer ticketID = ticket.getID();
        for (SearchDataCacheChangeListener listener : this.getListeners()) {
            listener.entryRemoved((Object)ticketID, data);
        }
        SlaveInfo slave = TicketSearchDataCache.getOldSlaveInfo(ticketID);
        if (slave != null) {
            data = this.toSlaveInfoMap(ticketID);
            for (SearchDataCacheChangeListener<SlaveInfo> listener : this.slaveInfoSearchDataCache.getListeners()) {
                listener.entryRemoved((Object)slave, data);
            }
        }
    }

    public void ticketUpdated(@Nonnull TicketDataForIndexingVO oldTicketData, @Nonnull TicketDataForIndexingVO newTicketData) {
        Integer ticketID = oldTicketData.getTicket().getID();
        Map<String, Object> oldData = this.toMap(oldTicketData);
        Map<String, Object> newData = this.toMap(newTicketData);
        boolean newAttachmentFlagValue = newTicketData.getTicket().hasAttachments();
        for (SearchDataCacheChangeListener listener : this.getListeners()) {
            this.removeValueOppositeToNewAttachmentFlag((SearchDataCacheChangeListener<Integer>)listener, ticketID, newAttachmentFlagValue);
            listener.entryChanged((Object)ticketID, oldData, newData);
        }
        if (oldTicketData.getTicket().isSlaveInBundle() || newTicketData.getTicket().isSlaveInBundle()) {
            SlaveInfo newSlave;
            TicketVO ticket = newTicketData.getTicket();
            if (ticket.isSlaveInBundle()) {
                TicketVO master = TicketManager.getReaderForSystem().getTicket(ticket.getBundleID());
                GUID ownerID = master.getOwnerID();
                newSlave = new SlaveInfo(ticket.getID(), ticket.getBundleID(), ownerID, ticket.getResourceID());
            } else {
                newSlave = null;
            }
            SlaveInfo oldSlave = TicketSearchDataCache.getOldSlaveInfo(ticketID);
            if (!Objects.equals(newSlave, oldSlave)) {
                Map<String, Object> data = this.toSlaveInfoMap(ticketID);
                for (SearchDataCacheChangeListener<SlaveInfo> listener : this.slaveInfoSearchDataCache.getListeners()) {
                    if (oldSlave != null) {
                        listener.entryRemoved((Object)oldSlave, data);
                    }
                    if (newSlave == null) continue;
                    listener.entryAdded((Object)newSlave, data);
                }
            }
        }
    }

    public void indexTicketTagDeadlineFailed(int ticketID) {
        HashMap oldData = new HashMap();
        HashMap<String, Integer> newData = new HashMap<String, Integer>();
        newData.put("tickettags", 2);
        for (SearchDataCacheChangeListener listener : this.getListeners()) {
            listener.entryChanged((Object)ticketID, oldData, newData);
        }
    }

    @Nullable
    private static SlaveInfo getOldSlaveInfo(Integer ticketID) {
        VetoType currentType = VetoManager.getInstance().getCurrentType();
        if (currentType != null && currentType.compareTo(TicketManagerVetoPower.TYPE) < 0) {
            TicketManagerVetoPower.requestReIndexing();
            return null;
        }
        SearchCommand command = new SearchCommand("aufid", SearchCondition.SearchTermOperator.Equals, (Object)ticketID);
        Set search = TicketManager.getReader().getSlaveInfoEngine().simpleSearch(command);
        return search.isEmpty() ? null : (SlaveInfo)search.iterator().next();
    }

    private void removeValueOppositeToNewAttachmentFlag(SearchDataCacheChangeListener<Integer> listener, Integer ticketID, boolean newAttachmentFlagValue) {
        HashMap<String, Integer> oldData = new HashMap<String, Integer>();
        oldData.put("attachments", TicketAttributeHasAttachments.valueAsInt(!newAttachmentFlagValue));
        listener.entryChanged((Object)ticketID, oldData, new HashMap());
    }

    private Map<String, Object> toMap(TicketDataForIndexingVO ticketData) {
        return this.toMap(ticketData.getTicket(), () -> ticketData.getReaStepTexts());
    }

    @Nonnull
    private Map<String, Object> toMap(TicketVO ticket, Supplier<Set<ReaStepTextVO>> reaStepTextsProvider) {
        return new TicketMap(ticket, reaStepTextsProvider, this.fieldMap, this.attributeMap, this.pluggableSearchTags, this.ticketTags);
    }

    private Map<String, Object> toSlaveInfoMap(Integer ticketID) {
        return Collections.singletonMap("aufid", ticketID);
    }

    SlaveInfoSearchDataCache getSlaveInfoSearchDataCache() {
        return this.slaveInfoSearchDataCache;
    }

    class SlaveInfoSearchDataCache
    extends AbstractSearchDataCache<SlaveInfo> {
        SlaveInfoSearchDataCache() {
        }

        public Map<String, Object> getCacheEntry(SlaveInfo slave) {
            return Collections.singletonMap("aufid", slave.getAufID());
        }

        public Iterator<SlaveInfo> iterator() {
            return TicketSearchDataCache.this.readDAOWithoutCache.getSlaveInfoIterator();
        }

        protected SearchDataCacheChangeListener<SlaveInfo>[] getListeners() {
            return super.getListeners();
        }
    }
}

