/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.data.TableOptionsIntermediateWriter;
import com.inet.helpdesk.ticketmanager.internal.MandatoryFieldsManagerImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nullable;

public class DefaultValueManagerImpl
implements DefaultValuesManager {
    private static final UserField[] IDENTIFIER_FIELD_SETTINGS = new UserField[]{null, HDUsersAndGroups.FIELD_COMPUTER_NAME, HDUsersAndGroups.FIELD_COST_CENTRE, HDUsersAndGroups.FIELD_DEPARTMENT, HDUsersAndGroups.FIELD_CUSTOM_1};
    private Integer prioDefault;
    private Integer slaSettings = 0;
    public int spezFeld_Def;
    private static final ConfigValue<Integer> DEFAULT_USER_LOCATION_ID = new ConfigValue<Integer>(HDConfigKeys.DEFAULT_USER_LOCATION_ID){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            HDUsersAndGroups.FIELD_LOCATION_ID.setDefaultValue((Integer)this.get());
            TableOptionsIntermediateWriter.of(TableOptionsIntermediateWriter.Option.USER_LOCATION).updateField((Integer)this.get());
        }
    };
    private static final ConfigValue<Integer> DEFAULT_TICKET_ITIL_ID = new ConfigValue<Integer>(HDConfigKeys.DEFAULT_TICKET_ITIL_ID){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            Tickets.FIELD_ITIL_ID.setDefaultValue((Integer)this.get());
            MandatoryFieldsManagerImpl.settingsCouldHaveChanged();
            TableOptionsIntermediateWriter.of(TableOptionsIntermediateWriter.Option.TICKET_ITIL).updateField((Integer)this.get());
        }
    };

    public static DefaultValueManagerImpl getInstance() {
        return (DefaultValueManagerImpl)ServerPluginManager.getInstance().getSingleInstance(DefaultValuesManager.class);
    }

    public void init(Connection con) {
        ResultSet rs;
        Statement st;
        Connection conInternal = null;
        if (con == null) {
            try {
                ConnectionFactory conFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                conInternal = con = conFactory.getConnection();
            }
            catch (SQLException sqlex) {
                HDLogger.error(sqlex);
            }
        }
        try {
            st = con.createStatement();
            try {
                rs = st.executeQuery("SELECT PriID, PrioSelection FROM tblOptionen");
                try {
                    rs.next();
                    this.prioDefault = rs.getInt("PriID");
                    this.slaSettings = rs.getInt("PrioSelection");
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        catch (SQLException sqlex) {
            HDLogger.error(sqlex);
        }
        try {
            st = con.createStatement();
            try {
                rs = st.executeQuery("SELECT Selektion FROM tblSettings WHERE tblSettings.SetID = 13");
                try {
                    rs.next();
                    this.spezFeld_Def = rs.getInt("Selektion");
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        catch (SQLException sqlex) {
            HDLogger.error(sqlex);
        }
        if (conInternal != null) {
            try {
                conInternal.close();
            }
            catch (Exception ex) {
                HDLogger.error(ex);
            }
        }
        MandatoryFieldsManagerImpl.settingsCouldHaveChanged();
    }

    @Override
    public Integer getPriorityDefault() {
        return this.prioDefault;
    }

    @Override
    public boolean hasSlaSettings() {
        return this.slaSettings > 0;
    }

    @Override
    public Integer getSlaSettings() {
        return this.slaSettings;
    }

    @Override
    public UserField<String> getFieldForIdentifierValue() {
        return IDENTIFIER_FIELD_SETTINGS[this.spezFeld_Def];
    }

    @Override
    public Integer getDefaultPriorityID(UserAccount userAccount) {
        PriorityVO privo;
        UserGroupVO userGroup;
        Integer usergroupID;
        Integer slaPrid = null;
        if (this.slaSettings == 1) {
            LocationVO location;
            Integer locationID;
            if (userAccount != null && (locationID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)) != null && (location = (LocationVO)LocationManager.getInstance().get(locationID)) != null) {
                slaPrid = location.getSLA_PriID();
            }
        } else if (this.slaSettings == 2 && userAccount != null && (usergroupID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_GROUP_ID)) != null && (userGroup = (UserGroupVO)UserGroupVOManager.getInstance().get(usergroupID)) != null) {
            slaPrid = userGroup.getSLAID();
        }
        if (slaPrid != null && (privo = (PriorityVO)PriorityManager.getInstance().get(slaPrid)) != null && !privo.isDeleted()) {
            return slaPrid;
        }
        return this.getPriorityDefault();
    }
}

