/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.extensions;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import java.text.SimpleDateFormat;

public class ProcessingTimeActionExtensionFactory
implements TicketActionExtensionFactory {
    @Override
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, int actionID, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        Long terminDate = arguments.get(ExtensionArguments.EXTARG_APPOINTMENT) instanceof Long ? arguments.get(ExtensionArguments.EXTARG_APPOINTMENT) : null;
        ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionID);
        if (actionVO.getId() == -3 && terminDate == null) {
            String msg = "For action " + actionID + " a wiedervorlageDate must be specified. Use ExtensionArguments.EXTARG_APPOINTMENT.";
            HDLogger.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (actionVO.getId() == -3 && terminDate < System.currentTimeMillis()) {
            String msg = Tickets.MSG.getMsg("error.appointmentNotInPast", new Object[0]);
            HDLogger.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (actionVO.getId() == 10 && terminDate == null) {
            String msg = "For action " + actionID + " a terminVereinbarung must be specified. Use ExtensionArguments.EXTARG_APPOINTMENT.";
            HDLogger.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        return new ProcessingTimeActionExtension(terminDate);
    }

    private class ProcessingTimeActionExtension
    implements TicketActionExtension {
        private static final int UPDATE_DATE = 1;
        private static final int RESET_DATE = 2;
        private static final int LEAVE_DATE = 3;
        private final Long termin;

        public ProcessingTimeActionExtension(Long termin) {
            this.termin = termin;
        }

        @Override
        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            Long wiedervorlageDate;
            boolean isWiedervorlegenAction;
            boolean isTerminAction = action.getId() == 10;
            boolean bl = isWiedervorlegenAction = action.getId() == -3;
            if (reaStep.getFields().get(ReaStepVO.FIELD_DESC) == null || reaStep.getFields().get(ReaStepVO.FIELD_DESC).trim().isEmpty()) {
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                String dateString = null;
                if (this.termin != null && (isWiedervorlegenAction || isTerminAction)) {
                    dateString = formatter.format(this.termin);
                }
                if (dateString != null) {
                    reaStep.getFields().put(ReaStepVO.FIELD_DESC, dateString);
                }
            }
            int updateTicketWithWiedervorlageDate = 3;
            if (isWiedervorlegenAction) {
                updateTicketWithWiedervorlageDate = 1;
            } else if (!isWiedervorlegenAction && action.getStatusID() != -100 && action.getStatusID() != 150 && (wiedervorlageDate = ticket.getFieldValue(Tickets.FIELD_WIEDERVORLAGEDATE)) != null) {
                updateTicketWithWiedervorlageDate = 2;
            }
            if (updateTicketWithWiedervorlageDate != 3) {
                ticket.getNewTicketData().put(Tickets.FIELD_WIEDERVORLAGEDATE, updateTicketWithWiedervorlageDate == 1 ? this.termin : null);
            }
            if (isTerminAction || action.getId() == -25) {
                ticket.getNewTicketData().put(Tickets.FIELD_TERMINVEREINBARUNG, action.getId() == -25 ? null : this.termin);
            }
        }
    }
}

