/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.shared.model.Status;

public class CloseTicketActionExtensionFactory
implements TicketActionExtensionFactory {
    @Override
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, int actionID, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionID);
        if (actionVO != null && Status.isClosedOrDeletedStatus(actionVO.getStatusID())) {
            return new CloseTicketActionExtension();
        }
        return null;
    }

    private class CloseTicketActionExtension
    implements TicketActionExtension {
        @Override
        public void extendTicketAction(ActionVO action, OperationChangedTicket opTicket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            opTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_CLOSE_DATE, System.currentTimeMillis());
        }
    }
}

