/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.dao;

import com.inet.error.ErrorCode;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.TicketDeletionMaintenanceListener;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPersistenceUnit;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.StorageLocationInfo;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeHasAttachments;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldCustomField;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.ticketmanager.dao.ReaStepPersistenceUnit;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOCacheCleaner;
import com.inet.helpdesk.ticketmanager.model.RegisteredTicketFieldsContainer;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class TicketWriteDAO {
    private static final Map<TicketFieldCustomField, String> CUSTOM_FIELD_TO_COLUMN_NAME = Collections.unmodifiableMap(new HashMap<TicketFieldCustomField, String>(){
        {
            this.put(Tickets.FIELD_CUSTOM_1, "BunFeld1");
            this.put(Tickets.FIELD_CUSTOM_2, "BunFeld2");
            this.put(Tickets.FIELD_CUSTOM_3, "BunFeld3");
            this.put(Tickets.FIELD_CUSTOM_4, "BunFeld4");
            this.put(Tickets.FIELD_CUSTOM_5, "BunFeld5");
            this.put(Tickets.FIELD_CUSTOM_6, "BunFeld6");
            this.put(Tickets.FIELD_CUSTOM_7, "BunFeld7");
        }
    });
    private final ConnectionFactory connectionFactory;
    private final TicketReadDAOCacheCleaner cacheCleaner;
    private RegisteredTicketFieldsContainer registeredFields;
    private static final boolean INSERT = true;
    private static final boolean UPDATE = false;

    public TicketWriteDAO(ConnectionFactory connectionFactory, TicketReadDAOCacheCleaner cacheCleaner) {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connection factory must not be null");
        }
        if (cacheCleaner == null) {
            throw new IllegalArgumentException("cache cleaner must not be null");
        }
        this.connectionFactory = connectionFactory;
        this.cacheCleaner = cacheCleaner;
    }

    public void init(@Nonnull List<TicketField> ticketFields, List<ReaStepField> reaStepFields) {
        this.registeredFields = new RegisteredTicketFieldsContainer(ticketFields, reaStepFields);
    }

    public <R> R inTransaction(Callable<R> operation) {
        try {
            return (R)DatabaseTransactionUtils.executeAsTransaction(this.connectionFactory, connection -> {
                try {
                    return operation.call();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw PersistenceException.createWithCode((Throwable)e, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
                }
            });
        }
        catch (SQLException e) {
            throw PersistenceException.createWithCode((Throwable)e, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    public void updateLastChanged(int ticketID, long lastChanged) {
        try (Connection con = this.connectionFactory.getConnection();){
            this.updateLastChanged(con, ticketID, lastChanged);
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    private void updateLastChanged(Connection con, int ticketID, long lastChanged) throws SQLException {
        String sql = "UPDATE tblBuendel SET BearbeitungsDatum=?, Indiziert=0 WHERE BunID=?";
        try (PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setTimestamp(1, new Timestamp(lastChanged));
            pstm.setInt(2, ticketID);
            pstm.executeUpdate();
        }
    }

    private String get50CharacterDisplayName(UserAccount user) {
        if (user == null) {
            return null;
        }
        String displayName = user.getDisplayName();
        if (displayName.length() > 0 && displayName.length() <= 50) {
            return displayName;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateReaStepText(int reaStepID, ReaStepTextVO text, boolean initialStep, int ticketID) {
        String sql = "UPDATE tblRealisierung SET was = ?, ishtml = ? WHERE ReaID = ?";
        if (initialStep) {
            String auftragSql = "UPDATE tblAuftraege SET Auftrag = ?, ishtml = ? WHERE AufID = ?";
            try (Connection con = this.connectionFactory.getConnection();
                 PreparedStatement pstm = con.prepareStatement(auftragSql);){
                pstm.setString(1, text.getText());
                pstm.setInt(2, text.hasHtmlContent() ? 1 : 0);
                pstm.setInt(3, ticketID);
                pstm.executeUpdate();
            }
            catch (SQLException ex) {
                throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
            }
        }
        try (Connection con = this.connectionFactory.getConnection();){
            boolean bl;
            block30: {
                PreparedStatement pstm = con.prepareStatement(sql);
                try {
                    pstm.setString(1, text.getText());
                    pstm.setInt(2, text.hasHtmlContent() ? 1 : 0);
                    pstm.setInt(3, reaStepID);
                    boolean bl2 = bl = pstm.executeUpdate() > 0;
                    if (pstm == null) break block30;
                }
                catch (Throwable throwable) {
                    if (pstm != null) {
                        try {
                            pstm.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstm.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    public void updateTicketData(int ticketID, @Nonnull MutableTicketAttributes ticketAttributes, @Nonnull MutableTicketData ticketData) {
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.connectionFactory, connection -> {
                if (ticketData.containsKey(Tickets.FIELD_DEADLINE)) {
                    this.updateDeadlineExFlagIfDeadlineIsGoingToBeUpdated(connection, ticketID, ticketData.get(Tickets.FIELD_DEADLINE));
                }
                this.writeTblBuendel(connection, ticketID, ticketAttributes, ticketData, false);
                this.writeTblAuftraege(connection, ticketID, ticketData, ticketAttributes, false);
                this.updateTblTicketBinary(connection, ticketID, ticketData);
                return null;
            });
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    private void updateDeadlineExFlagIfDeadlineIsGoingToBeUpdated(Connection connection, int ticketID, @Nullable Long newDeadline) throws SQLException {
        try (Statement stm = connection.createStatement();
             ResultSet rs = stm.executeQuery(String.format("SELECT DeadlineZeit FROM tblAuftraege WHERE AufID = %d", ticketID));){
            if (rs.next()) {
                Long deadline;
                Timestamp timestamp = rs.getTimestamp(1);
                Long l = deadline = timestamp == null ? null : Long.valueOf(timestamp.getTime());
                if (!Objects.equals(deadline, newDeadline)) {
                    stm.executeUpdate(String.format("UPDATE tblBuendel SET DeadLine = 0 WHERE BunID = %d", ticketID));
                }
            }
        }
    }

    public void updateDeadlineExFlag(int ticketID, boolean value) {
        int intValue = value ? 1 : 0;
        String sql = String.format("UPDATE tblBuendel SET DeadLine = %d WHERE BunID = %d", intValue, ticketID);
        try (Connection con = this.connectionFactory.getConnection();
             Statement stm = con.createStatement();){
            stm.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    private void updateTblTicketBinary(Connection connection, int ticketID, MutableTicketData ticketData) throws SQLException {
        TicketPersistenceUnit updatedDetails;
        Set<TicketField<Object>> fieldsToInclude = this.getIncludedAdditionalFields(ticketData);
        if (fieldsToInclude.isEmpty()) {
            return;
        }
        TicketPersistenceUnit currentDetails = this.loadTicketDetails(connection, ticketID);
        if (currentDetails.equals(updatedDetails = this.updateTicketPersistenceUnit(currentDetails, ticketData, fieldsToInclude))) {
            return;
        }
        this.deleteTicketDetails(connection, ticketID);
        this.insertTicketDetails(connection, ticketID, updatedDetails);
    }

    private TicketPersistenceUnit updateTicketPersistenceUnit(TicketPersistenceUnit currentDetails, MutableTicketData ticketData, Set<TicketField<Object>> fieldsToInclude) {
        HashMap<String, String> jsonizedValues = new HashMap<String, String>(currentDetails.getFields());
        for (TicketField<Object> field : fieldsToInclude) {
            Object value = ticketData.get(field);
            String jsonData = new Json().toJson(value);
            jsonizedValues.put(field.getKey(), jsonData);
        }
        return new TicketPersistenceUnit(currentDetails.getProperties(), jsonizedValues);
    }

    private Set<TicketField<Object>> getIncludedAdditionalFields(MutableTicketData ticketData) {
        Set<TicketField<Object>> includedAdditionalFields = ticketData.getIncludedFields();
        includedAdditionalFields.retainAll(this.registeredFields.getAdditionalFields());
        return includedAdditionalFields;
    }

    /*
     * Loose catch block
     */
    private TicketPersistenceUnit loadTicketDetails(Connection connection, int ticketID) throws SQLException {
        String sql = "SELECT Data FROM tblTicketBinary WHERE TicketID = ? AND DataKey = ?";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            TicketPersistenceUnit ticketPersistenceUnit;
            block19: {
                ResultSet rs;
                block17: {
                    TicketPersistenceUnit ticketPersistenceUnit2;
                    block18: {
                        pstm.setInt(1, ticketID);
                        pstm.setString(2, "ticketdetails");
                        rs = pstm.executeQuery();
                        if (rs.next()) break block17;
                        HDLogger.debug("[TicketWriteDAO] Add new details for ticket with ID: " + ticketID);
                        ticketPersistenceUnit2 = TicketPersistenceUnit.createReplacementForCorruptedData();
                        if (rs == null) break block18;
                        rs.close();
                    }
                    return ticketPersistenceUnit2;
                }
                InputStream inputStream = rs.getBinaryStream(1);
                ticketPersistenceUnit = (TicketPersistenceUnit)new Json().fromJson(inputStream, TicketPersistenceUnit.class);
                if (rs == null) break block19;
                {
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (JsonException | IOException ex) {
                            HDLogger.error("[TicketWriteDAO] Could not read details of ticket with ID: " + ticketID);
                            HDLogger.error(ex);
                            TicketPersistenceUnit ticketPersistenceUnit3 = TicketPersistenceUnit.createReplacementForCorruptedData();
                            return ticketPersistenceUnit3;
                        }
                    }
                }
                rs.close();
            }
            return ticketPersistenceUnit;
        }
    }

    public void insertEmptyTicketDetailsIfMissingAndClearInCache(int ticketID) {
        try (Connection con = this.connectionFactory.getConnection();){
            boolean detailsAreMissing = false;
            String sql = "SELECT 1 FROM tblTicketBinary WHERE TicketID = ? AND DataKey = ?";
            try (PreparedStatement pstm = con.prepareStatement(sql);){
                pstm.setInt(1, ticketID);
                pstm.setString(2, "ticketdetails");
                try (ResultSet rs = pstm.executeQuery();){
                    detailsAreMissing = !rs.next();
                }
            }
            if (detailsAreMissing) {
                this.insertTicketDetails(con, ticketID, TicketPersistenceUnit.createReplacementForCorruptedData());
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        finally {
            this.cacheCleaner.clearTicket(ticketID);
        }
    }

    private void deleteTicketDetails(Connection connection, int ticketID) throws SQLException {
        String sqlDelete = "DELETE FROM tblTicketBinary WHERE TicketID = ? AND DataKey = ?";
        try (PreparedStatement pstm = connection.prepareStatement(sqlDelete);){
            pstm.setInt(1, ticketID);
            pstm.setString(2, "ticketdetails");
            pstm.executeUpdate();
        }
    }

    private void insertTicketDetails(Connection connection, int ticketID, TicketPersistenceUnit details) throws SQLException {
        String jsonData = new Json().toJson((Object)details);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonData.getBytes(StandardCharsets.UTF_8));
        String sql = "INSERT INTO tblTicketBinary (TicketID, DataKey, Data) VALUES (?, ?, ?)";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, ticketID);
            pstm.setString(2, "ticketdetails");
            pstm.setBinaryStream(3, inputStream);
            pstm.executeUpdate();
        }
    }

    private void writeTblBuendel(Connection connection, int ticketID, MutableTicketAttributes attributes, MutableTicketData data, boolean insertElseUpdate) throws SQLException {
        block28: {
            GUID editorID;
            ArrayList<SqlColumnValue> values = new ArrayList<SqlColumnValue>();
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_LAST_CHANGED)) {
                long value = attributes.get(Tickets.ATTRIBUTE_LAST_CHANGED);
                values.add(new SqlColumnValue("BearbeitungsDatum", (pst, index) -> pst.setTimestamp(index, new Timestamp(value))));
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_LAST_EDITOR_GUID) && !this.updateLastEditorDisplayNameAndID(values, editorID = attributes.get(Tickets.ATTRIBUTE_LAST_EDITOR_GUID))) {
                HDLogger.error("Cannot update last_Editor because account cannot be found: " + editorID);
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_ATTACHMENTS)) {
                values.add(new SqlColumnValue("Anlagen", (pst, index) -> pst.setBoolean(index, attributes.get(Tickets.ATTRIBUTE_ATTACHMENTS))));
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_INQUIRY_DATE)) {
                Long value = attributes.get(Tickets.ATTRIBUTE_INQUIRY_DATE);
                values.add(new SqlColumnValue("AnfrageDatum", (pst, index) -> {
                    if (value == null) {
                        pst.setTimestamp(index, null);
                    } else {
                        pst.setTimestamp(index, new Timestamp(value));
                    }
                }));
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_CLOSE_DATE)) {
                values.add(new SqlColumnValue("CloseDate", (pst, index) -> {
                    Long date = attributes.get(Tickets.ATTRIBUTE_CLOSE_DATE);
                    if (date == null) {
                        pst.setTimestamp(index, null);
                    } else {
                        pst.setTimestamp(index, new Timestamp(date));
                    }
                }));
            }
            if (data.containsKey(Tickets.FIELD_TARGET_TIME)) {
                this.updateTargetTime(values, data.get(Tickets.FIELD_TARGET_TIME));
            }
            if (data.containsKey(Tickets.FIELD_WIEDERVORLAGEDATE)) {
                this.updateWiedervorlageDate(values, data.get(Tickets.FIELD_WIEDERVORLAGEDATE));
            }
            if (data.containsKey(Tickets.FIELD_TERMINVEREINBARUNG)) {
                this.updateTerminvereinbarung(values, data.get(Tickets.FIELD_TERMINVEREINBARUNG));
            }
            for (TicketFieldCustomField customField : CUSTOM_FIELD_TO_COLUMN_NAME.keySet()) {
                if (!data.containsKey(customField)) continue;
                this.updateCustomField(values, customField, data.get(customField));
            }
            if (data.containsKey(Tickets.FIELD_ANNOTATION)) {
                values.add(new SqlColumnValue("Anmerkung", (pst, index) -> pst.setString(index, data.get(Tickets.FIELD_ANNOTATION))));
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_BUNDLE_ID)) {
                this.updateBundle_tblBundle(values, attributes.get(Tickets.ATTRIBUTE_BUNDLE_ID), ticketID);
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_STATUS_ID)) {
                values.add(new SqlColumnValue("Status", (pst, index) -> pst.setInt(index, attributes.get(Tickets.ATTRIBUTE_STATUS_ID))));
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_SUM_TIME)) {
                values.add(new SqlColumnValue("SummeZeit", (pst, index) -> pst.setInt(index, attributes.get(Tickets.ATTRIBUTE_SUM_TIME))));
            }
            this.updateFieldsAndAttributesFromPluginsHavingValuesInTblBuendel(values, data, attributes);
            if (!values.isEmpty()) {
                PreparedStatement pst2;
                if (!insertElseUpdate) {
                    pst2 = this.constructUpdateStatement(connection, values, "tblBuendel", "BunID = " + ticketID);
                    try {
                        int executeUpdate = pst2.executeUpdate();
                        if (executeUpdate == 0) {
                            throw new PersistenceException(Tickets.MSG.getMsg("error.ticketDoesNotExist", new Object[]{ticketID}));
                        }
                        break block28;
                    }
                    finally {
                        if (pst2 != null) {
                            pst2.close();
                        }
                    }
                }
                values.add(new SqlColumnValue("BunID", (pst, index) -> pst.setInt(index, ticketID)));
                pst2 = this.constructInsertStatement(connection, values, "tblBuendel");
                try {
                    pst2.executeUpdate();
                }
                finally {
                    if (pst2 != null) {
                        pst2.close();
                    }
                }
            }
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    private PreparedStatement constructUpdateStatement(Connection con, List<SqlColumnValue> values, String tableName, String whereBlock) throws SQLException {
        StringBuilder insert = new StringBuilder("UPDATE ");
        insert.append(tableName).append(" SET ");
        for (SqlColumnValue column : values) {
            insert.append(column.columnName);
            insert.append(" = ?,");
        }
        insert.setCharAt(insert.length() - 1, ' ');
        insert.append(" WHERE ").append(whereBlock);
        PreparedStatement pst = con.prepareStatement(insert.toString());
        int index = 1;
        for (SqlColumnValue fct : values) {
            fct.valueFunction.run(pst, index++);
        }
        return pst;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    private PreparedStatement constructInsertStatement(Connection con, List<SqlColumnValue> values, String tableName) throws SQLException {
        StringBuilder insert = new StringBuilder("INSERT INTO ");
        insert.append(tableName).append("(");
        for (SqlColumnValue column : values) {
            insert.append(column.columnName);
            insert.append(",");
        }
        insert.setCharAt(insert.length() - 1, ')');
        insert.append(" VALUES (");
        for (SqlColumnValue column : values) {
            insert.append("?,");
        }
        insert.setCharAt(insert.length() - 1, ')');
        PreparedStatement pst = con.prepareStatement(insert.toString());
        int index = 1;
        for (SqlColumnValue fct : values) {
            fct.valueFunction.run(pst, index++);
        }
        return pst;
    }

    private void updateFieldsAndAttributesFromPluginsHavingValuesInTblBuendel(List<SqlColumnValue> values, MutableTicketData data, MutableTicketAttributes attributes) throws SQLException {
        Object value;
        String columnName;
        StorageLocationInfo<Object> info;
        for (TicketField<Object> ticketField : data.getIncludedFields()) {
            info = ticketField.getStorageLocationInfo();
            if (info == null || !StorageLocationInfo.DbTable.TBLBUENDEL.equals((Object)info.getTable())) continue;
            columnName = info.getColumnName();
            value = info.convertToValueToStore(data.get(ticketField));
            values.add(new SqlColumnValue(columnName, (pst, index) -> pst.setObject(index, value)));
        }
        for (TicketAttribute ticketAttribute : attributes.getIncludedAttributes()) {
            info = ticketAttribute.getStorageLocationInfo();
            if (info == null || !StorageLocationInfo.DbTable.TBLBUENDEL.equals((Object)info.getTable())) continue;
            columnName = info.getColumnName();
            value = info.convertToValueToStore(attributes.get(ticketAttribute));
            values.add(new SqlColumnValue(columnName, (pst, index) -> pst.setObject(index, value)));
        }
    }

    private boolean updateLastEditorDisplayNameAndID(List<SqlColumnValue> values, @Nullable GUID editorID) throws SQLException {
        if (editorID == null || editorID.equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID)) {
            return true;
        }
        UserAccount editorAccount = UserManager.getInstance().getUserAccount(editorID);
        if (editorAccount != null) {
            int lastEditorID = HDUsersAndGroups.getUserID(editorAccount);
            values.add(new SqlColumnValue("LastEditorID", (pst, index) -> pst.setInt(index, lastEditorID)));
            values.add(new SqlColumnValue("Bearbeiter", (pst, index) -> pst.setString(index, this.get50CharacterDisplayName(editorAccount))));
            return true;
        }
        return false;
    }

    private void updateCustomField(List<SqlColumnValue> values, TicketFieldCustomField customField, @Nonnull String value) throws SQLException {
        String column = CUSTOM_FIELD_TO_COLUMN_NAME.get((Object)customField);
        values.add(new SqlColumnValue(column, (pst, index) -> pst.setString(index, (String)(value != null && value.isEmpty() ? null : value))));
    }

    private void updateTargetTime(List<SqlColumnValue> values, @Nullable Integer targetTime) throws SQLException {
        values.add(new SqlColumnValue("SollZeit", (pst, index) -> {
            if (targetTime == null) {
                pst.setNull(index, 4);
            } else {
                pst.setInt(index, targetTime);
            }
        }));
    }

    private void updateWiedervorlageDate(List<SqlColumnValue> values, @Nullable Long wiedervorlageDate) throws SQLException {
        values.add(new SqlColumnValue("WiedervorlageDatum", (pst, index) -> pst.setTimestamp(index, wiedervorlageDate == null ? null : new Timestamp(wiedervorlageDate))));
    }

    private void updateTerminvereinbarung(List<SqlColumnValue> values, @Nullable Long terminVereinbarung) throws SQLException {
        values.add(new SqlColumnValue("TerminVereinbarung", (pst, index) -> pst.setTimestamp(index, terminVereinbarung == null ? null : new Timestamp(terminVereinbarung))));
    }

    private void writeTblAuftraege(Connection connection, int ticketID, MutableTicketData data, MutableTicketAttributes attributes, boolean insertElseUpdate) throws SQLException {
        block29: {
            ArrayList<SqlColumnValue> values = new ArrayList<SqlColumnValue>();
            if (data.containsKey(Tickets.FIELD_RESOURCE_GUID)) {
                this.updateResourceID(values, data.get(Tickets.FIELD_RESOURCE_GUID));
            }
            if (data.containsKey(Tickets.FIELD_PRIORITY_ID)) {
                values.add(new SqlColumnValue("PriID", (pst, index) -> pst.setInt(index, data.get(Tickets.FIELD_PRIORITY_ID))));
            }
            if (data.containsKey(Tickets.FIELD_SUBJECT)) {
                this.updateSubject(values, data.get(Tickets.FIELD_SUBJECT));
            }
            if (data.containsKey(Tickets.FIELD_OWNER_GUID) && !this.updateTicketOwner(values, data.get(Tickets.FIELD_OWNER_GUID))) {
                throw new SQLException("User " + data.get(Tickets.FIELD_OWNER_GUID) + " does not exist.");
            }
            if (data.containsKey(Tickets.FIELD_DEADLINE)) {
                this.updateDeadline(values, data.get(Tickets.FIELD_DEADLINE));
            }
            if (data.containsKey(Tickets.FIELD_IDENTIFIER)) {
                this.updateIdentifier(values, data.get(Tickets.FIELD_IDENTIFIER));
            }
            if (data.containsKey(Tickets.FIELD_ITIL_ID)) {
                values.add(new SqlColumnValue("ItiID", (pst, index) -> pst.setInt(index, data.get(Tickets.FIELD_ITIL_ID))));
            }
            if (data.containsKey(Tickets.FIELD_CLASSIFICATION_ID)) {
                values.add(new SqlColumnValue("KlaID", (pst, index) -> pst.setInt(index, data.get(Tickets.FIELD_CLASSIFICATION_ID))));
            }
            if (data.containsKey(Tickets.FIELD_CATEGORY_ID)) {
                this.updateCategoryID(values, data.get(Tickets.FIELD_CATEGORY_ID));
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_BUNDLE_ID) || insertElseUpdate) {
                this.updateBundle_tblAuftraege(values, attributes.get(Tickets.ATTRIBUTE_BUNDLE_ID), ticketID);
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID)) {
                values.add(new SqlColumnValue("AnfReaID", (pst, index) -> pst.setInt(index, attributes.get(Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID))));
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID)) {
                values.add(new SqlColumnValue("AutorisierenReaID", (pst, index) -> pst.setInt(index, attributes.get(Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID))));
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_AUTOESCALATED)) {
                values.add(new SqlColumnValue("AutoEscalated", (pst, index) -> pst.setBoolean(index, attributes.get(Tickets.ATTRIBUTE_AUTOESCALATED))));
            }
            if (attributes.containsAttribute(Tickets.ATTRIBUTE_EMAIL_EINGANG)) {
                values.add(new SqlColumnValue("EmailEingang", (pst, index) -> pst.setString(index, attributes.get(Tickets.ATTRIBUTE_EMAIL_EINGANG))));
            }
            if (!values.isEmpty()) {
                if (!insertElseUpdate) {
                    try (PreparedStatement pst2 = this.constructUpdateStatement(connection, values, "tblAuftraege", "AufID = " + ticketID);){
                        int updated = pst2.executeUpdate();
                        if (updated == 0) {
                            throw new PersistenceException(Tickets.MSG.getMsg("error.ticketDoesNotExist", new Object[]{ticketID}));
                        }
                        break block29;
                    }
                }
                values.add(new SqlColumnValue("AufID", (pst, index) -> pst.setInt(index, ticketID)));
                try (PreparedStatement pst3 = this.constructInsertStatement(connection, values, "tblAuftraege");){
                    pst3.executeUpdate();
                }
            }
        }
    }

    private void updateBundle_tblBundle(List<SqlColumnValue> values, Integer bunId, int ticketID) throws SQLException {
        int value = bunId == null || bunId != ticketID ? 0 : 1;
        values.add(new SqlColumnValue("subAuftraege", (pst, index) -> pst.setInt(index, value)));
    }

    private void updateBundle_tblAuftraege(List<SqlColumnValue> values, Integer bundleId, int ticketID) throws SQLException {
        int columnBunID;
        int master;
        if (bundleId == null) {
            master = 1;
            columnBunID = ticketID;
        } else if (bundleId == ticketID) {
            master = 1;
            columnBunID = ticketID;
        } else {
            master = 0;
            columnBunID = bundleId;
        }
        values.add(new SqlColumnValue("Master", (pst, index) -> pst.setInt(index, master)));
        values.add(new SqlColumnValue("BunID", (pst, index) -> pst.setInt(index, columnBunID)));
    }

    private boolean updateTicketOwner(List<SqlColumnValue> values, @Nullable GUID ownerID) throws SQLException {
        if (ownerID == null) {
            values.add(new SqlColumnValue("UsrID", (pst, index) -> pst.setNull(index, 4)));
        } else {
            UserAccount ownerAccount = UserManager.getInstance().getUserAccount(ownerID);
            if (ownerAccount != null) {
                int userID = HDUsersAndGroups.getUserID(ownerAccount);
                HDLogger.debug("WRITE TICKET OWNER: " + ownerAccount.getDisplayName() + " -> " + userID + " " + ownerID);
                values.add(new SqlColumnValue("UsrID", (pst, index) -> pst.setInt(index, userID)));
            } else {
                return false;
            }
        }
        return true;
    }

    private void updateResourceID(List<SqlColumnValue> values, @Nullable GUID resourceID) throws SQLException {
        if (resourceID == null) {
            values.add(new SqlColumnValue("ResID", (pst, index) -> pst.setInt(index, 0)));
        } else {
            UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resourceID);
            if (resource == null) {
                throw new SQLException("Resource with ID \"" + resourceID + "\" does not exist.");
            }
            int resIntID = (Integer)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
            values.add(new SqlColumnValue("ResID", (pst, index) -> pst.setInt(index, resIntID)));
        }
    }

    private void updateCategoryID(List<SqlColumnValue> values, @Nullable Integer categoryID) throws SQLException {
        if (categoryID == null) {
            values.add(new SqlColumnValue("BetID", (pst, index) -> pst.setNull(index, 4)));
        } else {
            values.add(new SqlColumnValue("BetID", (pst, index) -> pst.setInt(index, categoryID)));
        }
    }

    private void updateDeadline(List<SqlColumnValue> values, @Nullable Long deadline) throws SQLException {
        values.add(new SqlColumnValue("DeadlineZeit", (pst, index) -> pst.setTimestamp(index, deadline == null ? null : new Timestamp(deadline))));
    }

    private void updateIdentifier(List<SqlColumnValue> values, @Nonnull String identifier) throws SQLException {
        values.add(new SqlColumnValue("spezFeld", (pst, index) -> pst.setString(index, identifier.isEmpty() ? null : identifier)));
    }

    private void updateSubject(List<SqlColumnValue> values, @Nonnull String subject) throws SQLException {
        values.add(new SqlColumnValue("DerBetreff", (pst, index) -> pst.setString(index, subject.isEmpty() ? null : subject)));
    }

    public void addReaStep(int reaId, MutableReaStepAttributes attributes, MutableReaStepData stepData, @Nullable ReaStepTextVO stepText, boolean initialReaStep) {
        try (Connection con = this.connectionFactory.getConnection();){
            this.addReaStep(con, reaId, attributes, stepData, stepText, initialReaStep);
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    private void addReaStep(Connection con, int reaId, MutableReaStepAttributes attributes, MutableReaStepData stepData, @Nullable ReaStepTextVO stepText, boolean initialStep) throws SQLException {
        int ticketId = this.checkRequiredFieldsForNewReaStep(attributes, stepData);
        try (Statement st = con.createStatement(1005, 1008);
             ResultSet rs = st.executeQuery("SELECT * FROM tblRealisierung WHERE 1=0");){
            Integer resID;
            rs.moveToInsertRow();
            rs.updateInt("ReaID", reaId);
            rs.updateInt("BunID", (int)attributes.get(ReaStepVO.ATTRIBUTE_BUN_ID));
            rs.updateInt("OrgBunID", (int)attributes.get(ReaStepVO.ATTRIBUTE_ORG_BUN_ID));
            rs.updateInt("AktID", (int)attributes.get(ReaStepVO.ATTRIBUTE_ACTION_ID));
            rs.updateBoolean("bundleVisible", (boolean)attributes.getOrDefault(ReaStepVO.ATTRIBUTE_BUNDLE_VISIBLE));
            ProcessingTime processingTime = stepData.get(ReaStepVO.FIELD_PROCESSING_TIME);
            rs.updateTimestamp("StartZeit", processingTime.getStartTimestamp());
            rs.updateTimestamp("EndZeit", processingTime.getEndTimestamp());
            String displayname = stepData.get(ReaStepVO.FIELD_USER_DISPLAY_NAME);
            GUID userAccountID = attributes.get(ReaStepVO.ATTRIBUTE_USER_ID);
            if (displayname != null) {
                rs.updateString("DisplayName", displayname);
            }
            if (userAccountID == null) {
                rs.updateNull("UserID");
            } else {
                UserAccount userAccount = UserManager.getInstance().getUserAccount(userAccountID);
                if (userAccount != null) {
                    int userID = HDUsersAndGroups.getUserID(userAccount);
                    rs.updateInt("UserID", userID);
                    if (!stepData.containsField(ReaStepVO.FIELD_USER_DISPLAY_NAME)) {
                        rs.updateString("DisplayName", userAccount.getDisplayName());
                    }
                } else {
                    HDLogger.error("[TicketWriteDAO] No User account exists for ID: " + userAccountID + ". Step will have no user.");
                }
            }
            this.updateLastChangedBy(attributes.get(ReaStepVO.ATTRIBUTE_ORG_BUN_ID), userAccountID, con);
            rs.updateDouble("Stundensatz", (double)attributes.getOrDefault(ReaStepVO.ATTRIBUTE_HOURLY_RATE));
            rs.updateDouble("Pauschale", (double)attributes.getOrDefault(ReaStepVO.ATTRIBUTE_LUMP_SUM));
            String text = stepText == null ? "" : stepText.getText();
            rs.updateString("was", text.isEmpty() ? null : text);
            boolean hasHtmlContent = stepText != null && stepText.hasHtmlContent();
            rs.updateInt("ishtml", hasHtmlContent ? 1 : 0);
            if (initialStep) {
                String auftragSql = "UPDATE tblAuftraege SET Auftrag = ?, ishtml = ? WHERE AufID = ?";
                try (PreparedStatement pstm = con.prepareStatement(auftragSql);){
                    pstm.setString(1, stepText == null ? null : stepText.getText());
                    pstm.setInt(2, stepText == null ? 0 : (stepText.hasHtmlContent() ? 1 : 0));
                    pstm.setInt(3, ticketId);
                    pstm.executeUpdate();
                }
            }
            if (stepData.containsField(ReaStepVO.FIELD_DESC)) {
                String desc = stepData.get(ReaStepVO.FIELD_DESC);
                rs.updateString("Description", desc.isEmpty() ? null : desc);
            }
            if (stepData.containsField(ReaStepVO.FIELD_EMAIL_IN)) {
                String emailIn = stepData.get(ReaStepVO.FIELD_EMAIL_IN);
                rs.updateString("EmailIn", emailIn.isEmpty() ? null : emailIn);
            }
            if (stepData.containsField(ReaStepVO.FIELD_EMAIL_AN)) {
                String emailAn = stepData.get(ReaStepVO.FIELD_EMAIL_AN);
                rs.updateString("EmailAn", emailAn.isEmpty() ? null : emailAn);
            }
            if (stepData.containsField(ReaStepVO.FIELD_EMAIL_CC)) {
                String emailCC = stepData.get(ReaStepVO.FIELD_EMAIL_CC);
                rs.updateString("EmailCC", emailCC.isEmpty() ? null : emailCC);
            }
            if (stepData.containsField(ReaStepVO.FIELD_EMAIL_BCC)) {
                String emailBCC = stepData.get(ReaStepVO.FIELD_EMAIL_BCC);
                rs.updateString("EmailBCC", emailBCC.isEmpty() ? null : emailBCC);
            }
            rs.updateInt("RessID", (resID = attributes.get(ReaStepVO.ATTRIBUTE_RES_ID)) == null ? 0 : resID);
            rs.insertRow();
            rs.last();
        }
        this.writeBinaryReaStepData(stepData, reaId, con);
    }

    private void writeBinaryReaStepData(MutableReaStepData stepData, int reaId, Connection connection) throws SQLException {
        Set<ReaStepField<Object>> includedAdditionalFields = stepData.getIncludedFields();
        includedAdditionalFields.retainAll(this.registeredFields.getReaStepAdditionalFields());
        if (includedAdditionalFields.isEmpty()) {
            return;
        }
        HashMap<String, String> jsonizedValues = new HashMap<String, String>();
        for (ReaStepField<Object> field : includedAdditionalFields) {
            Object value = stepData.get(field);
            String jsonData = new Json().toJson(value);
            jsonizedValues.put(field.getKey(), jsonData);
        }
        ReaStepPersistenceUnit details = new ReaStepPersistenceUnit(jsonizedValues);
        String jsonData = new Json().toJson((Object)details);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonData.getBytes(StandardCharsets.UTF_8));
        String sql = "INSERT INTO tblReaStepBinary (ReaID, DataKey, Data) VALUES (?, ?, ?)";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, reaId);
            pstm.setString(2, "reastepdetails");
            pstm.setBinaryStream(3, inputStream);
            pstm.executeUpdate();
        }
    }

    private void updateLastChangedBy(Integer ticketId, GUID userAccountID, Connection con) throws SQLException {
        try (PreparedStatement stm = con.prepareStatement("Update tblBuendel SET LastChangedByID = ? WHERE BunID = ?");){
            HDLogger.debug("updateLastChangedBy: " + userAccountID);
            if (userAccountID == null) {
                stm.setNull(1, 4);
            } else {
                stm.setInt(1, HDUsersAndGroups.getUserID(userAccountID));
            }
            stm.setInt(2, ticketId);
            stm.executeUpdate();
        }
    }

    private int checkRequiredFieldsForNewReaStep(MutableReaStepAttributes attributes, MutableReaStepData stepData) {
        if (!stepData.containsField(ReaStepVO.FIELD_PROCESSING_TIME)) {
            throw new IllegalArgumentException("Field PROCESSING_TIME must be set");
        }
        if (!attributes.containsAttribute(ReaStepVO.ATTRIBUTE_ACTION_ID)) {
            throw new IllegalArgumentException("Attribute ACTION_ID must be set");
        }
        if (!attributes.containsAttribute(ReaStepVO.ATTRIBUTE_BUN_ID)) {
            throw new IllegalArgumentException("Attribute BUN_ID must be set");
        }
        if (!attributes.containsAttribute(ReaStepVO.ATTRIBUTE_ORG_BUN_ID)) {
            throw new IllegalArgumentException("Attribute ORG_BUN_ID must be set");
        }
        return attributes.get(ReaStepVO.ATTRIBUTE_ORG_BUN_ID);
    }

    public void updateTicketSumTime(int ticketID) {
        int summe = 0;
        String sqlSelect = String.format("SELECT StartZeit, EndZeit FROM tblRealisierung WHERE BunID = %d", ticketID);
        try (Connection con = this.connectionFactory.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(sqlSelect);){
            while (rs.next()) {
                Timestamp start = rs.getTimestamp("StartZeit");
                Timestamp ende = rs.getTimestamp("EndZeit");
                if (start == null || ende == null) continue;
                summe = (int)((long)summe + (ende.getTime() - start.getTime()) / 60000L);
            }
            String sqlUpdate = "UPDATE tblBuendel Set SummeZeit = ? WHERE BunID = ?";
            try (PreparedStatement pstm = con.prepareStatement(sqlUpdate);){
                pstm.setInt(1, summe);
                pstm.setInt(2, ticketID);
                pstm.execute();
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    public int createTicket(int id, MutableTicketAttributes attributes, MutableTicketData ticketData, MutableReaStepText text) {
        try (Connection con = this.connectionFactory.getConnection();){
            this.writeTblBuendel(con, id, attributes, ticketData, true);
            this.writeTblAuftraege(con, id, ticketData, attributes, true);
            this.updateTblTicketBinary(con, id, ticketData);
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return id;
    }

    public void onUnbundleClearBundleVisibleForTicket(int ticket) {
        ArrayList<Integer> updatedReaStepIDs = new ArrayList<Integer>();
        try (Connection con = this.connectionFactory.getConnection();
             Statement stm = con.createStatement();){
            try (ResultSet rsUpdatedSteps = stm.executeQuery(String.format("SELECT ReaID FROM tblRealisierung WHERE BunID = %d", ticket));){
                while (rsUpdatedSteps.next()) {
                    updatedReaStepIDs.add(rsUpdatedSteps.getInt(1));
                }
            }
            stm.execute(String.format("UPDATE tblRealisierung SET bundleVisible = 0 WHERE BunID = %d", ticket));
        }
        catch (Exception ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        finally {
            this.cacheCleaner.clearListOfReaSteps(ticket);
            for (Integer reaId : updatedReaStepIDs) {
                this.cacheCleaner.clearReaStep(reaId);
            }
        }
    }

    public boolean deleteTicketsOfSingleBundleForeverAndClearInCache(int bundleID) {
        ArrayList<Integer> idsOfTicketsToDelete = new ArrayList<Integer>();
        ArrayList deletedReaStepIDs = new ArrayList();
        try {
            boolean hasDeletedTicketData = DatabaseTransactionUtils.executeAsTransaction(this.connectionFactory, con -> {
                try (PreparedStatement pstm = con.prepareStatement("SELECT AufID FROM tblAuftraege WHERE BunID = ? AND AufID <> ?");){
                    pstm.setInt(1, bundleID);
                    pstm.setInt(2, bundleID);
                    try (ResultSet rs = pstm.executeQuery();){
                        while (rs.next()) {
                            int aufID = rs.getInt(1);
                            idsOfTicketsToDelete.add(aufID);
                        }
                    }
                }
                idsOfTicketsToDelete.add(bundleID);
                boolean hasDeletedTicket = false;
                try (PreparedStatement pstmRemoveFromActiveWorkFlows = con.prepareStatement("DELETE FROM tblWFaktiv WHERE HauptAuftrag = ? OR TeilAuftrag = ?");
                     PreparedStatement pstmUpdateEnd1RefInActiveWorkFlows = con.prepareStatement("UPDATE tblWFaktiv SET Ende1 = null WHERE Ende1 = ?");
                     PreparedStatement pstmUpdateEnd2RefInActiveWorkFlows = con.prepareStatement("UPDATE tblWFaktiv SET Ende2 = null WHERE Ende2 = ?");
                     PreparedStatement pstmRemoveFromFreeLinks = con.prepareStatement("DELETE FROM tblFreeLinks WHERE FromAufID = ? OR ToAufID = ?");
                     PreparedStatement pstmRemoveFromItilLinks = con.prepareStatement("DELETE FROM tblItilLinks WHERE MasterAufID = ? OR SlaveAufID = ?");
                     PreparedStatement pstmSelectReaStepIDs = con.prepareStatement("SELECT ReaID FROM tblRealisierung WHERE BunID = ?");
                     PreparedStatement pstmRemoveReaSteps = con.prepareStatement("DELETE FROM tblRealisierung WHERE BunID = ?");
                     PreparedStatement pstmRemoveTicketBundle = con.prepareStatement("DELETE FROM tblBuendel WHERE BunID = ?");
                     PreparedStatement pstmRemoveTicket = con.prepareStatement("DELETE FROM tblAuftraege WHERE BunID = ?");){
                    Iterator iterator = idsOfTicketsToDelete.iterator();
                    while (iterator.hasNext()) {
                        int ticketID = (Integer)iterator.next();
                        pstmRemoveFromActiveWorkFlows.setInt(1, ticketID);
                        pstmRemoveFromActiveWorkFlows.setInt(2, ticketID);
                        pstmRemoveFromActiveWorkFlows.execute();
                        pstmUpdateEnd1RefInActiveWorkFlows.setInt(1, ticketID);
                        pstmUpdateEnd1RefInActiveWorkFlows.execute();
                        pstmUpdateEnd2RefInActiveWorkFlows.setInt(1, ticketID);
                        pstmUpdateEnd2RefInActiveWorkFlows.execute();
                        pstmRemoveFromFreeLinks.setInt(1, ticketID);
                        pstmRemoveFromFreeLinks.setInt(2, ticketID);
                        pstmRemoveFromFreeLinks.execute();
                        pstmRemoveFromItilLinks.setInt(1, ticketID);
                        pstmRemoveFromItilLinks.setInt(2, ticketID);
                        pstmRemoveFromItilLinks.execute();
                        pstmSelectReaStepIDs.setInt(1, ticketID);
                        try (ResultSet rs = pstmSelectReaStepIDs.executeQuery();){
                            while (rs.next()) {
                                deletedReaStepIDs.add(rs.getInt(1));
                            }
                        }
                        pstmRemoveReaSteps.setInt(1, ticketID);
                        pstmRemoveReaSteps.execute();
                        pstmRemoveTicket.setInt(1, ticketID);
                        if (pstmRemoveTicket.executeUpdate() > 0) {
                            hasDeletedTicket = true;
                        }
                        pstmRemoveTicketBundle.setInt(1, ticketID);
                        pstmRemoveTicketBundle.execute();
                    }
                }
                return hasDeletedTicket;
            });
            for (TicketDeletionMaintenanceListener listener : ServerPluginManager.getInstance().get(TicketDeletionMaintenanceListener.class)) {
                try {
                    listener.ticketsDeleted(idsOfTicketsToDelete);
                }
                catch (Throwable e) {
                    HDLogger.error("Error while sending event");
                    HDLogger.error(e);
                }
            }
            boolean bl = hasDeletedTicketData;
            return bl;
        }
        catch (Exception ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        finally {
            Iterator iterator = idsOfTicketsToDelete.iterator();
            while (iterator.hasNext()) {
                int ticketID = (Integer)iterator.next();
                this.cacheCleaner.clearTicket(ticketID);
                this.cacheCleaner.clearListOfReaSteps(ticketID);
                this.cacheCleaner.clearListOfTicketsInBundle(ticketID);
            }
            iterator = deletedReaStepIDs.iterator();
            while (iterator.hasNext()) {
                int stepID = (Integer)iterator.next();
                this.cacheCleaner.clearReaStep(stepID);
                this.cacheCleaner.clearReaStepText(stepID);
            }
        }
    }

    public void updateReaStepProcessingTime(int stepID, ProcessingTime processingTime) {
        String sql = "UPDATE tblRealisierung SET StartZeit = ?, EndZeit = ? WHERE ReaID = ?";
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setTimestamp(1, processingTime.getStartTimestamp());
            pstm.setTimestamp(2, processingTime.getEndTimestamp());
            pstm.setInt(3, stepID);
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    public void removeReferencesToUserFromTicketAndClearCache(int ticketID, int userID) {
        try (Connection con = this.connectionFactory.getConnection();
             Statement stm = con.createStatement();){
            String sqlResetLastEditorID = String.format("UPDATE tblBuendel SET LastEditorID = NULL WHERE BunID = %d AND LastEditorID = %d", ticketID, userID);
            stm.executeUpdate(sqlResetLastEditorID);
            String sqlResetLastChangedBy = String.format("UPDATE tblBuendel SET LastChangedByID = NULL WHERE BunID = %d AND LastChangedByID = %d", ticketID, userID);
            stm.executeUpdate(sqlResetLastChangedBy);
            String sqlResetUsrID = String.format("UPDATE tblAuftraege SET UsrID = NULL WHERE AufID = %d AND UsrID = %d", ticketID, userID);
            stm.executeUpdate(sqlResetUsrID);
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        finally {
            this.cacheCleaner.clearTicket(ticketID);
        }
    }

    public void removeReferencesToUserFromAllReaStepsAndClearCache(int userID) {
        ArrayList<Integer> reaStepIDs = new ArrayList<Integer>();
        try (Connection con = this.connectionFactory.getConnection();
             Statement stm = con.createStatement();){
            String sqlSelectStepIDs = String.format("SELECT ReaID FROM tblRealisierung WHERE UserID = %d", userID);
            try (ResultSet rs = stm.executeQuery(sqlSelectStepIDs);){
                while (rs.next()) {
                    reaStepIDs.add(rs.getInt(1));
                }
            }
            stm.executeUpdate(String.format("UPDATE tblRealisierung SET UserID = NULL WHERE UserID = %d", userID));
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        finally {
            Iterator iterator = reaStepIDs.iterator();
            while (iterator.hasNext()) {
                int stepID = (Integer)iterator.next();
                this.cacheCleaner.clearReaStep(stepID);
            }
        }
    }

    private boolean computeAttachmentFlagForTicket(Connection con, int ticketID) throws SQLException {
        String sql = String.format("SELECT DISTINCT type FROM tblAttachments WHERE type = 1 AND isEmbedded = 0 AND ownerId IN (SELECT AufID FROM tblAuftraege WHERE AufID = %d OR BunID = %d)", ticketID, ticketID);
        try (Statement stm = con.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stm.executeQuery(sql);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAttachmentFlagForTicketAndClearCache(int ticketID) {
        try (Connection con = this.connectionFactory.getConnection();){
            boolean attFlag = this.computeAttachmentFlagForTicket(con, ticketID);
            String sql = String.format("UPDATE tblBuendel SET Anlagen = %d, Indiziert = 0 WHERE BunID = %d", TicketAttributeHasAttachments.valueAsInt(attFlag), ticketID);
            try (Statement pstm = con.createStatement();){
                pstm.executeUpdate(sql);
            }
            catch (SQLException ex) {
                HDLogger.error(String.format("Could not update attachment flag of ticket with ID \"%d\".", ticketID));
                HDLogger.error(ex);
            }
            finally {
                this.cacheCleaner.clearTicket(ticketID);
            }
        }
        catch (SQLException e) {
            throw PersistenceException.createWithCode((Throwable)e, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    public void updateReaStepBunId(int reaStepId, int bunId, int ticketID) {
        try (Connection con = this.connectionFactory.getConnection();){
            String sql = String.format("UPDATE tblRealisierung SET BunID = %d WHERE ReaID = %d", bunId, reaStepId);
            if (bunId == ticketID) {
                sql = String.format("UPDATE tblRealisierung SET BunID = %d, bundleVisible = 0 WHERE ReaID = %d", bunId, reaStepId);
            }
            try (Statement pstm = con.createStatement();){
                pstm.executeUpdate(sql);
            }
            catch (SQLException ex) {
                HDLogger.error(ex);
            }
        }
        catch (SQLException e) {
            throw PersistenceException.createWithCode((Throwable)e, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    public void updateCloseDate(int ticketID, Long closeDate) {
        String sql = "UPDATE tblBuendel SET CloseDate=? WHERE BunID=?";
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            if (closeDate == null) {
                pstm.setTimestamp(1, null);
            } else {
                pstm.setTimestamp(1, new Timestamp(closeDate));
            }
            pstm.setInt(2, ticketID);
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    public TicketReadDAOCacheCleaner getCacheCleaner() {
        return this.cacheCleaner;
    }

    private static interface ValueFunction {
        public void run(PreparedStatement var1, int var2) throws SQLException;
    }

    private class SqlColumnValue {
        private String columnName;
        private ValueFunction valueFunction;

        public SqlColumnValue(String columnName, ValueFunction valueFunction) {
            this.columnName = columnName;
            this.valueFunction = valueFunction;
        }
    }
}

