/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.dao;

import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.ReaStepEmailAddresses;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOCacheCleaner;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOImpl;
import com.inet.helpdesk.ticketmanager.internal.util.PerformanceCheck;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TicketReadDAOWithCache
implements TicketReadDAO,
TicketReadDAOCacheCleaner {
    private final TicketReadDAO readDAO;
    private final MemoryStoreMap<Integer, TicketVOSingle> ticketCache;
    private final MemoryStoreMap<Integer, List<Integer>> reaStepIdCache;
    private final MemoryStoreMap<Integer, ReaStepVO> reaStepCache;
    private final MemoryStoreMap<Integer, ReaStepTextVO> reaStepTextCache;
    private final MemoryStoreMap<Integer, List<Integer>> ticketsInBundleCache;
    private static final String KEY_TICKET = "TM_ticket";
    private static final String KEY_REA_LIST = "TM_rea_list";
    private static final String KEY_REASTEP = "TM_reastep";
    private static final String KEY_REA_TEXT = "TM_rea_text";
    private static final String KEY_BUNDLE_LIST = "TM_bundle_list";

    public TicketReadDAOWithCache(TicketReadDAO readDAO) {
        if (readDAO == null) {
            throw new IllegalArgumentException("readDAO must not be null");
        }
        if (readDAO instanceof TicketReadDAOWithCache) {
            throw new IllegalArgumentException("duplicate readDAO cache");
        }
        this.readDAO = readDAO;
        int timeout = 900;
        this.ticketCache = new MemoryStoreMap();
        this.ticketCache.setTimeout(4 * timeout, true);
        this.reaStepIdCache = new MemoryStoreMap();
        this.reaStepIdCache.setTimeout(timeout, true);
        this.reaStepCache = new MemoryStoreMap();
        this.reaStepCache.setTimeout(timeout, true);
        this.reaStepTextCache = new MemoryStoreMap();
        this.reaStepTextCache.setTimeout(timeout, true);
        this.ticketsInBundleCache = new MemoryStoreMap();
        this.ticketsInBundleCache.setTimeout(timeout, true);
    }

    public TicketReadDAO getInstanceWithoutCache() {
        return this.readDAO;
    }

    @Override
    public List<ReaStepEmailAddresses> getAllReaStepEmailAddresses(int ticketID) {
        return this.readDAO.getAllReaStepEmailAddresses(ticketID);
    }

    @Override
    public List<TicketEmailSenderInformation> getSenderInformationForTicket(int ticketID) throws ServerDataException {
        return this.readDAO.getSenderInformationForTicket(ticketID);
    }

    @Override
    public List<TicketVOSingle> getTicketsInBundle(int bundleID, boolean includeMasterTicket) {
        List<TicketVOSingle> tickets = this.getCachedTicketsInBundle(bundleID);
        if (tickets == null) {
            List ticketIDs;
            try (ServerLock lock = ThreadUtils.getLock((Object)(KEY_BUNDLE_LIST + bundleID));){
                tickets = this.readDAO.getTicketsInBundle(bundleID, true);
                ticketIDs = Collections.unmodifiableList(tickets.stream().map(TicketVO::getID).collect(Collectors.toList()));
                this.ticketsInBundleCache.put((Object)bundleID, ticketIDs);
            }
            tickets.clear();
            Iterator iterator = ticketIDs.iterator();
            while (iterator.hasNext()) {
                int ticketID = (Integer)iterator.next();
                tickets.add(this.getTicket(ticketID));
            }
        }
        if (!includeMasterTicket && !tickets.isEmpty()) {
            return tickets.subList(1, tickets.size());
        }
        return tickets;
    }

    @Override
    public List<Integer> getTicketIDsForBundleID(int bundleID) {
        return this.readDAO.getTicketIDsForBundleID(bundleID);
    }

    @Override
    public TicketVOSingle getTicket(int ticketID) {
        PerformanceCheck.GETTICKETS.set(new PerformanceCheck());
        try {
            TicketVOSingle ticketVOSingle = this.getFromCacheOrLoad(ticketID, KEY_TICKET, this.ticketCache, id -> this.readDAO.getTicket((int)id));
            return ticketVOSingle;
        }
        finally {
            PerformanceCheck.GETTICKETS.get().printIfTookLongerThan(1000L, "GetTicket: #" + ticketID);
        }
    }

    @Override
    public List<ReaStepVO> getReaStepsForTicket(int ticketId) {
        List<ReaStepVO> steps = this.getCachedReaStepsForTicket(ticketId);
        if (steps == null) {
            List<Integer> stepIDs = this.getReaStepIDsForTicket(ticketId);
            steps = new ArrayList<ReaStepVO>(stepIDs.size());
            for (Integer stepID : stepIDs) {
                ReaStepVO reaStep = this.getReaStep(stepID);
                if (reaStep == null) {
                    HDLogger.error(new Exception("ReaStep " + stepID + " does not exist for ticket " + ticketId));
                    continue;
                }
                steps.add(reaStep);
            }
        }
        return steps;
    }

    @Override
    public List<Integer> getReaStepIDsForTicket(int ticketId) {
        List<Integer> stepIDs = (List<Integer>)this.reaStepIdCache.get((Object)ticketId);
        if (stepIDs == null) {
            try (ServerLock lock = ThreadUtils.getLock((Object)(KEY_REA_LIST + ticketId));){
                stepIDs = (List)this.reaStepIdCache.get((Object)ticketId);
                if (stepIDs != null) {
                    List<Integer> list = stepIDs;
                    return list;
                }
                stepIDs = this.readDAO.getReaStepIDsForTicket(ticketId);
                this.reaStepIdCache.put((Object)ticketId, stepIDs);
            }
        }
        return stepIDs;
    }

    @Override
    public int getReaStepCountForTicket(int ticketId) {
        List<ReaStepVO> steps = this.getCachedReaStepsForTicket(ticketId);
        if (steps == null) {
            return this.readDAO.getReaStepCountForTicket(ticketId);
        }
        return steps.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<Integer, ReaStepTextVO> getReaStepTextsForTicket(int ticketId) {
        Map<Integer, ReaStepTextVO> texts = this.getCachedReaStepTextsForTicket(ticketId);
        if (texts != null) return texts;
        String string = "AuchHierdarfNurEinThreadReinSonstDeadLockM\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6glich";
        synchronized ("AuchHierdarfNurEinThreadReinSonstDeadLockM\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6glich") {
            List<ServerLock> allServerLocks = this.getAllServerLocks(KEY_REA_TEXT, this.getReaStepIDsForTicket(ticketId));
            try {
                texts = this.readDAO.getReaStepTextsForTicket(ticketId);
                texts.entrySet().forEach(e -> this.reaStepTextCache.put((Object)((Integer)e.getKey()), (Object)((ReaStepTextVO)e.getValue())));
            }
            finally {
                allServerLocks.forEach(ServerLock::close);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return texts;
        }
    }

    @Override
    public List<ReaStepTextVO> getReaStepTexts(List<Integer> reaStepIDs) {
        ArrayList<ReaStepTextVO> result = new ArrayList<ReaStepTextVO>();
        for (Integer i : reaStepIDs) {
            ReaStepTextVO reaStepTextVO = (ReaStepTextVO)this.reaStepTextCache.get((Object)i);
            if (reaStepTextVO == null) {
                return this.readDAO.getReaStepTexts(reaStepIDs);
            }
            result.add(reaStepTextVO);
        }
        return result;
    }

    @Override
    public ReaStepTextVO getReaStepText(int reaStepId) {
        return this.getFromCacheOrLoad(reaStepId, KEY_REA_TEXT, this.reaStepTextCache, id -> this.readDAO.getReaStepText((int)id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public List<TicketVOSingle> getTickets(Collection<Integer> ticketIds) {
        if (ticketIds == null) {
            throw new IllegalArgumentException("list of ticket IDs must not be null");
        }
        if (ticketIds.contains(null)) {
            throw new IllegalArgumentException("list of ticket IDs must not contain null");
        }
        PerformanceCheck.GETTICKETS.set(new PerformanceCheck());
        HashMap<Integer, TicketVOSingle> map = new HashMap<Integer, TicketVOSingle>();
        ArrayList<Integer> toLoad = new ArrayList<Integer>();
        for (Integer id : ticketIds) {
            TicketVOSingle ticket = (TicketVOSingle)this.ticketCache.get((Object)id);
            if (ticket != null) {
                map.put(id, ticket);
                continue;
            }
            toLoad.add(id);
        }
        PerformanceCheck.GETTICKETS.get().finishPhase("TicketCacheCheck");
        if (!toLoad.isEmpty()) {
            String string = "nurEinerDarfHierReinSonstDeadLockM\u00f6glich";
            // MONITORENTER : "nurEinerDarfHierReinSonstDeadLockM\u00f6glich"
            List<ServerLock> allLocks = this.getAllServerLocks(KEY_TICKET, toLoad);
            try {
                List<TicketVOSingle> loadedTickets = this.readDAO.getTickets(toLoad);
                for (TicketVOSingle ticket : loadedTickets) {
                    map.put(ticket.getID(), ticket);
                    this.ticketCache.put((Object)ticket.getID(), (Object)ticket);
                }
            }
            finally {
                allLocks.forEach(ServerLock::close);
            }
            // MONITOREXIT : string
        }
        PerformanceCheck.GETTICKETS.get().finishPhase("LoadAndPut");
        ArrayList<TicketVOSingle> result = new ArrayList<TicketVOSingle>();
        Iterator<Integer> iterator = ticketIds.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                PerformanceCheck.GETTICKETS.get().printIfTookLongerThan(1000 * ticketIds.size(), "GetTickets:" + ticketIds.size());
                return result;
            }
            Integer id = iterator.next();
            TicketVOSingle ticket = (TicketVOSingle)map.get(id);
            if (ticket == null) continue;
            result.add(ticket);
        }
    }

    private List<ServerLock> getAllServerLocks(String key, List<Integer> toLoad) {
        return toLoad.stream().map(id -> ThreadUtils.getLock((Object)(key + id))).collect(Collectors.toList());
    }

    @Override
    public Iterator<Integer> getTicketIdIterator() {
        return this.readDAO.getTicketIdIterator();
    }

    @Override
    public Iterator<SlaveInfo> getSlaveInfoIterator() {
        return this.readDAO.getSlaveInfoIterator();
    }

    @Override
    public ReaStepVO getReaStep(int reaId) {
        return this.getFromCacheOrLoad(reaId, KEY_REASTEP, this.reaStepCache, id -> this.readDAO.getReaStep((int)id));
    }

    @Override
    public List<Integer> findTicketBundlesInRangeOfTicketIDs(int fromID, int toID) {
        return this.readDAO.findTicketBundlesInRangeOfTicketIDs(fromID, toID);
    }

    @Override
    public List<Integer> findTicketBundlesByDate(long lastModified) {
        return this.readDAO.findTicketBundlesByDate(lastModified);
    }

    @Override
    public List<Integer> findTicketBundlesMarkedAsDeleted() {
        return this.readDAO.findTicketBundlesMarkedAsDeleted();
    }

    @Override
    public List<Integer> getITILSlaves(int masterTicketID) {
        return this.readDAO.getITILSlaves(masterTicketID);
    }

    @Override
    public TicketReadDAOImpl.TicketsInResource listTicketsInResource(int resourceID) {
        return this.readDAO.listTicketsInResource(resourceID);
    }

    @Override
    public List<Integer> listTicketsWithReferencesToUser(int userID) {
        return this.readDAO.listTicketsWithReferencesToUser(userID);
    }

    @Override
    public List<Integer> listAutoFinishableTickets(long currentTimeMillis, int requiredIdleDays) {
        return this.readDAO.listAutoFinishableTickets(currentTimeMillis, requiredIdleDays);
    }

    private List<TicketVOSingle> getCachedTicketsInBundle(int bundleID) {
        List ticketIDs = (List)this.ticketsInBundleCache.get((Object)bundleID);
        if (ticketIDs == null) {
            return null;
        }
        ArrayList<TicketVOSingle> cachedTickets = new ArrayList<TicketVOSingle>();
        for (Integer id : ticketIDs) {
            TicketVOSingle ticket = (TicketVOSingle)this.ticketCache.get((Object)id);
            if (ticket == null) {
                return null;
            }
            cachedTickets.add(ticket);
        }
        return cachedTickets;
    }

    private List<ReaStepVO> getCachedReaStepsForTicket(int ticketID) {
        List stepIDs = (List)this.reaStepIdCache.get((Object)ticketID);
        if (stepIDs == null) {
            return null;
        }
        ArrayList<ReaStepVO> cachedSteps = new ArrayList<ReaStepVO>();
        for (Integer id : stepIDs) {
            ReaStepVO step = (ReaStepVO)this.reaStepCache.get((Object)id);
            if (step == null) {
                return null;
            }
            cachedSteps.add(step);
        }
        return cachedSteps;
    }

    private Map<Integer, ReaStepTextVO> getCachedReaStepTextsForTicket(int ticketID) {
        List stepIDs = (List)this.reaStepIdCache.get((Object)ticketID);
        if (stepIDs == null) {
            return null;
        }
        HashMap<Integer, ReaStepTextVO> cachedTexts = new HashMap<Integer, ReaStepTextVO>();
        for (Integer id : stepIDs) {
            ReaStepTextVO text = (ReaStepTextVO)this.reaStepTextCache.get((Object)id);
            if (text == null) {
                return null;
            }
            cachedTexts.put(id, text);
        }
        return cachedTexts;
    }

    private <T> T getFromCacheOrLoad(int entryID, String cacheMonitorKey, MemoryStoreMap<Integer, T> cache, Function<Integer, T> loader) {
        Object entry = cache.get((Object)entryID);
        if (entry != null) {
            return (T)entry;
        }
        try (ServerLock lock = ThreadUtils.getLock((Object)(cacheMonitorKey + entryID));){
            entry = cache.get((Object)entryID);
            if (entry != null) {
                Object object = entry;
                return (T)object;
            }
            entry = loader.apply(entryID);
            if (entry != null) {
                cache.put((Object)entryID, entry);
            }
        }
        return (T)entry;
    }

    @Override
    public void clearTicket(int ticketID) {
        try (ServerLock lock = ThreadUtils.getLock((Object)(KEY_TICKET + ticketID));){
            this.ticketCache.remove((Object)ticketID);
        }
    }

    @Override
    public void clearListOfReaSteps(int ticketID) {
        try (ServerLock lock = ThreadUtils.getLock((Object)(KEY_REA_LIST + ticketID));){
            this.reaStepIdCache.remove((Object)ticketID);
        }
    }

    @Override
    public void clearReaStep(int reaStepID) {
        try (ServerLock lock = ThreadUtils.getLock((Object)(KEY_REASTEP + reaStepID));){
            this.reaStepCache.remove((Object)reaStepID);
        }
    }

    @Override
    public void clearReaStepText(int reaStepID) {
        try (ServerLock lock = ThreadUtils.getLock((Object)(KEY_REA_TEXT + reaStepID));){
            this.reaStepTextCache.remove((Object)reaStepID);
        }
    }

    @Override
    public void clearListOfTicketsInBundle(int bundleID) {
        try (ServerLock lock = ThreadUtils.getLock((Object)(KEY_BUNDLE_LIST + bundleID));){
            this.ticketsInBundleCache.remove((Object)bundleID);
        }
    }
}

