/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.dao;

import com.inet.config.ConfigurationManager;
import com.inet.error.ErrorCode;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.ticketmanager.ReaStepEmailAddresses;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPersistenceUnit;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.GeneratedTicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.StorageLocationInfo;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.ticketmanager.dao.ReaStepPersistenceUnit;
import com.inet.helpdesk.ticketmanager.dao.ResultSetIterator;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.internal.DefaultValueManagerImpl;
import com.inet.helpdesk.ticketmanager.internal.TicketEmailSenderInformationCreator;
import com.inet.helpdesk.ticketmanager.internal.util.PerformanceCheck;
import com.inet.helpdesk.ticketmanager.model.RegisteredTicketFieldsContainer;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class TicketReadDAOImpl
implements TicketReadDAO {
    private final ConnectionFactory connectionFactory;
    private RegisteredTicketFieldsContainer registeredFields;
    private List<TicketAttribute> ticketAttributes;
    private List<ReaStepAttribute> reaStepAttributes;

    public TicketReadDAOImpl(ConnectionFactory connectionFactory) {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connection factory must not be null");
        }
        this.connectionFactory = connectionFactory;
    }

    public void init(@Nonnull List<TicketField> ticketFields, @Nonnull List<TicketAttribute> ticketAttributes, @Nonnull List<ReaStepField> reaStepFields, @Nonnull List<ReaStepAttribute> reaStepAttributes) {
        this.registeredFields = new RegisteredTicketFieldsContainer(ticketFields, reaStepFields);
        this.ticketAttributes = Collections.unmodifiableList(ticketAttributes);
        this.reaStepAttributes = Collections.unmodifiableList(reaStepAttributes);
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL is fixed")
    public List<ReaStepEmailAddresses> getAllReaStepEmailAddresses(int ticketID) {
        ArrayList<ReaStepEmailAddresses> arrayList;
        block22: {
            Connection con = this.connectionFactory.getConnection();
            try {
                String sqlSelectPart = "SELECT EmailIn, EmailAn, EmailCC FROM tblRealisierung, tblBuendel, tblAuftraege";
                String sqlWherePart = " WHERE tblAuftraege.AufID = ? AND tblAuftraege.BunID = tblBuendel.BunID AND tblBuendel.BunID = tblRealisierung.BunID";
                String SQL_GET_REASTEPSRECEIVERS_FOR_AUFID = sqlSelectPart + sqlWherePart;
                ArrayList<ReaStepEmailAddresses> receivers = new ArrayList<ReaStepEmailAddresses>();
                try (PreparedStatement pst = con.prepareStatement(SQL_GET_REASTEPSRECEIVERS_FOR_AUFID);){
                    pst.setInt(1, ticketID);
                    try (ResultSet rs = this.executeQueryWithToleranceOfTransientExceptions(pst);){
                        while (rs.next()) {
                            receivers.add(this.createReaStepEmailAddressesFromResultSet(rs));
                        }
                    }
                }
                arrayList = receivers;
                if (con == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
                }
            }
            con.close();
        }
        return arrayList;
    }

    private UserAccount getCurrentUserAccountOrThrow() throws ServerDataException {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account == null) {
            throw new ServerDataException(new IllegalStateException("No user is logged in."));
        }
        return account;
    }

    @Override
    public List<TicketEmailSenderInformation> getSenderInformationForTicket(int ticketID) throws ServerDataException {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketID);
        if (ticket == null) {
            return new ArrayList<TicketEmailSenderInformation>();
        }
        UserAccount userAccount = this.getCurrentUserAccountOrThrow();
        GUID resourceID = ticket.getResourceID();
        Integer categoryID = ticket.getCategoryID();
        String requestMailAccount = ticket.getEmailEingang();
        return TicketEmailSenderInformationCreator.getSenderInformation(userAccount, resourceID, categoryID, requestMailAccount);
    }

    private ReaStepEmailAddresses createReaStepEmailAddressesFromResultSet(ResultSet rs) throws SQLException {
        String emailIn = rs.getString("EmailIn");
        String emailAn = rs.getString("EmailAn");
        String emailCC = rs.getString("EmailCC");
        return new ReaStepEmailAddresses(emailIn, emailAn, emailCC);
    }

    @Override
    public List<TicketVOSingle> getTicketsInBundle(int bundleID, boolean includeMasterTicket) {
        try {
            ArrayList<TicketVOSingle> bundleTickets = new ArrayList<TicketVOSingle>();
            for (int ticketID : this.getIdsOfTicketsInBundle(bundleID, includeMasterTicket)) {
                TicketVOSingle ticket = this.getTicket(ticketID);
                if (ticket == null) continue;
                bundleTickets.add(ticket);
            }
            return bundleTickets;
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    private List<Integer> getIdsOfTicketsInBundle(int bundleID, boolean includeMasterTicketID) throws SQLException {
        ArrayList<Integer> ticketIDs = new ArrayList<Integer>();
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement("SELECT AufID FROM tblAuftraege WHERE BunID = ? AND AufID <> ?");){
            pstm.setInt(1, bundleID);
            pstm.setInt(2, bundleID);
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    int aufID = rs.getInt(1);
                    ticketIDs.add(aufID);
                }
            }
        }
        if (includeMasterTicketID && !ticketIDs.isEmpty()) {
            ticketIDs.add(0, bundleID);
        }
        return ticketIDs;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Integer> getTicketIDsForBundleID(int bundleID) {
        try (Connection con = this.connectionFactory.getConnection();){
            ArrayList<Integer> arrayList;
            block23: {
                PreparedStatement pstm = con.prepareStatement("SELECT AufID FROM tblAuftraege WHERE BunID = ?");
                try {
                    pstm.setInt(1, bundleID);
                    ArrayList<Integer> ticketIDs = new ArrayList<Integer>();
                    try (ResultSet rs = pstm.executeQuery();){
                        while (rs.next()) {
                            int aufID = rs.getInt(1);
                            if (bundleID == aufID) {
                                ticketIDs.add(0, aufID);
                                continue;
                            }
                            ticketIDs.add(aufID);
                        }
                    }
                    arrayList = ticketIDs;
                    if (pstm == null) break block23;
                }
                catch (Throwable throwable) {
                    if (pstm != null) {
                        try {
                            pstm.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstm.close();
            }
            return arrayList;
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    private List<TicketVOSingle> loadTickets(String whereAufIDCondition, int id) {
        PerformanceCheck.GETTICKETS.get().beginPhase();
        String join_tblAuf_with_tblBun = "tblAuftraege auf INNER JOIN tblBuendel bun ON auf.AufID = bun.BunID";
        String join_with_tblUser = join_tblAuf_with_tblBun + " LEFT JOIN tblUser userOwner ON userOwner.UsrID = auf.UsrID  LEFT JOIN tblUser userLastEditor ON userLastEditor.UsrID = bun.LastEditorID  LEFT JOIN tblUser userLastChanged ON userLastChanged.UsrID = bun.LastChangedByID  LEFT JOIN tblRessourcen res ON res.ResID = auf.ResID ";
        String join_all_tables = String.format("(%s) LEFT JOIN tblTicketBinary ON auf.AufID = tblTicketBinary.TicketID AND DataKey = '%s'", join_with_tblUser, "ticketdetails");
        String columnsAuf = "auf.AufID, auf.DeadlineZeit, auf.ResID, auf.ItiID, auf.KlaID, auf.PriID, auf.DerBetreff, auf.spezFeld, auf.BetID, auf.AnfReaID, auf.AutorisierenReaID, auf.BunID, auf.EmailEingang, auf.WFID, auf.WFStartDate, auf.AutoEscalated";
        String columnsBun = "bun.Anlagen, bun.Status, bun.SollZeit, bun.AnfrageDatum, bun.SummeZeit, bun.BearbeitungsDatum, bun.WiedervorlageDatum, bun.TerminVereinbarung, bun.CloseDate, bun.subAuftraege, bun.BunFeld1, bun.BunFeld2, bun.BunFeld3, bun.BunFeld4, bun.BunFeld5, bun.BunFeld6, bun.BunFeld7, bun.Anmerkung";
        String columnsDynamicFields = this.getAdditionalFieldColumnsForSelect();
        String kbArticle = ServerPluginManager.getInstance().isPluginLoaded("knowledgebase") ? "" : "bun.Status <> -200 AND ";
        String sql = String.format("SELECT %s, %s, %s tblTicketBinary.Data, userOwner.UserUUID ownerUUID, userLastEditor.UserUUID lastEditorUUID, userLastChanged.UserUUID lastChangedByUUID, res.GroupUUID resUUID FROM (%s) WHERE %s auf.AufID %s", columnsAuf, columnsBun, columnsDynamicFields, join_all_tables, kbArticle, whereAufIDCondition);
        ArrayList<TicketVOSingle> result = new ArrayList<TicketVOSingle>();
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);
             ResultSet rs = DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
            if (whereAufIDCondition.contains("?")) {
                pstm.setInt(1, id);
            }
            return pstm.executeQuery();
        });){
            PerformanceCheck.GETTICKETS.get().finishPhase("ExecuteQuery");
            while (rs.next()) {
                int ticketID = rs.getInt("AufID");
                try {
                    TicketPersistenceUnit details;
                    StorageLocationInfo<Object> storageLocationInfo;
                    String lastChangedBy;
                    String lastEditor;
                    Timestamp lastModifiedDate;
                    int sumTimes;
                    String resUUID;
                    MutableTicketAttributes attributes = new MutableTicketAttributes();
                    MutableTicketData data = new MutableTicketData();
                    Timestamp timestamp = rs.getTimestamp("DeadlineZeit");
                    if (timestamp != null) {
                        data.put(Tickets.FIELD_DEADLINE, timestamp.getTime());
                    }
                    if (!StringFunctions.isEmpty((String)(resUUID = rs.getString("resUUID")))) {
                        data.put(Tickets.FIELD_RESOURCE_GUID, GUID.valueOf((String)resUUID));
                    }
                    attributes.put(Tickets.ATTRIBUTE_STATUS_ID, rs.getInt("Status"));
                    int targetTime = rs.getInt("SollZeit");
                    if (targetTime > 0) {
                        data.put(Tickets.FIELD_TARGET_TIME, targetTime);
                    }
                    Integer itilID = rs.getInt("ItiID");
                    if (rs.wasNull()) {
                        HDLogger.warn(String.format("[TicketReadDAO] Default itilID will be used for ticket with ID=\"%d\" because its original value is missing.", ticketID));
                        itilID = (Integer)Tickets.FIELD_ITIL_ID.getDefaultValue();
                    }
                    data.put(Tickets.FIELD_ITIL_ID, itilID);
                    Integer classificationID = rs.getInt("KlaID");
                    if (rs.wasNull()) {
                        HDLogger.warn(String.format("[TicketReadDAO] Default classificationID will be used for ticket with ID=\"%d\" because its original value is missing.", ticketID));
                        classificationID = (Integer)Tickets.FIELD_CLASSIFICATION_ID.getDefaultValue();
                    }
                    data.put(Tickets.FIELD_CLASSIFICATION_ID, classificationID);
                    Integer priorityID = rs.getInt("PriID");
                    if (rs.wasNull()) {
                        HDLogger.warn(String.format("[TicketReadDAO] Default priorityID will be used for ticket with ID=\"%d\" because its original value is missing.", ticketID));
                        priorityID = DefaultValueManagerImpl.getInstance().getPriorityDefault();
                    }
                    data.put(Tickets.FIELD_PRIORITY_ID, priorityID);
                    data.putValidOrDefaultValue(Tickets.FIELD_SUBJECT, rs.getString("DerBetreff"));
                    data.putValidOrDefaultValue(Tickets.FIELD_IDENTIFIER, rs.getString("spezFeld"));
                    data.putValidOrDefaultValue(Tickets.FIELD_CATEGORY_ID, rs.getInt("BetID"));
                    Timestamp date = rs.getTimestamp("WiedervorlageDatum");
                    data.putValidOrDefaultValue(Tickets.FIELD_WIEDERVORLAGEDATE, date == null ? null : Long.valueOf(((Date)date).getTime()));
                    Timestamp termin = rs.getTimestamp("TerminVereinbarung");
                    data.putValidOrDefaultValue(Tickets.FIELD_TERMINVEREINBARUNG, termin == null ? null : Long.valueOf(((Date)termin).getTime()));
                    Timestamp wfStartDate = rs.getTimestamp("WFStartDate");
                    attributes.putValidOrDefaultValue(Tickets.ATTRIBUTE_WORKFLOW_START_DATE, wfStartDate == null ? null : Long.valueOf(((Date)wfStartDate).getTime()));
                    Timestamp closeDate = rs.getTimestamp("CloseDate");
                    attributes.putValidOrDefaultValue(Tickets.ATTRIBUTE_CLOSE_DATE, closeDate == null ? null : Long.valueOf(((Date)closeDate).getTime()));
                    attributes.put(Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID, rs.getInt("AnfReaID"));
                    Integer reaID = rs.getInt("AutorisierenReaID");
                    if (rs.wasNull()) {
                        reaID = null;
                    }
                    attributes.put(Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID, reaID);
                    attributes.put(Tickets.ATTRIBUTE_ATTACHMENTS, rs.getBoolean("Anlagen"));
                    Timestamp inquiryDate = rs.getTimestamp("AnfrageDatum");
                    if (inquiryDate == null) {
                        HDLogger.warn(String.format("[TicketReadDAO] Current time will be used as inquiry date of ticket with ID=\"%d\" because its original value is missing.", ticketID));
                        inquiryDate = new Timestamp(System.currentTimeMillis());
                    }
                    attributes.put(Tickets.ATTRIBUTE_INQUIRY_DATE, inquiryDate.getTime());
                    attributes.put(Tickets.ATTRIBUTE_EMAIL_EINGANG, rs.getString("EmailEingang"));
                    int workFlowID = rs.getInt("WFID");
                    if (workFlowID > 0) {
                        attributes.put(Tickets.ATTRIBUTE_WORKFLOW_ID, workFlowID);
                    }
                    if ((sumTimes = rs.getInt("SummeZeit")) > 0) {
                        attributes.put(Tickets.ATTRIBUTE_SUM_TIME, sumTimes);
                    }
                    if ((lastModifiedDate = rs.getTimestamp("BearbeitungsDatum")) == null) {
                        HDLogger.warn("[TicketReadDAO] Column value BearbeitungsDatum is missing! Current time will be used instead.");
                        lastModifiedDate = new Timestamp(System.currentTimeMillis());
                    }
                    long lastModified = lastModifiedDate.getTime();
                    attributes.put(Tickets.ATTRIBUTE_LAST_CHANGED, lastModified);
                    int bunID = rs.getInt("BunID");
                    boolean isSubInBundle = ticketID != bunID;
                    boolean hasSubTickets = rs.getInt("subAuftraege") > 0;
                    boolean isMasterInBundle = !isSubInBundle && hasSubTickets;
                    Integer bundleID = isSubInBundle || isMasterInBundle ? Integer.valueOf(bunID) : null;
                    attributes.put(Tickets.ATTRIBUTE_BUNDLE_ID, bundleID);
                    data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_1, rs.getString("BunFeld1"));
                    data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_2, rs.getString("BunFeld2"));
                    data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_3, rs.getString("BunFeld3"));
                    data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_4, rs.getString("BunFeld4"));
                    data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_5, rs.getString("BunFeld5"));
                    data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_6, rs.getString("BunFeld6"));
                    data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_7, rs.getString("BunFeld7"));
                    data.putValidOrDefaultValue(Tickets.FIELD_ANNOTATION, rs.getString("Anmerkung"));
                    String ticketOwner = rs.getString("ownerUUID");
                    if (ticketOwner != null) {
                        data.put(Tickets.FIELD_OWNER_GUID, GUID.valueOf((String)ticketOwner));
                    }
                    if ((lastEditor = rs.getString("lastEditorUUID")) != null) {
                        attributes.put(Tickets.ATTRIBUTE_LAST_EDITOR_GUID, GUID.valueOf((String)lastEditor));
                    }
                    if ((lastChangedBy = rs.getString("lastChangedByUUID")) != null) {
                        attributes.put(Tickets.ATTRIBUTE_LAST_CHANGED_BY_GUID, GUID.valueOf((String)lastChangedBy));
                    }
                    boolean autoEscalated = rs.getBoolean("AutoEscalated");
                    attributes.put(Tickets.ATTRIBUTE_AUTOESCALATED, autoEscalated);
                    for (TicketField<Object> field : this.registeredFields.getBaseFields()) {
                        storageLocationInfo = field.getStorageLocationInfo();
                        if (storageLocationInfo == null || !StorageLocationInfo.DbTable.TBLBUENDEL.equals((Object)storageLocationInfo.getTable())) continue;
                        Object object2 = rs.getObject(storageLocationInfo.getColumnName());
                        object2 = storageLocationInfo.convertStoredValueToDesiredType(object2, field.getValueType());
                        data.putValidOrDefaultValue(field, object2);
                    }
                    for (TicketAttribute att : this.ticketAttributes) {
                        storageLocationInfo = att.getStorageLocationInfo();
                        if (storageLocationInfo == null || !StorageLocationInfo.DbTable.TBLBUENDEL.equals((Object)storageLocationInfo.getTable())) continue;
                        Object object3 = rs.getObject(storageLocationInfo.getColumnName());
                        object3 = storageLocationInfo.convertStoredValueToDesiredType(object3, att.getValueType());
                        attributes.putValidOrDefaultValue(att, object3);
                    }
                    try {
                        InputStream inputStream = rs.getBinaryStream("Data");
                        if (inputStream == null) {
                            HDLogger.debug("[TicketReadDAO] Missing details of ticket with ID: " + ticketID + ". Default values will be used instead.");
                            details = TicketPersistenceUnit.createReplacementForCorruptedData();
                        } else {
                            details = (TicketPersistenceUnit)new Json().fromJson(inputStream, TicketPersistenceUnit.class);
                        }
                    }
                    catch (JsonException | IOException ex) {
                        String msg = "[TicketReadDAO] Could not read details of ticket with ID: " + ticketID + ". Default values will be used instead.";
                        HDLogger.warn(new HelpDeskServerException(msg, ex, HelpDeskErrorCodes.TICKET_DATA_CORRUPTED_DETAILS));
                        details = TicketPersistenceUnit.createReplacementForCorruptedData();
                    }
                    HashMap<String, String> persistedAdditionalFields = details.getFields();
                    for (TicketField<Object> ticketField : this.registeredFields.getAdditionalFields()) {
                        String fieldKey = ticketField.getKey();
                        if (!persistedAdditionalFields.containsKey(fieldKey)) continue;
                        String jsonData = persistedAdditionalFields.get(fieldKey);
                        try {
                            Object value2 = new Json().fromJson(jsonData, ticketField.getValueType());
                            data.putValidOrDefaultValue(ticketField, value2);
                        }
                        catch (JsonException ex) {
                            String msg = String.format("[TicketReadDAO] Could not deserialize value of field \"%s\" defined for ticket with ID \"%d\". Default value will be used instead.", fieldKey, ticketID);
                            HDLogger.warn(msg);
                            HDLogger.warn((Object)ex);
                        }
                    }
                    for (TicketAttribute ticketAttribute : this.ticketAttributes) {
                        if (attributes.containsAttribute(ticketAttribute)) continue;
                        attributes.put(ticketAttribute, ticketAttribute.getDefaultValue());
                    }
                    for (TicketField ticketField : this.registeredFields.getAllFields()) {
                        if (data.containsKey(ticketField)) continue;
                        data.put(ticketField, ticketField.getDefaultValue());
                    }
                    for (TicketAttribute ticketAttribute : this.ticketAttributes) {
                        if (!(ticketAttribute instanceof GeneratedTicketAttribute)) continue;
                        Object v = ((GeneratedTicketAttribute)ticketAttribute).getValueFor(ticketID);
                        attributes.put(ticketAttribute, v);
                    }
                    result.add(TicketVOSingle.create(ticketID, attributes, data));
                }
                catch (FieldValidationException ex) {
                    String msg = String.format("[TicketReadDAO] Ticket with ID=\"%d\" could not be loaded due to corrupted data.", ticketID);
                    HDLogger.error(new HelpDeskServerException(msg, (Throwable)ex, HelpDeskErrorCodes.TICKET_DATA_CORRUPTED_DETAILS));
                }
                PerformanceCheck.GETTICKETS.get().finishPhase("Fields");
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    private String getAdditionalFieldColumnsForSelect() {
        StringBuilder builder = new StringBuilder();
        Consumer<StorageLocationInfo> appendColumnName = storageLocationInfo -> {
            if (storageLocationInfo != null && StorageLocationInfo.DbTable.TBLBUENDEL.equals((Object)storageLocationInfo.getTable())) {
                builder.append("bun.");
                builder.append(storageLocationInfo.getColumnName());
                builder.append(", ");
            }
        };
        this.registeredFields.getBaseFields().stream().forEach(field -> appendColumnName.accept(field.getStorageLocationInfo()));
        this.ticketAttributes.stream().forEach(att -> appendColumnName.accept(att.getStorageLocationInfo()));
        return builder.toString();
    }

    @Override
    public TicketVOSingle getTicket(int ticketID) {
        String whereAufIdPart = " = ?";
        List<TicketVOSingle> tickets = this.loadTickets(whereAufIdPart, ticketID);
        if (tickets.isEmpty()) {
            return null;
        }
        return tickets.get(0);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getReaStepCountForTicket(int ticketId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Integer> getReaStepIDsForTicket(int ticketId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String sql = "SELECT ReaID FROM tblRealisierung WHERE OrgBunID = ?";
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setInt(1, ticketId);
            try (ResultSet rs = this.executeQueryWithToleranceOfTransientExceptions(pstm);){
                while (rs.next()) {
                    result.add(rs.getInt(1));
                }
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    public List<ReaStepVO> getReaStepsForTicket(int ticketId) {
        ArrayList<ReaStepVO> result = new ArrayList<ReaStepVO>();
        Object sql = this.createQueryForReaStepWithoutWherePart();
        String wherePart = "WHERE OrgBunID = ?";
        sql = (String)sql + wherePart;
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement((String)sql);){
            pstm.setInt(1, ticketId);
            try (ResultSet rs = this.executeQueryWithToleranceOfTransientExceptions(pstm);){
                while (rs.next()) {
                    ReaStepVO reaStep = this.createReaStepVoFromResultSet(rs);
                    result.add(reaStep);
                }
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    public Map<Integer, ReaStepTextVO> getReaStepTextsForTicket(int ticketId) {
        HashMap<Integer, ReaStepTextVO> result = new HashMap<Integer, ReaStepTextVO>();
        String sqlSelectPart = "SELECT ReaID, was, Auftrag, tblAuftraege.ishtml AS aih, tblRealisierung.ishtml AS rih FROM tblAuftraege";
        String sqlJoinPart = " RIGHT JOIN tblRealisierung ON tblRealisierung.ReaID=tblAuftraege.AnfReaID WHERE OrgBunID = ?";
        String sql = sqlSelectPart + sqlJoinPart;
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setInt(1, ticketId);
            try (ResultSet rs = this.executeQueryWithToleranceOfTransientExceptions(pstm);){
                while (rs.next()) {
                    int stepID = rs.getInt("ReaID");
                    String text = rs.getString("Auftrag");
                    if (text == null) {
                        text = rs.getString("was");
                    }
                    boolean htmlContent = rs.getInt("aih") != 0 || rs.getInt("rih") != 0;
                    result.put(stepID, ReaStepTextVO.of(text, htmlContent));
                }
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    public List<ReaStepTextVO> getReaStepTexts(List<Integer> reaStepIDs) {
        ArrayList<ReaStepTextVO> result = new ArrayList<ReaStepTextVO>();
        String sqlSelectPart = "SELECT ReaID, was, Auftrag, tblAuftraege.ishtml AS aih, tblRealisierung.ishtml AS rih FROM tblRealisierung";
        String sqlJoinPart = " LEFT JOIN tblAuftraege ON tblRealisierung.ReaID=tblAuftraege.AnfReaID WHERE ReaID IN (" + reaStepIDs.stream().map(id -> id.toString()).collect(Collectors.joining(",")) + ")";
        String sql = sqlSelectPart + sqlJoinPart;
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);
             ResultSet rs = this.executeQueryWithToleranceOfTransientExceptions(pstm);){
            while (rs.next()) {
                String text = rs.getString("Auftrag");
                if (text == null) {
                    text = rs.getString("was");
                }
                boolean htmlContent = rs.getInt("aih") != 0 || rs.getInt("rih") != 0;
                ReaStepTextVO reastep = ReaStepTextVO.of(text, htmlContent);
                result.add(reastep);
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    public ReaStepTextVO getReaStepText(int reaStepId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<TicketVOSingle> getTickets(Collection<Integer> ticketIds) {
        if (ticketIds == null) {
            throw new IllegalArgumentException("list of ticket IDs must not be null");
        }
        if (ticketIds.contains(null)) {
            throw new IllegalArgumentException("list of ticket IDs must not contain null");
        }
        ArrayList<Integer> remaining = new ArrayList<Integer>(ticketIds);
        ArrayList<TicketVOSingle> result = new ArrayList<TicketVOSingle>(ticketIds.size());
        while (!remaining.isEmpty()) {
            List toLoad = remaining.subList(0, Math.min(remaining.size(), 1000));
            String whereAUfIdCondition = " IN (" + toLoad.stream().map(id -> id.toString()).collect(Collectors.joining(",")) + ")";
            List<TicketVOSingle> loadedTickets = this.loadTickets(whereAUfIdCondition, -1);
            result.addAll(loadedTickets);
            toLoad.clear();
            PerformanceCheck.GETTICKETS.get().finishPhase("DAO: getTickets amount:" + toLoad.size());
        }
        return result;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    public List<Integer> getITILSlaves(int masterTicketID) {
        ArrayList<Integer> slaveIDs = new ArrayList<Integer>();
        String sqlSelectPart = "SELECT tblBuendel.BunID FROM tblAuftraege, tblBuendel, tblItilLinks";
        String sqlWherePartOne = String.format(" WHERE tblItilLinks.MasterAufID = %d AND tblBuendel.BunID = tblItilLinks.SlaveAufID", masterTicketID);
        String sqlWherePartTwo = " AND tblBuendel.Status > 99 AND tblBuendel.Status < 300 AND tblBuendel.BunID = tblAuftraege.AufID AND tblAuftraege.Master = 1";
        String sql = sqlSelectPart + sqlWherePartOne + sqlWherePartTwo;
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement stm = con.prepareStatement(sql);
             ResultSet rs = this.executeQueryWithToleranceOfTransientExceptions(stm);){
            while (rs.next()) {
                slaveIDs.add(rs.getInt(1));
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return slaveIDs;
    }

    @Override
    public Iterator<Integer> getTicketIdIterator() {
        String minMaxSQL = "SELECT MIN(AufID), MAX(AufID) FROM tblAuftraege";
        String sql = "SELECT AufID FROM tblAuftraege WHERE AufID BETWEEN ? AND ? ORDER BY AufID";
        return ResultSetIterator.create(this.connectionFactory, minMaxSQL, sql, rs -> rs.getInt(1));
    }

    @Override
    public Iterator<SlaveInfo> getSlaveInfoIterator() {
        String minMaxSQL = "SELECT MIN(AufID),MAX(AufID) FROM tblAuftraege";
        String sql = "SELECT a.AufID, a.BunID, UserUUID, GroupUUID FROM ((tblAuftraege a INNER JOIN tblAuftraege m ON a.BunID = m.AufID) LEFT OUTER JOIN tblRessourcen r on m.ResID = r.ResID) LEFT OUTER JOIN tblUser u on m.UsrID = u.UsrID WHERE a.AufID != a.BunID AND a.AufID BETWEEN ? AND ? ORDER BY a.AufID";
        return ResultSetIterator.create(this.connectionFactory, minMaxSQL, sql, rs -> {
            int aufID = rs.getInt(1);
            int bunID = rs.getInt(2);
            String str = rs.getString(3);
            GUID ownerID = str == null ? null : GUID.valueOf((String)str);
            str = rs.getString(4);
            GUID resID = str == null ? null : GUID.valueOf((String)str);
            return new SlaveInfo(aufID, bunID, ownerID, resID);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    public ReaStepVO getReaStep(int reaId) {
        Object sql = this.createQueryForReaStepWithoutWherePart();
        String wherePart = "WHERE tblRealisierung.ReaID = ?";
        sql = (String)sql + wherePart;
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement((String)sql);){
            pstm.setInt(1, reaId);
            try (ResultSet rs = this.executeQueryWithToleranceOfTransientExceptions(pstm);){
                if (!rs.next()) return null;
                ReaStepVO reaStepVO = this.createReaStepVoFromResultSet(rs);
                return reaStepVO;
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    private String createQueryForReaStepWithoutWherePart() {
        String sql = "SELECT tblRealisierung.ReaID, AktID, tblRealisierung.BunID, Description, EmailAn, EmailBCC, EmailCC, EmailIn, " + this.getSqlForReaStepTextLength() + ", Stundensatz, Pauschale, OrgBunID, RessID, UserID, DisplayName, StartZeit, EndZeit, bundleVisible, tblReaStepBinary.Data FROM tblRealisierung LEFT JOIN tblAuftraege ON tblRealisierung.ReaID=tblAuftraege.AnfReaID " + String.format("LEFT JOIN tblReaStepBinary ON tblRealisierung.ReaID = tblReaStepBinary.ReaID AND DataKey = '%s'", "reastepdetails");
        return sql;
    }

    private String getSqlForReaStepTextLength() {
        String sqlForTextLength = "length(was) as textlength, length(Auftrag) as textlengthAuftrag";
        String dbConfigs = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        if (dbConfigs != null) {
            DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
            DatabaseConfigInfo hdDb = list.get("HDS");
            if (hdDb != null && hdDb.getDriver() == DatabaseConfigInfo.DatabaseType.inetdae7) {
                sqlForTextLength = "datalength(was) as textlength, datalength(Auftrag) as textlengthAuftrag";
            }
            if (hdDb != null && hdDb.getDriver() == DatabaseConfigInfo.DatabaseType.inetora) {
                sqlForTextLength = "(CASE WHEN was IS NULL THEN 0 ELSE 1 END) as textlength, (CASE WHEN Auftrag IS NULL THEN 0 ELSE 1 END) as textlengthAuftrag";
            }
        }
        return sqlForTextLength;
    }

    private ReaStepVO createReaStepVoFromResultSet(ResultSet rs) throws SQLException {
        int reaStepID = rs.getInt("ReaID");
        Consumer<String> logWarningAboutMissingValue = name -> HDLogger.warn(String.format("[TicketReadDAO] Missing %s of rea step with ID \"%d\".", name, reaStepID));
        MutableReaStepAttributes attributes = new MutableReaStepAttributes();
        attributes.put(ReaStepVO.ATTRIBUTE_ACTION_ID, rs.getInt("AktID"));
        if (rs.wasNull()) {
            logWarningAboutMissingValue.accept("AktID");
        }
        attributes.put(ReaStepVO.ATTRIBUTE_BUN_ID, rs.getInt("BunID"));
        if (rs.wasNull()) {
            logWarningAboutMissingValue.accept("BunID");
        }
        attributes.put(ReaStepVO.ATTRIBUTE_ORG_BUN_ID, rs.getInt("OrgBunID"));
        if (rs.wasNull()) {
            logWarningAboutMissingValue.accept("OrgBunID");
        }
        attributes.put(ReaStepVO.ATTRIBUTE_HOURLY_RATE, rs.getDouble("Stundensatz"));
        attributes.put(ReaStepVO.ATTRIBUTE_LUMP_SUM, rs.getDouble("Pauschale"));
        attributes.putValidOrDefaultValue(ReaStepVO.ATTRIBUTE_RES_ID, rs.getInt("RessID"));
        attributes.putValidOrDefaultValue(ReaStepVO.ATTRIBUTE_BUNDLE_VISIBLE, rs.getBoolean("bundleVisible"));
        MutableReaStepData stepData = new MutableReaStepData();
        stepData.putValidOrDefaultValue(ReaStepVO.FIELD_DESC, rs.getString("Description"));
        stepData.putValidOrDefaultValue(ReaStepVO.FIELD_EMAIL_AN, rs.getString("EmailAn"));
        stepData.putValidOrDefaultValue(ReaStepVO.FIELD_EMAIL_BCC, rs.getString("EmailBCC"));
        stepData.putValidOrDefaultValue(ReaStepVO.FIELD_EMAIL_CC, rs.getString("EmailCC"));
        stepData.putValidOrDefaultValue(ReaStepVO.FIELD_EMAIL_IN, rs.getString("EmailIn"));
        int userID = rs.getInt("UserID");
        if (rs.wasNull()) {
            attributes.put(ReaStepVO.ATTRIBUTE_USER_ID, null);
        } else {
            GUID accountID;
            UserAccount userAccount = HDUsersAndGroups.getUserAccount(userID);
            if (userAccount != null) {
                accountID = userAccount.getID();
            } else {
                accountID = null;
                String msg = String.format("[TicketReadDAO] Could not find account for user with ID \"%d\", which is referenced by rea step with ID \"%d\".", userID, reaStepID);
                HDLogger.warn(msg);
            }
            attributes.put(ReaStepVO.ATTRIBUTE_USER_ID, accountID);
        }
        stepData.putValidOrDefaultValue(ReaStepVO.FIELD_USER_DISPLAY_NAME, rs.getString("DisplayName"));
        Timestamp startTime = rs.getTimestamp("StartZeit");
        Timestamp endTime = rs.getTimestamp("EndZeit");
        if (startTime != null && endTime != null) {
            Object processingTime;
            if (startTime.after(endTime)) {
                HDLogger.warn(String.format("[TicketReadDAO] Step %d of ticket %d contains corrupted time data (start is after end), now using only endTime", reaStepID, attributes.get(ReaStepVO.ATTRIBUTE_BUN_ID)));
                processingTime = ProcessingTime.of(endTime.getTime());
            } else {
                processingTime = ProcessingTime.of(startTime, endTime);
            }
            stepData.put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
        } else {
            logWarningAboutMissingValue.accept("processing time");
            stepData.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(0L));
        }
        this.loadReaStepAdditionalFields(rs, reaStepID, stepData);
        for (ReaStepAttribute att : this.reaStepAttributes) {
            if (attributes.containsAttribute(att)) continue;
            attributes.put(att, att.getDefaultValue());
        }
        for (ReaStepField field : this.registeredFields.getReaStepDefaultFields()) {
            if (stepData.containsField(field)) continue;
            stepData.put(field, field.getDefaultValue());
        }
        int length = rs.getInt("textlength");
        int lengthAuftrag = rs.getInt("textlengthAuftrag");
        attributes.put(ReaStepVO.ATTRIBUTE_HAS_TEXT, length > 0 || lengthAuftrag > 0);
        return ReaStepVO.create(reaStepID, attributes, stepData);
    }

    private void loadReaStepAdditionalFields(ResultSet rs, int reaStepId, MutableReaStepData stepData) throws SQLException {
        ReaStepPersistenceUnit details;
        try {
            InputStream inputStream = rs.getBinaryStream("Data");
            if (inputStream == null) {
                HDLogger.debug("[TicketReadDAO] Missing details of reaStep with ID: " + reaStepId + ". Default values will be used instead.");
                details = ReaStepPersistenceUnit.createReplacementForCorruptedData();
            } else {
                details = (ReaStepPersistenceUnit)new Json().fromJson(inputStream, ReaStepPersistenceUnit.class);
            }
        }
        catch (JsonException | IOException ex) {
            String msg = "[TicketReadDAO] Could not read details of reaStep with ID: " + reaStepId + ". Default values will be used instead.";
            HDLogger.warn(new HelpDeskServerException(msg, ex, HelpDeskErrorCodes.TICKET_DATA_CORRUPTED_DETAILS));
            details = ReaStepPersistenceUnit.createReplacementForCorruptedData();
        }
        HashMap<String, String> persistedAdditionalFields = details.getFields();
        for (ReaStepField field : this.registeredFields.getReaStepAdditionalFields()) {
            String fieldKey = field.getKey();
            if (!persistedAdditionalFields.containsKey(fieldKey)) continue;
            String jsonData = persistedAdditionalFields.get(fieldKey);
            try {
                Object value = new Json().fromJson(jsonData, field.getValueType());
                stepData.putValidOrDefaultValue(field, value);
            }
            catch (JsonException ex) {
                String msg = String.format("[TicketReadDAO] Could not deserialize value of field \"%s\" defined for reaStep with ID \"%d\". Default value will be used instead.", fieldKey, reaStepId);
                HDLogger.warn(msg);
                HDLogger.warn((Object)ex);
            }
        }
    }

    @Override
    public List<Integer> findTicketBundlesInRangeOfTicketIDs(int fromID, int toID) {
        return this.findTicketBundlesBy(TicketReadDAOImpl.createWherePartOfSqlStatementThatFindsTicketsById(fromID, toID), null);
    }

    @Override
    public List<Integer> findTicketBundlesByDate(long lastModified) {
        return this.findTicketBundlesBy(TicketReadDAOImpl.createWherePartOfSqlStatementThatFindsTicketsByDate(), lastModified);
    }

    @Override
    public List<Integer> findTicketBundlesMarkedAsDeleted() {
        return this.findTicketBundlesBy(TicketReadDAOImpl.createWherePartOfSqlStatementThatFindsAllTicketsMarkedAsDeleted(), null);
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Argument sql is generated without input-strings")
    private List<Integer> findTicketBundlesBy(String wherePartOfSqlStatement, @Nullable Long lastModified) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String createWherePartOfSqlStatementThatFindsTicketsById(int fromID, int toID) {
        return String.format("WHERE tblBuendel.BunID = tblAuftraege.BunID AND tblBuendel.BunID BETWEEN %d AND %d", fromID, toID);
    }

    public static String createWherePartOfSqlStatementThatFindsTicketsByDate() {
        return "WHERE tblBuendel.BunID = tblAuftraege.BunID AND tblBuendel.BearbeitungsDatum <= ?";
    }

    public static String createWherePartOfSqlStatementThatFindsAllTicketsMarkedAsDeleted() {
        return String.format("WHERE (tblBuendel.Status = %d ) AND tblBuendel.BunID = tblAuftraege.BunID", 400);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public TicketsInResource listTicketsInResource(int resourceID) {
        try (Connection con = this.connectionFactory.getConnection();){
            TicketsInResource ticketsInResource;
            block32: {
                Statement stm = con.createStatement();
                try {
                    HashMap<Integer, List<Integer>> ticketIdToSlaveTicketIDs = new HashMap<Integer, List<Integer>>();
                    String sql = String.format("SELECT AufID, BunID FROM tblAuftraege WHERE ResID=%d AND BunID IN (SELECT AufID FROM tblAuftraege WHERE ResID=%d)", resourceID, resourceID);
                    try (ResultSet rs = stm.executeQuery(sql);){
                        while (rs.next()) {
                            int bundleID;
                            int ticketID = rs.getInt(1);
                            if (ticketID == (bundleID = rs.getInt(2))) {
                                if (ticketIdToSlaveTicketIDs.containsKey(ticketID)) continue;
                                ticketIdToSlaveTicketIDs.put(ticketID, new ArrayList());
                                continue;
                            }
                            if (!ticketIdToSlaveTicketIDs.containsKey(bundleID)) {
                                ticketIdToSlaveTicketIDs.put(bundleID, new ArrayList());
                            }
                            ((List)ticketIdToSlaveTicketIDs.get(bundleID)).add(ticketID);
                        }
                    }
                    ArrayList<Integer> idsOfSlaveTicketsWithMastersInOtherResources = new ArrayList<Integer>();
                    sql = String.format("SELECT AufID FROM tblAuftraege WHERE ResID=%d AND BunID NOT IN (SELECT AufID FROM tblAuftraege WHERE ResID=%d)", resourceID, resourceID);
                    try (ResultSet rs = stm.executeQuery(sql);){
                        while (rs.next()) {
                            int ticketID = rs.getInt(1);
                            idsOfSlaveTicketsWithMastersInOtherResources.add(ticketID);
                        }
                    }
                    ticketsInResource = new TicketsInResource(ticketIdToSlaveTicketIDs, idsOfSlaveTicketsWithMastersInOtherResources);
                    if (stm == null) break block32;
                }
                catch (Throwable throwable) {
                    if (stm != null) {
                        try {
                            stm.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stm.close();
            }
            return ticketsInResource;
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    @Override
    public List<Integer> listTicketsWithReferencesToUser(int userID) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String sql = "SELECT tblAuftraege.AufID FROM tblAuftraege INNER JOIN tblBuendel ON tblAuftraege.AufID = tblBuendel.BunID WHERE tblAuftraege.UsrID = ? OR tblBuendel.LastEditorID = ? OR tblBuendel.LastChangedByID = ?";
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setInt(1, userID);
            pstm.setInt(2, userID);
            pstm.setInt(3, userID);
            try (ResultSet rs = this.executeQueryWithToleranceOfTransientExceptions(pstm);){
                while (rs.next()) {
                    result.add(rs.getInt(1));
                }
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    @Override
    public List<Integer> listAutoFinishableTickets(long currentTimeMillis, int requiredIdleDays) {
        Date zeitEnde = new Date(currentTimeMillis - TimeUnit.DAYS.toMillis(requiredIdleDays));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            zeitEnde = df.parse(df.format(zeitEnde));
        }
        catch (ParseException ex) {
            HDLogger.error(ex);
            return new ArrayList<Integer>();
        }
        String sql = "SELECT tblAuftraege.AufID, tblRealisierung.EndZeit FROM tblAuftraege LEFT JOIN tblBuendel ON tblAuftraege.BunID = tblBuendel.BunID LEFT JOIN tblRealisierung ON tblRealisierung.OrgBunID = tblAuftraege.AufID WHERE tblAuftraege.AufID = tblAuftraege.BunID AND tblBuendel.Status = 293 AND tblRealisierung.AktID IN (SELECT AktID FROM tblAktionen WHERE Status = 293) ORDER BY AufID, ReaID DESC";
        ArrayList<Integer> result = new ArrayList<Integer>();
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement stm = con.prepareStatement(sql);
             ResultSet rs = this.executeQueryWithToleranceOfTransientExceptions(stm);){
            int lastProcessedAufID = -999;
            while (rs.next()) {
                Date actionExecTime;
                int aufID = rs.getInt(1);
                if (lastProcessedAufID == aufID) continue;
                lastProcessedAufID = aufID;
                Timestamp timestamp = rs.getTimestamp(2);
                if (timestamp == null || (actionExecTime = new Date(timestamp.getTime())).compareTo(zeitEnde) >= 0) continue;
                result.add(aufID);
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    private ResultSet executeQueryWithToleranceOfTransientExceptions(PreparedStatement pstm) throws SQLException {
        return DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> pstm.executeQuery(), 10, 100);
    }

    public static class TicketsInResource {
        private Map<Integer, List<Integer>> ticketIdToSlaveTicketIDs;
        private List<Integer> idsOfSlaveTicketsWithMastersInOtherResources;

        private TicketsInResource(Map<Integer, List<Integer>> ticketIdToSlaveTicketIDs, List<Integer> idsOfSlaveTicketsWithMastersInOtherResources) {
            this.ticketIdToSlaveTicketIDs = Collections.unmodifiableMap(ticketIdToSlaveTicketIDs);
            this.idsOfSlaveTicketsWithMastersInOtherResources = Collections.unmodifiableList(idsOfSlaveTicketsWithMastersInOtherResources);
        }

        public Map<Integer, List<Integer>> getTicketIdToSlaveTicketIDs() {
            return this.ticketIdToSlaveTicketIDs;
        }

        public List<Integer> getIDsOfSlaveTicketsWithMastersInOtherResources() {
            return this.idsOfSlaveTicketsWithMastersInOtherResources;
        }
    }
}

