/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.adapt;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.data.ServerDataConnectorImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.ServerUtilities;
import srv.controller.OpenOrderController;
import srv.controller.UserSession;
import srv.controller.UserVersionManager;
import srv.controller.ticket.Auftrag;

public class OldApiAdapter {
    public static void removeReferenzOfBundle(int slaveId) {
        ServerUtilities.getOpenOrderController().removeSubReferenz(String.valueOf(slaveId));
    }

    public static void updateBuendelInOOCAndNotifyResource(Connection con, int ticketId) {
        OpenOrderController testConti = ServerUtilities.getOpenOrderController();
        testConti.checkOrders(con, new int[]{ticketId}, true);
        Auftrag auf = testConti.getAuftrag(ticketId);
        if (auf != null) {
            testConti.changeBuendelVersion(ticketId);
            testConti.getResource(auf.getResource().getId()).realizeChanges(testConti);
        }
    }

    public static UserSession aktualisiereUserSessionInMetaController(int sessionId, UserAccount currentAccount) {
        UserSession userSession = ServerUtilities.conti.aktualisiereUserSession(sessionId, HDUsersAndGroups.getUserID(currentAccount));
        return userSession;
    }

    public static void updateTicketInMCOrOOC(int ticketID, TicketVO oldTicket, TicketVO newTicket) {
        TicketVO request = ServerUtilities.conti.getRequest(ticketID);
        if (request != null) {
            ServerUtilities.conti.setChanged(7, false);
            if (request.getOwnerID() != null) {
                UserVersionManager.getInstance().incOrderVersion(request.getOwnerID());
            }
        } else {
            GUID userId;
            ServerUtilities.getOpenOrderController().ticketChanged(ticketID, oldTicket, newTicket);
            GUID gUID = userId = newTicket != null ? newTicket.getOwnerID() : oldTicket.getOwnerID();
            if (userId != null) {
                UserVersionManager.getInstance().incOrderVersion(userId);
            }
        }
    }

    public static void writeSearchTicketsToDB(Collection<Integer> tickets, int searchID) throws ServerDataException {
        try (Connection conn = ServerUtilities.getJJServer().getConnection("HDS");){
            try (PreparedStatement deleteStatement = conn.prepareStatement("DELETE FROM tblSearchresult WHERE SearchID = ?");){
                deleteStatement.setInt(1, searchID);
                deleteStatement.execute();
            }
            try (PreparedStatement statement = conn.prepareStatement("INSERT INTO tblSearchresult(BunID, SearchID) VALUES (?,?)");){
                statement.setInt(2, searchID);
                for (Integer ticketId : tickets) {
                    statement.setInt(1, ticketId);
                    statement.execute();
                }
            }
        }
        catch (SQLException e) {
            throw new ServerDataException(e);
        }
    }

    public static List<Integer> getSearchedTickets(int userAccountID, int searchID) throws ServerDataException {
        ArrayList<Integer> arrayList;
        String pstString = "SELECT BunID FROM tblSearchresult WHERE tblSearchresult.SearchID = ? ";
        Connection con = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            UserAccount userAccount = HDUsersAndGroups.getUserAccount(userAccountID);
            if (userAccount == null) {
                throw new ServerDataException(new IllegalArgumentException("The user #" + userAccountID + " does not exist."));
            }
            con = ServerUtilities.getJJServer().getConnection("HDS");
            pst = con.prepareStatement(pstString);
            pst.setInt(1, searchID);
            rs = pst.executeQuery();
            ArrayList<Integer> ticketsOfSearch = new ArrayList<Integer>();
            while (rs.next()) {
                int ticketId = rs.getInt("BunID");
                ticketsOfSearch.add(ticketId);
            }
            arrayList = ticketsOfSearch;
        }
        catch (SQLException ex) {
            try {
                throw new ServerDataException(ex);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, pst, rs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, pst, rs);
        return arrayList;
    }

    @Nonnull
    public static String nullToEmpty(@Nullable String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static void reloadBundledTickets(int masterTicketID, List<Integer> slaveTicketIDs) {
        ServerUtilities.getOpenOrderController().reloadBundledTickets(masterTicketID, slaveTicketIDs);
    }
}

