/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.access;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketPermissionChecker;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldSettings;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import javax.annotation.Nullable;

public class TicketPermissionCheckerImpl
implements TicketPermissionChecker {
    private TicketReadDAO readDAO;

    public TicketPermissionCheckerImpl(TicketReadDAO readDAO) {
        this.readDAO = readDAO;
    }

    @Override
    public boolean checkCurrentUserCanReadTicket(int ticketId) {
        TicketPermissionContext context = this.getTicketPermissionInfo(ticketId);
        return context == null || context.hasAnyAccessToTicket();
    }

    @Override
    public boolean checkCurrentUserCanReadReaStep(int reaStepID) {
        ReaStepVO reaStep = this.readDAO.getReaStep(reaStepID);
        if (reaStep == null) {
            return true;
        }
        int ticketId = reaStep.getOrgBunID();
        TicketPermissionContext context = this.getTicketPermissionInfo(ticketId);
        if (context == null) {
            return true;
        }
        if (context.hasAnyAccessToTicket()) {
            return true;
        }
        for (TicketVOSingle bundleMember : this.readDAO.getTicketsInBundle(reaStep.getBunID(), true)) {
            context = this.getTicketPermissionInfo(bundleMember.getID());
            if (context == null || !context.hasEnduserAccessToTicket() || !reaStep.isBundleVisible()) continue;
            return true;
        }
        return false;
    }

    private boolean hasOwnerAccess(@Nullable GUID ownerGUID, TicketVO ticket) {
        if (ownerGUID == null) {
            return false;
        }
        if (ticket.getWorkflowID() != null && ticket.getWorkflowID().intValue() != ticket.getID()) {
            return false;
        }
        boolean hasAccess = false;
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            return false;
        }
        if (userAccount != null && userAccount.getID().equals((Object)ownerGUID)) {
            hasAccess = true;
        } else {
            Integer ownerGroupId;
            UserAccount ownerUser;
            int ownerId = HDUsersAndGroups.getUserID(ownerGUID);
            if (ownerId > -1 && (ownerUser = HDUsersAndGroups.getUserAccount(ownerId)) != null && (ownerGroupId = (Integer)ownerUser.getValue((UserField)HDUsersAndGroups.FIELD_GROUP_ID)) != null) {
                UserGroupVOManager groupManager = UserGroupVOManager.getInstance();
                List<UserGroupVO> usergroups = groupManager.getGroupsWhereUserIsSupervisor(userAccount.getID());
                for (UserGroupVO currentusergroup : usergroups) {
                    if (currentusergroup.getId() != ownerGroupId.intValue()) continue;
                    hasAccess = true;
                }
            }
        }
        return hasAccess;
    }

    @Override
    public boolean checkCurrentUserCanWriteTicket(int ticketID) {
        TicketPermissionContext context = this.getTicketPermissionInfo(ticketID);
        if (context == null) {
            return true;
        }
        if (!context.hasAnyAccessToTicket()) {
            return false;
        }
        if (context.isTicketOwner()) {
            return true;
        }
        if (context.getSupporterPermissions() == TicketPermissionContext.SupporterPermission.READWRITE) {
            return true;
        }
        return context.hasDispatcherAccessToTicket();
    }

    @Override
    public void throwExceptionIfCurrentUserIsNotDispatcher() throws AccessDeniedException {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null || !SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.DISPATCHER})) {
            throw new AccessDeniedException(HdPermissions.DISPATCHER);
        }
    }

    @Override
    public boolean checkCanChangeOwnerInTicket(int ticketID) {
        UserGroupInfo ugi;
        TicketVO ticket = TicketManager.getReader().getTicket(ticketID);
        if (ticket == null) {
            return false;
        }
        GUID resourceID = ticket.getResourceID();
        return resourceID == null || ResourceFieldSettings.isSet((Integer)(ugi = UserGroupManager.getInstance().getGroup(resourceID)).getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS), 2);
    }

    @Override
    public TicketPermissionContext getTicketPermissionInfo(int ticketID) throws AccessDeniedException {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        if (ticket == null) {
            return null;
        }
        return this.getTicketPermissionInfo(ticket);
    }

    @Override
    public TicketPermissionContext getTicketPermissionInfo(TicketVO ticket) throws AccessDeniedException {
        boolean isOwner = false;
        GUID ownerGUID = ticket.getOwnerID();
        isOwner = this.hasOwnerAccess(ownerGUID, ticket);
        TicketPermissionContext.SupporterPermission perm = TicketPermissionContext.SupporterPermission.NONE;
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            throw new AccessDeniedException();
        }
        if (!ticket.isInquiry()) {
            if (SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE})) {
                perm = TicketPermissionContext.SupporterPermission.READWRITE;
            } else {
                GUID resourceID;
                if (SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ})) {
                    perm = TicketPermissionContext.SupporterPermission.READ;
                }
                if (ticket.getID() != ticket.getBundleID()) {
                    ticket = TicketManager.getReaderForSystem().getTicket(ticket.getBundleID());
                }
                if ((resourceID = ticket.getResourceID()) != null) {
                    UserGroupInfo ressourceGroup = UserGroupManager.getInstance().getGroup(resourceID);
                    if (HDUsersAndGroups.hasWritePermissionInResource(currentUserAccount.getID(), ressourceGroup)) {
                        perm = TicketPermissionContext.SupporterPermission.READWRITE;
                    } else if (HDUsersAndGroups.hasAccessInResource(currentUserAccount.getID(), ressourceGroup)) {
                        perm = TicketPermissionContext.SupporterPermission.READ;
                    }
                }
            }
        }
        return new TicketPermissionContext(isOwner, perm, ticket.isInquiry());
    }

    @Override
    public boolean isDispatcher() {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            throw new AccessDeniedException();
        }
        return HDUsersAndGroups.isDispatcher(userAccount);
    }
}

