/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TicketManipulatorSync {
    private static final ThreadUtils.Semaphore CREATE_NEW_TICKET = ThreadUtils.getSemaphore((Object)"TicketManager_createTicket");

    public static ServerLock getTicketLock(TicketVO ticket) {
        return TicketManipulatorSync.getTicketLock(ticket.getBundleID());
    }

    public static ServerLock getTicketLock(int bunId) {
        return ThreadUtils.getLock((Object)TicketManipulatorSync.getTicketSemaphore(bunId));
    }

    @Nullable
    public static ServerLock tryTicketLock(int bunId) {
        return ThreadUtils.tryLock((Object)TicketManipulatorSync.getTicketSemaphore(bunId));
    }

    private static ThreadUtils.Semaphore getTicketSemaphore(int bunId) {
        return ThreadUtils.getSemaphore((Object)("TicketManipulation-" + bunId));
    }

    public static ServerLock getTicketCreationLock() {
        return ThreadUtils.getLock((Object)CREATE_NEW_TICKET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized <T> T doOperationOwningAllMontors(List<Integer> ticketBunIDs, Callable<T> operation) {
        try {
            if (ticketBunIDs.isEmpty()) {
                return operation.call();
            }
            List<ServerLock> locks = ticketBunIDs.stream().map(bunId -> TicketManipulatorSync.getTicketLock(bunId)).collect(Collectors.toList());
            try {
                T t = operation.call();
                return t;
            }
            finally {
                locks.forEach(ServerLock::close);
            }
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
    }
}

