/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.util;

import com.inet.helpdesk.config.AddonConfig;
import com.inet.helpdesk.config.AddonConfigList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class AddonPropertiesUtils {
    public static final String SUB_KEY_CLASS = ".class";
    public static final String SUB_KEY_EXECUTE = ".execute";
    public static final String SUB_KEY_IMAGE = ".image";
    public static final String SUB_KEY_POS = ".pos";
    public static final String SUB_KEY_RECHTE = ".rechte";
    public static final String SUB_KEY_TITEL = ".titel";
    public static final String SUB_KEY_TYP = ".typ";

    public static Vector<String> fetchAddonKeys(Properties addonProperties) {
        Vector<String> addonkeys = new Vector<String>();
        if (addonProperties == null) {
            return addonkeys;
        }
        Enumeration<?> names = addonProperties.propertyNames();
        while (names.hasMoreElements()) {
            String name = String.valueOf(names.nextElement());
            if (name.indexOf(46) >= 0 || !name.startsWith("addons")) continue;
            addonkeys.addElement(name);
        }
        return addonkeys;
    }

    public static AddonConfigList createAddonConfigurationFrom(Properties addonProperties) {
        AddonConfigList addonConfigurations = new AddonConfigList();
        if (addonProperties == null) {
            return addonConfigurations;
        }
        Vector<String> addonKeys = AddonPropertiesUtils.fetchAddonKeys(addonProperties);
        for (String key : addonKeys) {
            AddonConfig addonCfg = AddonPropertiesUtils.createConfigurationForSingleAddon(key, addonProperties);
            if (addonCfg == null) continue;
            addonConfigurations.add(addonCfg);
        }
        return addonConfigurations;
    }

    private static AddonConfig createConfigurationForSingleAddon(String addonKey, Properties addonProperties) {
        String className = addonProperties.getProperty(addonKey + SUB_KEY_CLASS);
        if (className == null) {
            return null;
        }
        String dialogKey = addonProperties.getProperty(addonKey);
        String executionParameter = addonProperties.getProperty(addonKey + SUB_KEY_EXECUTE);
        String imageFileName = addonProperties.getProperty(addonKey + SUB_KEY_IMAGE);
        String position = addonProperties.getProperty(addonKey + SUB_KEY_POS);
        String requiredRights = addonProperties.getProperty(addonKey + SUB_KEY_RECHTE);
        String title = addonProperties.getProperty(addonKey + SUB_KEY_TITEL);
        String type = addonProperties.getProperty(addonKey + SUB_KEY_TYP);
        if (className.startsWith("atts.")) {
            className = className.replace("atts.", "addons.");
        }
        AddonConfig addonCfg = new AddonConfig();
        addonCfg.setClassName(className);
        addonCfg.setDialogKey(dialogKey);
        addonCfg.setExecutionParameter(executionParameter);
        addonCfg.setImageFileName(imageFileName);
        addonCfg.setPosition(position);
        addonCfg.setRequiredRights(requiredRights);
        addonCfg.setTitle(title);
        addonCfg.setType(type);
        return addonCfg;
    }
}

