/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.servlets.rpc.handler;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.servlets.rpc.AbstractPacketHandler;
import com.inet.helpdesk.servlets.rpc.handler.UserResponseCreator;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.shared.search.rpc.UserDetailRequestData;
import com.inet.helpdesk.shared.search.rpc.UserDetailResponseData;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.usersandgroups.api.user.UserAccount;
import javax.servlet.http.HttpServletRequest;

public class UserDetailHandler
extends AbstractPacketHandler<UserDetailRequestData, UserDetailResponseData> {
    private final UserResponseCreator responseCreator;

    public UserDetailHandler(UserResponseCreator responseCreator) {
        this.responseCreator = responseCreator;
    }

    @Override
    public String getCommand() {
        return "userdetail";
    }

    @Override
    protected UserDetailResponseData handle(HttpServletRequest request, UserDetailRequestData input) {
        try {
            int userId = Integer.parseInt(input.getUserId());
            return this.responseCreator.createWithFactory((user, locale) -> {
                UserAccount userAccount = HDUsersAndGroups.getUserAccount(userId);
                if (userAccount == null) {
                    return null;
                }
                User userModel = UserModelConverter.convertUserAccount(userAccount);
                return new UserDetailResponseData(userModel);
            });
        }
        catch (Exception ex) {
            HDLogger.error(ex);
            return null;
        }
    }
}

