/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.servlets.rpc.handler;

import com.inet.authentication.LoginProcessor;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerInitializerStatus;
import com.inet.helpdesk.core.data.UserDataConnector;
import com.inet.helpdesk.core.servlets.rpc.AbstractPacketHandler;
import com.inet.helpdesk.plugin.PluginEntryPoint;
import com.inet.helpdesk.plugin.StartInfoResponse;
import com.inet.helpdesk.servlets.rpc.handler.UserResponseCreator;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.client.ClientPlugin;
import com.inet.plugin.veto.VetoStatus;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class PluginsPacketHandler
extends AbstractPacketHandler<Void, StartInfoResponse> {
    private static final ConfigValue<String> FRAME_TITLE = new ConfigValue(ConfigKey.PRODUCT_NAME);
    private final ServerInitializerStatus status;
    private final ServerPluginManager pluginManager;
    private final UserResponseCreator responseCreator;
    private UserDataConnector dataConnector;

    public PluginsPacketHandler(ServerInitializerStatus status, ServerPluginManager pluginManager, UserResponseCreator responseCreator) {
        this.status = status;
        this.pluginManager = pluginManager;
        this.responseCreator = responseCreator;
    }

    @Override
    public String getCommand() {
        return "StartInfo";
    }

    @Override
    public StartInfoResponse handle(HttpServletRequest request, Void input) {
        String msg;
        VetoStatus currentVeto;
        if (this.dataConnector == null) {
            this.dataConnector = (UserDataConnector)this.pluginManager.getSingleInstance(UserDataConnector.class);
        }
        if (this.status != null && (currentVeto = this.status.getCurrentVeto()) != null && (msg = currentVeto.getMessage()) != null && msg.length() > 0) {
            throw new IllegalStateException(msg);
        }
        LoginProcessor loginProcessor = LoginProcessor.getCurrent();
        String webUserName = loginProcessor != null ? loginProcessor.getLoginID() : null;
        try {
            return this.responseCreator.createWithFactory((user, locale) -> {
                ArrayList<ClientPlugin> list = this.getClientPlugins();
                StartInfoResponse info = new StartInfoResponse(webUserName, list);
                info.setFrameTitle((String)FRAME_TITLE.get());
                return info;
            });
        }
        catch (Exception e) {
            HDLogger.error(e);
            return new StartInfoResponse(webUserName, new ArrayList<ClientPlugin>());
        }
    }

    private ArrayList<ClientPlugin> getClientPlugins() {
        ArrayList<ClientPlugin> plugins = new ArrayList<ClientPlugin>();
        List entyPoints = this.pluginManager.get(PluginEntryPoint.class);
        for (PluginEntryPoint p : entyPoints) {
            try {
                plugins.addAll(p.getClientPlugins());
            }
            catch (Throwable er) {
                HDLogger.error(er);
            }
        }
        return plugins;
    }
}

