/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.servlets;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.http.PluginServlet;
import com.inet.shared.servlet.ServletUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DictionariesServlet
extends HttpServlet
implements PluginServlet {
    private static final String[] ALLOWED_EXTENSIONS = new String[]{".cnf", ".txt", ".bin", ".properties"};
    private ConfigValue<String> CUSTOM_DICT_LOCATION = new ConfigValue(HDConfigKeys.CUSTOM_DICTIONARY_LOCATION);

    @Nonnull
    public String getPathSpec() {
        return "/dictionaries";
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="the file name comes not from the user")
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        File file = null;
        if (path != null) {
            if (req.getPathInfo().contains("/custom/")) {
                Object lang = req.getPathInfo().substring(req.getPathInfo().lastIndexOf(47) + 1);
                boolean firstTryDefaultLocale = false;
                if (Locale.getDefault().getLanguage().equals(lang)) {
                    firstTryDefaultLocale = true;
                }
                if (((String)lang).length() > 0) {
                    lang = "_" + (String)lang;
                }
                String dictLocation = (String)this.CUSTOM_DICT_LOCATION.get();
                Path appDataLocation = AppDataLocation.getBaseLocationPath();
                File dictDir = appDataLocation.resolve(dictLocation).toFile();
                if (firstTryDefaultLocale) {
                    file = new File(dictDir, "custom.txt");
                    if (!file.exists()) {
                        file = new File(dictDir, "custom" + (String)lang + ".txt");
                    }
                } else {
                    file = new File(dictDir, "custom" + (String)lang + ".txt");
                }
                if (!file.exists()) {
                    ServletUtils.sendStaticContent((String)"text/plain", (long)System.currentTimeMillis(), (int)0, (InputStream)new ByteArrayInputStream(new byte[0]), (HttpServletRequest)req, (HttpServletResponse)res);
                    return;
                }
            } else {
                for (String ext : ALLOWED_EXTENSIONS) {
                    if (!path.endsWith(ext)) continue;
                    file = new File(new File("../Client/dictionaries"), path);
                    break;
                }
            }
        }
        ServletUtils.sendStaticContent(file, (HttpServletRequest)req, (HttpServletResponse)res);
    }
}

