/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.search.user;

import com.inet.helpdesk.data.userfilter.UserFilterCombined;
import com.inet.id.GUID;
import com.inet.search.SearchResultEntry;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;

public class SearchResultsBooster {
    private UserFilterCombined boostFilter;

    public SearchResultsBooster(UserFilterCombined boostFilter) {
        this.boostFilter = boostFilter;
    }

    public void boostSearchResultEntry(List<SearchResultEntry<GUID>> list) {
        EntryIdExtractor entryIdExtractor = new EntryIdExtractor(){

            @Override
            public GUID getId(Object entry) {
                SearchResultEntry searchResultEntry = (SearchResultEntry)entry;
                GUID id = (GUID)searchResultEntry.getId();
                return id;
            }
        };
        this.boost(list, entryIdExtractor);
    }

    private <E> void boost(List<E> list, EntryIdExtractor entryIdExtractor) {
        if (this.boostFilter == null) {
            return;
        }
        int insertIndex = 0;
        for (int currentIndex = 0; currentIndex < list.size(); ++currentIndex) {
            E entry = list.get(currentIndex);
            GUID entryId = entryIdExtractor.getId(entry);
            UserAccount userAccount = UserManager.getInstance().getUserAccount(entryId);
            if (this.boostFilter.score(userAccount) <= 0) continue;
            list.add(insertIndex++, list.remove(currentIndex));
        }
    }

    private static interface EntryIdExtractor {
        public GUID getId(Object var1);
    }
}

