/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.search;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.Searcher;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.search.SqlQueryThread;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;

public class SearcherImpl
implements Searcher {
    private static final String FALSE = "false";
    private static final String WHERE_START = "false AND ";
    private static final int MAX_IN_COUNT = 350;
    private static final int LARGE_STRING_BUILDER_SIZE = 10000;
    private static final int MEDIUM_STRING_BUILDER_SIZE = 200;
    private static final int MAX_QUERY_WAIT = 40000;
    public static final int SEARCH_IN_ALL_FIELDS = 7;
    static final String DELETE_SEARCH_RESULT = "DELETE FROM tblSearchresult WHERE SearchID = ?";
    private static final String OR = " OR ";
    private boolean cancel = false;
    private boolean finished;

    @Override
    public void cancelSearch() {
        this.cancel = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Internal Searcher API")
    public int prepareItilProblemSearch(Connection con, int searchID, String masterID, String whereString) throws SQLException {
        boolean andAvailable;
        this.finished = false;
        if (masterID == null || masterID.length() == 0) {
            throw new SQLException("No master id.");
        }
        SearcherImpl.deleteOldResults(con, searchID);
        int andPos = whereString.indexOf(" AND");
        boolean bl = andAvailable = andPos > -1;
        if (andAvailable) {
            Statement statement = null;
            try {
                statement = con.createStatement();
                ResultSet rs = statement.executeQuery("SELECT AufID FROM tblAuftraege WHERE AufID = " + masterID + whereString.substring(andPos));
                if (rs.next()) {
                    andAvailable = false;
                }
                rs.close();
            }
            catch (SQLException er) {
                throw er;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        StringBuilder sqlBuf = new StringBuilder(200);
        if (whereString.startsWith(FALSE)) {
            sqlBuf.append("INSERT INTO tblSearchresult(BunID, SearchID) SELECT DISTINCT tblAuftraege.AufID, ").append(searchID).append(" FROM tblAuftraege, qryItilValidRelations, tblItil Where qryItilValidRelations.MasterAufID = ").append(masterID);
            sqlBuf.append("AND tblItil.ItiID = tblAuftraege.ItiID AND (").append(whereString.substring(WHERE_START.length())).append("OR tblItil.protectedContent = 0)");
        } else {
            sqlBuf.append("INSERT INTO tblSearchresult(BunID, SearchID) SELECT DISTINCT tblAuftraege.AufID, ").append(searchID).append(" FROM tblAuftraege, qryItilValidRelations Where qryItilValidRelations.MasterAufID = ").append(masterID);
        }
        if (andAvailable) {
            sqlBuf.append(" AND (qryItilValidRelations.MasterAufID = tblAuftraege.AufID OR (qryItilValidRelations.SlaveAufID = tblAuftraege.AufID").append(whereString.substring(andPos)).append("))");
        } else {
            sqlBuf.append(" AND (qryItilValidRelations.MasterAufID = tblAuftraege.AufID OR qryItilValidRelations.SlaveAufID = tblAuftraege.AufID)");
        }
        Statement itilStatement = null;
        try {
            if (!this.cancel) {
                itilStatement = con.createStatement();
                itilStatement.execute(sqlBuf.toString());
            } else {
                this.cancel = false;
            }
        }
        catch (SQLException error) {
            throw SearcherImpl.wasTimeoutException(error);
        }
        finally {
            if (itilStatement != null) {
                try {
                    itilStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            this.finished = true;
        }
        return searchID;
    }

    @Override
    public int prepareSearch(Connection con, int searchID, int searchWo, String searchText, String whereString) throws SQLException {
        if (whereString == null) {
            whereString = "";
        }
        this.finished = false;
        SearcherImpl.deleteOldResults(con, searchID);
        try {
            if (searchText != null && ((searchText = searchText.replaceAll("[*]+", "*")).trim().equals("?*") || searchText.trim().equals("*?") || searchText.equals("*"))) {
                searchText = "";
            }
            boolean withUsers = ((String)whereString).toLowerCase().indexOf("tbluser") != -1;
            StringBuilder whereStart = new StringBuilder(" WHERE ");
            whereStart.append(" tblAuftraege.BunID = tblBuendel.BunID ");
            Object fromString = " FROM tblAuftraege, tblBuendel ";
            if (withUsers) {
                fromString = (String)fromString + ", tblUser ";
                whereStart.append(" AND tblAuftraege.UsrID = tblUser.UsrID ");
            }
            ArrayList<SqlQueryThread> queryThreads = new ArrayList();
            if (searchText == null || searchText.length() == 0) {
                if (((String)whereString).startsWith("OR ")) {
                    int indexKlammer = 0;
                    int countOffeneKlammern = 0;
                    indexKlammer = ((String)whereString).indexOf("(");
                    while (indexKlammer > -1) {
                        indexKlammer = ((String)whereString).indexOf("(", indexKlammer + 1);
                        ++countOffeneKlammern;
                    }
                    indexKlammer = ((String)whereString).indexOf(")");
                    int countGeschlosseneKlammern = 0;
                    while (indexKlammer > -1) {
                        indexKlammer = ((String)whereString).indexOf(")", indexKlammer + 1);
                        ++countGeschlosseneKlammern;
                    }
                    if (countGeschlosseneKlammern > countOffeneKlammern) {
                        whereString = " AND ( 1=0 " + (String)whereString;
                    }
                }
                String query = "INSERT INTO tblSearchresult (SearchID, BunID) SELECT " + searchID + ", tblBuendel.BunID as BunID " + (String)fromString + whereStart + (String)whereString + " GROUP BY tblBuendel.BunID";
                HDLogger.debug(query);
                SqlQueryThread queryThread = new SqlQueryThread(query, con, false);
                if (!this.cancel) {
                    queryThread.start();
                    queryThread.join(40000L);
                } else {
                    this.cancel = false;
                }
                if (queryThread.wasError()) {
                    this.finished = true;
                    throw queryThread.getError();
                }
            } else {
                TextSearchCommandBuilder textsearchcommand;
                IndexSearchEngine<Integer> searchengine;
                HDLogger.debug(whereString);
                LinkedHashSet<String> bunids = new LinkedHashSet<String>();
                if (((String)whereString).contains("tblAuftraege.UsrID") || ((String)whereString).contains("tblUser.UsrID")) {
                    searchengine = TicketManager.getReader().getSearchEngine();
                    textsearchcommand = new TextSearchCommandBuilder(searchengine, searchText);
                    SearchCommand searchCommand = SearcherImpl.createSearchCommand(searchWo, textsearchcommand.build());
                    SearchResult results = searchengine.search(searchCommand);
                    for (SearchResultEntry entry : results.getEntries()) {
                        bunids.add(((Integer)entry.getId()).toString());
                    }
                    HDLogger.debug(bunids);
                } else {
                    searchengine = TicketManager.getReader().getSearchEngine();
                    textsearchcommand = new TextSearchCommandBuilder(searchengine, searchText);
                    SearchCommand searchCommand = SearcherImpl.createSearchCommand(searchWo, textsearchcommand.build());
                    SearchResult results = searchengine.search(searchCommand);
                    for (SearchResultEntry entry : results.getEntries()) {
                        bunids.add(((Integer)entry.getId()).toString());
                    }
                }
                whereStart.append(" AND ");
                if (((String)whereString).startsWith("OR ")) {
                    whereStart.append(" ( ");
                }
                String query = "SELECT tblBuendel.BunID as BunID" + (String)fromString + whereStart;
                if (bunids != null) {
                    if (bunids.size() > 0 && !bunids.contains("all")) {
                        query = query + " tblAuftraege.BunID IN (";
                    }
                    queryThreads = SearcherImpl.executeSearchThreads(con, bunids.toArray(), query, (String)whereString);
                    LinkedHashSet<String> resultids = SearcherImpl.getResultsFromQuery(queryThreads);
                    HDLogger.debug("resultids :" + resultids.toString());
                    if (!this.cancel) {
                        SearcherImpl.insertIntoSearchResults(con, searchID, resultids);
                    } else {
                        this.cancel = false;
                    }
                }
            }
        }
        catch (Exception e) {
            this.finished = true;
            throw SearcherImpl.wasTimeoutException(e);
        }
        this.finished = true;
        return searchID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserRestrictions() {
        Statement statement = null;
        ResultSet resultset = null;
        Connection con = null;
        Object restrictions = "";
        try {
            if (ServerUtilities.isDatabaseConnectionValid()) {
                con = ServerUtilities.getJJServer().getConnection("HDS");
                statement = con.createStatement();
                resultset = statement.executeQuery("SELECT AktID FROM tblAktionen Where UserInVis = 0");
                while (resultset.next()) {
                    if (((String)restrictions).length() == 0) {
                        restrictions = "AND (aktid:" + resultset.getString(1);
                        continue;
                    }
                    restrictions = (String)restrictions + " OR aktid:" + resultset.getString(1);
                }
            }
        }
        catch (Throwable e) {
            HDLogger.error(e);
            SQLException sqlException = new SQLException("Indexer");
            sqlException.initCause(e);
            HDLogger.error(sqlException);
        }
        finally {
            try {
                if (resultset != null) {
                    resultset.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Throwable throwable) {}
        }
        if (((String)restrictions).length() > 0) {
            restrictions = (String)restrictions + ")";
        }
        return restrictions;
    }

    private static LinkedHashSet<String> getResultsFromQuery(ArrayList<SqlQueryThread> queryThreads) throws InterruptedException, SQLException {
        LinkedHashSet<String> resultids = new LinkedHashSet<String>();
        for (SqlQueryThread thread : queryThreads) {
            thread.join(40000L);
            if (thread.wasError()) {
                throw thread.getError();
            }
            resultids.addAll(thread.getBunIDs());
        }
        HDLogger.debug("Gefundenen Tickets :" + resultids.size());
        return resultids;
    }

    private static ArrayList<SqlQueryThread> executeSearchThreads(Connection con, Object[] possibleBunids, String query, String whereString) throws IOException, SQLException {
        StringBuilder bunids = new StringBuilder(10000);
        ArrayList<SqlQueryThread> queryThreads = new ArrayList<SqlQueryThread>();
        if (possibleBunids.length > 0) {
            if (((String)possibleBunids[0]).equals("all")) {
                if (((String)query).toLowerCase().trim().endsWith("and")) {
                    query = (String)query + "1=1";
                }
                if (((String)whereString).toLowerCase().startsWith("or ")) {
                    whereString = " 1=1 " + (String)whereString;
                }
                SqlQueryThread queryThread = new SqlQueryThread((String)query + (String)whereString + " GROUP BY tblBuendel.BunID", con, true);
                queryThreads.add(queryThread);
                queryThread.start();
            } else {
                for (int i = 0; i < possibleBunids.length; ++i) {
                    if (bunids.length() == 0) {
                        bunids.append(possibleBunids[i]);
                    } else {
                        bunids.append(", " + possibleBunids[i]);
                    }
                    if (i == 0 || i % 350 != 0) continue;
                    SqlQueryThread queryThread = new SqlQueryThread((String)query + bunids.toString() + ") " + (String)whereString + " GROUP BY tblBuendel.BunID", con, true);
                    queryThreads.add(queryThread);
                    queryThread.start();
                    bunids.delete(0, bunids.length());
                }
                if (bunids.length() > 0) {
                    SqlQueryThread queryThread = new SqlQueryThread((String)query + bunids.toString() + ") " + (String)whereString + " GROUP BY tblBuendel.BunID", con, true);
                    queryThreads.add(queryThread);
                    queryThread.start();
                }
            }
        } else if (((String)whereString).startsWith("OR")) {
            SqlQueryThread queryThread = new SqlQueryThread((String)query + " 1=0 " + (String)whereString + " GROUP BY tblBuendel.BunID", con, true);
            queryThreads.add(queryThread);
            queryThread.start();
        }
        return queryThreads;
    }

    private static void insertIntoSearchResults(Connection con, int searchID, LinkedHashSet<String> resultids) throws SQLException, InterruptedException {
        SqlQueryThread queryThread;
        int count = resultids.size();
        ArrayList<SqlQueryThread> queryThreads = new ArrayList<SqlQueryThread>();
        StringBuilder bunids = new StringBuilder(10000);
        String[] res = new String[count];
        resultids.toArray(res);
        int i = 0;
        int j = 0;
        while (i < count) {
            if (bunids.length() > 0) {
                bunids.append(", ");
            }
            bunids.append(res[i]);
            StringBuilder copyinto = null;
            if (i < 3) {
                copyinto = SearcherImpl.createInsertStatement(searchID, bunids.toString());
            } else if (j % 350 == 0) {
                copyinto = SearcherImpl.createInsertStatement(searchID, bunids.toString());
            }
            if (copyinto != null && copyinto.length() > 0) {
                queryThread = new SqlQueryThread(copyinto.toString(), con, false);
                queryThreads.add(queryThread);
                queryThread.start();
                bunids.delete(0, bunids.length());
                copyinto.delete(0, copyinto.length());
            }
            ++i;
            ++j;
        }
        if (bunids.length() > 0) {
            StringBuilder copyinto = SearcherImpl.createInsertStatement(searchID, bunids.toString());
            queryThread = new SqlQueryThread(copyinto.toString(), con, false);
            queryThreads.add(queryThread);
            queryThread.start();
        }
        for (SqlQueryThread thread : queryThreads) {
            thread.join(40000L);
            if (!thread.wasError()) continue;
            throw thread.getError();
        }
    }

    private static StringBuilder createInsertStatement(int searchID, String bunids) {
        StringBuilder copyinto = new StringBuilder("INSERT INTO tblSearchresult (SearchID, BunID) SELECT ");
        copyinto.append(searchID);
        copyinto.append(", BunID");
        copyinto.append(" FROM tblBuendel WHERE tblBuendel.BunID IN (");
        copyinto.append(bunids);
        copyinto.append(")");
        return copyinto;
    }

    private static SearchCommand createSearchCommand(int searchWo, SearchCommand textsearchcommand) {
        OrSearchExpression parentExpression = new OrSearchExpression();
        int rest = searchWo;
        if ((rest & 4) == 4 || (rest & 1) == 1) {
            AndSearchExpression reaAndExpression = SearcherImpl.createSearchExpressionWithLeftOperator(textsearchcommand, "reasteptext");
            parentExpression.add((Object)reaAndExpression);
        }
        if ((rest & 2) == 2) {
            AndSearchExpression betreffAndExpression = SearcherImpl.createSearchExpressionWithLeftOperator(textsearchcommand, "subject");
            parentExpression.add((Object)betreffAndExpression);
        }
        SearchCommand command = new SearchCommand((SearchExpression)parentExpression, new HashMap());
        return command;
    }

    @Nonnull
    private static AndSearchExpression createSearchExpressionWithLeftOperator(@Nonnull SearchCommand textsearchcommand, String leftOperand) {
        AndSearchExpression result = new AndSearchExpression();
        block4: for (SearchExpression expr : textsearchcommand.getSearchExpression()) {
            switch (expr.getType()) {
                case Condition: {
                    SearchCondition condition = (SearchCondition)expr;
                    result.add((SearchExpression)new SearchCondition(leftOperand, condition.getOperator(), condition.getRightOperand()));
                    continue block4;
                }
                case Phrase: {
                    PhraseSearchExpression phrase = (PhraseSearchExpression)expr;
                    result.add((SearchExpression)new PhraseSearchExpression(leftOperand, phrase.getPhrase(), phrase.getTokens()));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException(expr.getType().toString());
        }
        return result;
    }

    private static void deleteOldResults(Connection con, int searchID) throws SQLException {
        PreparedStatement deleteStatement = con.prepareStatement(DELETE_SEARCH_RESULT);
        deleteStatement.setInt(1, searchID);
        deleteStatement.execute();
        try {
            deleteStatement.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static SQLException wasTimeoutException(Exception e) {
        Object message = e.getMessage();
        HDLogger.error(e);
        if (message != null && ((String)message).indexOf("Timeout") != -1) {
            message = ServerUtilities.getLangMsg("SearchTimeoutMsg", new Object[0]);
        } else {
            if (message != null && ((String)message).contains("maxClauseCount")) {
                message = ServerUtilities.getLangMsg("SearchClauseCountMsg", new Object[0]);
                SQLException ex = new SQLException((String)message);
                return ex;
            }
            if (message != null && ((String)message).length() > 50) {
                message = ((String)message).substring(0, 50) + " ...";
            }
            message = ServerUtilities.getLangMsg("ErrSearch", new Object[0]) + "\n" + (String)message;
        }
        SQLException ex = new SQLException((String)message);
        ex.initCause(e);
        return ex;
    }
}

