/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.userfunctions;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.html.utils.Base64;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.ProductLogoGenerator;
import com.inet.plugin.image.UserAvatar;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.usersandgroups.api.user.UserAccount;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ReportingImageFunctions
implements UserDefinedFunction {
    public static String toBase64Image(byte[] bytes) {
        if (bytes == null) {
            return Base64.encodeBytes((byte[])ReportingImageFunctions.createEmptyImage());
        }
        return Base64.encodeBytes((byte[])bytes);
    }

    public static byte[] getDesignLogo() {
        return ProductLogoGenerator.getLogo(null, null, (int)80, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)true);
    }

    public static byte[] getUserImage(int userId) {
        UserAccount userAccount = HDUsersAndGroups.getUserAccount(userId);
        byte[] avatar = UserAvatar.getCircleAvatar((GUID)(userAccount == null ? null : userAccount.getID()));
        if (avatar != null) {
            return avatar;
        }
        return ReportingImageFunctions.createEmptyImage();
    }

    public static byte[] getStateImage(Integer state) {
        return ReportingImageFunctions.getImage(0, state == null ? null : state.toString());
    }

    public static byte[] getPriorityImage(Integer priority) {
        return ReportingImageFunctions.getImage(2, priority == null ? null : priority.toString());
    }

    public static byte[] getCategoryImage(String category) {
        return ReportingImageFunctions.getImage(4, category);
    }

    public static byte[] getItilImage(Integer itil) {
        return ReportingImageFunctions.getImage(7, itil == null ? null : itil.toString());
    }

    public static byte[] getClassificationImage(Integer classification) {
        return ReportingImageFunctions.getImage(3, classification == null ? null : classification.toString());
    }

    public static byte[] getResourceImage(Integer resource) {
        return ReportingImageFunctions.getImage(1, resource == null ? null : resource.toString());
    }

    private static byte[] getImage(int typeID, String value) {
        ImagesConnector imagesConnector;
        URL stateImage;
        if (value != null && (stateImage = (imagesConnector = (ImagesConnector)ServerPluginManager.getInstance().getSingleInstance(ImagesConnector.class)).getDataImage(typeID, value, 16)) != null) {
            try {
                return IOFunctions.getFileBuffer((URL)stateImage);
            }
            catch (IOException e) {
                HDLogger.error(e);
            }
        }
        return ReportingImageFunctions.createEmptyImage();
    }

    private static byte[] createEmptyImage() {
        BufferedImage image = new BufferedImage(16, 16, 2);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            HDLogger.error(ioe);
            return new byte[0];
        }
    }
}

