/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server;

import com.inet.helpdesk.plugins.reporting.server.ReportingServerPluginRegistration;
import com.inet.helpdesk.plugins.reporting.server.UserEntry;
import com.inet.helpdesk.plugins.reporting.server.UserRequestData;
import com.inet.helpdesk.plugins.reporting.server.UserResponseData;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.remote.gui.shared.model.SuggestedEntry;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.SuggestedValue;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagActive;
import com.inet.usersandgroups.user.search.SearchTagLocked;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserHandler
extends ServiceMethod<UserRequestData, UserResponseData> {
    public static final String USERACCOUNTTYPE_INACTIVE = "inactive";
    public static final String USERACCOUNTTYPE_LOCKED = "locked";
    private static final int MAX_ENTRIES = 1000;

    public UserResponseData invoke(HttpServletRequest req, HttpServletResponse resp, UserRequestData input) throws ClientMessageException {
        UserManager manager = UserManager.getRecoveryEnabledInstance();
        ArrayList<UserEntry> users = new ArrayList<UserEntry>();
        UserResponseData responseData = new UserResponseData();
        responseData.setResponseNumber(input.getRequestNumber());
        if (input.isTagsOnly()) {
            int maxTags = 13;
            ArrayList<SuggestedEntry> tags = new ArrayList<SuggestedEntry>();
            List suggestedValues = manager.getSearchEngine().getSuggestedValues(input.getSearchTerm().toLowerCase(), maxTags, null);
            suggestedValues.sort(Comparator.naturalOrder());
            for (SuggestedValue value : suggestedValues) {
                tags.add(new SuggestedEntry(value));
                if (value.getType() != SuggestedValue.SuggestedValueType.VALUE || tags.size() < maxTags) continue;
                break;
            }
            responseData.setTags(tags);
        } else {
            HashMap<String, String> accountTypeNames = new HashMap<String, String>();
            ArrayList<String> accountTypes = new ArrayList<String>();
            for (UserAccountType accType : UserAccountType.values()) {
                accountTypes.add(accType.name());
                accountTypeNames.put(accType.name(), accType == UserAccountType.Standard ? accType.getDisplayName() : "");
            }
            accountTypes.add(USERACCOUNTTYPE_LOCKED);
            accountTypeNames.put(USERACCOUNTTYPE_LOCKED, ReportingServerPluginRegistration.CLIENT_MSG.getMsg("promptdialog.userselect.useraccounttype.locked", new Object[0]));
            accountTypes.add(USERACCOUNTTYPE_INACTIVE);
            accountTypeNames.put(USERACCOUNTTYPE_INACTIVE, ReportingServerPluginRegistration.CLIENT_MSG.getMsg("promptdialog.userselect.useraccounttype.inactive", new Object[0]));
            responseData.setAccountTypeNames(accountTypeNames);
            for (String accountType : accountTypes) {
                ArrayList<SearchCondition> additionalExpressions = new ArrayList<SearchCondition>();
                if (USERACCOUNTTYPE_INACTIVE.equals(accountType)) {
                    additionalExpressions.add(new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)String.valueOf(SearchTagActive.valueAsInt((boolean)false))));
                    additionalExpressions.add(new SearchCondition(USERACCOUNTTYPE_LOCKED, SearchCondition.SearchTermOperator.Equals, (Object)SearchTagLocked.valueAsInt((boolean)false)));
                } else if (USERACCOUNTTYPE_LOCKED.equals(accountType)) {
                    additionalExpressions.add(new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)String.valueOf(SearchTagActive.valueAsInt((boolean)false))));
                    additionalExpressions.add(new SearchCondition(USERACCOUNTTYPE_LOCKED, SearchCondition.SearchTermOperator.Equals, (Object)SearchTagLocked.valueAsInt((boolean)true)));
                } else {
                    additionalExpressions.add(new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)String.valueOf(SearchTagActive.valueAsInt((boolean)true))));
                    additionalExpressions.add(new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Equals, (Object)accountType));
                }
                SearchID searchID = new SearchID((Object)(this.getMethodName() + "_" + String.valueOf(req.getSession().getId() + (input.getSearchID() != null ? input.getSearchID() : ""))));
                SearchResult searchResult = manager.search(input.getSearchTerm(), additionalExpressions, new ArrayList(), 2000, searchID);
                List entries = searchResult.getEntries();
                for (SearchResultEntry searchResultEntry : entries) {
                    users.add(new UserEntry(((GUID)searchResultEntry.getId()).toString(), searchResultEntry.getFirstResultLine(), searchResultEntry.getSecondResultLine(), HDUsersAndGroups.getUserID((GUID)searchResultEntry.getId()), accountType));
                    if (users.size() <= 1000) continue;
                    break;
                }
                if (users.size() <= 1000) continue;
                break;
            }
            if (users.size() > 1000) {
                responseData.setHasMore(true);
                users.remove(1000);
            }
            responseData.setUsers(users);
        }
        return responseData;
    }

    public String getMethodName() {
        return "helpdeskreporting_userhandler";
    }

    public short getMethodType() {
        return 1;
    }
}

