/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailProtocol;
import com.inet.helpdesk.core.utils.AttachedFile;
import com.inet.helpdesk.core.utils.MailAttachmentUtilities;
import com.inet.helpdesk.core.utils.MailEncodingUtilities;
import com.inet.helpdesk.core.utils.PartHandler;
import com.inet.helpdesk.mail.reader.EmailReader_HDProcessing;
import com.inet.helpdesk.mail.reader.MailType;
import com.inet.helpdesk.mail.reader.RawReadMailData;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import srv.mail.BlackListHandler;
import srv.mail.Mail;
import srv.mail.MailFileMethods;
import srv.mail.MessagePartsChecker;
import srv.mail.TicketIdIdentifier;

public class EmailReader_RawReader {
    public static final String FROM = "From";
    public static final String CC = "Cc";
    public static final String TO = "To";
    private static final int CRITICAL_HTML_SIZE = 750000;
    private static final int CRITICAL_PLAINTEXT_SIZE = 25000;
    private MailFileMethods mailFileMethods;
    private boolean connectionCut;

    public EmailReader_RawReader(MailFileMethods mailFileMethods) {
        this.mailFileMethods = mailFileMethods;
    }

    public RawReadMailData readRawMailData(Message msg, EmailAccount emailAccount) {
        this.connectionCut = false;
        RawReadMailData result = new RawReadMailData();
        try {
            InternetAddress address;
            Address[] froms = null;
            String senderMail = null;
            String senderName = null;
            try {
                froms = msg.getFrom();
            }
            catch (MessageRemovedException mre) {
                EmailReader_HDProcessing.LOGGER.error((Object)mre);
            }
            if (froms != null && froms.length > 0 && (senderMail = (address = ((InternetAddress[])froms)[0]).getAddress()) != null) {
                if (senderMail.indexOf(61) > -1) {
                    senderMail = senderMail.substring(senderMail.lastIndexOf(61) + 1);
                }
                if (senderMail.length() > 99) {
                    senderMail = senderMail.substring(0, 99);
                }
                if ((senderName = address.getPersonal()) == null) {
                    senderName = senderMail;
                }
            }
            result.setSenderMail(senderMail);
            result.setSenderName(senderName);
            result.setReceiverMail(Mail.getAddressString(msg.getRecipients(Message.RecipientType.TO)));
            result.setReceiverCCMail(Mail.getAddressString(msg.getRecipients(Message.RecipientType.CC)));
            if (this.connectionCut) {
                throw new CancellationException();
            }
        }
        catch (Exception er2) {
            EmailReader_HDProcessing.LOGGER.error((Object)er2);
            if (this.connectionCut) {
                throw new CancellationException();
            }
            try {
                String[] from = EmailReader_RawReader.getAddressFromHeader(msg, FROM);
                result.setSenderMail(from[0]);
                result.setSenderName(from[1]);
                result.setReceiverMail(EmailReader_RawReader.getAddressFromHeader(msg, TO)[0]);
                result.setReceiverCCMail(EmailReader_RawReader.getAddressFromHeader(msg, CC)[0]);
            }
            catch (Exception innerException) {
                EmailReader_HDProcessing.LOGGER.error((Object)innerException);
            }
        }
        try {
            ArrayList<PartHandler> parts = new ArrayList<PartHandler>();
            MailAttachmentUtilities.fetchParts((Part)msg, parts, false);
            MessagePartsChecker partChecker = new MessagePartsChecker(this.mailFileMethods, EmailReader_HDProcessing.EMAILSLANGRESS, EmailReader_HDProcessing.IGNORE_MAP, 25000, 750000);
            String[] mailData = new String[1];
            MessagePartsChecker.CheckPartsResult checkPartResult = partChecker.checkParts(parts, mailData, result.getAttachments(), emailAccount.getProtocol() != EmailProtocol.POP3, TicketIdIdentifier.idsString[0]);
            result.setContent(mailData[0]);
            result.setMailType(MailType.of(checkPartResult.getMailType()));
            result.setAcknowledgeString(checkPartResult.getAcknowledge());
            result.setPossibleTicketIdFromAttachment(checkPartResult.getPossibleId());
            result.setErrorInAttachments(checkPartResult.isErrorInAttachment());
            result.setSubject(MailEncodingUtilities.tryEncoding(msg.getSubject(), true, false));
        }
        catch (Exception er2) {
            result.setMailType(MailType.TEXT);
            if (this.connectionCut) {
                throw new CancellationException();
            }
            EmailReader_HDProcessing.LOGGER.error((Object)er2);
            result.setAcknowledgeString("Error: " + er2);
            AttachedFile anlage = new AttachedFile(MailAttachmentUtilities.getFileName("Message", ".mim", result.getAttachments()));
            anlage.setFile(this.mailFileMethods.getFile(anlage.getFileName()));
            if (result.getContent() == null) {
                result.setContent(this.mailFileMethods.writeToFile(anlage.getFile(), msg, true));
            } else {
                this.mailFileMethods.writeToFile(anlage.getFile(), msg, false);
            }
            result.getAttachments().add(anlage);
        }
        if (this.connectionCut) {
            throw new CancellationException();
        }
        if (result.getContent() == null) {
            result.setContent("");
        }
        try {
            result.setReceiveDate(msg.getReceivedDate().getTime());
        }
        catch (Exception ex) {
            result.setReceiveDate(System.currentTimeMillis());
        }
        EmailReader_RawReader.readValuesFromHeader(result, (Part)msg);
        return result;
    }

    private static String[] getAddressFromHeader(Message msg, String headerName) throws MessagingException {
        String[] headerArray = msg.getHeader(headerName);
        String[] retVal = new String[]{null, null};
        if (headerArray == null) {
            EmailReader_HDProcessing.LOGGER.debug((Object)("No result for: getHeader(\"" + headerName + "\")"));
        } else {
            EmailReader_HDProcessing.LOGGER.debug((Object)("Header \"" + headerName + "\" lines: " + headerArray.length));
            for (int i = 0; i < headerArray.length; ++i) {
                String headerLine = headerArray[i];
                EmailReader_HDProcessing.LOGGER.debug((Object)(i + 1 + ". Header: -" + headerLine + "-"));
                if (headerLine.indexOf(60) > -1 && headerLine.indexOf(62) > headerLine.indexOf(60)) {
                    retVal[0] = headerLine.substring(headerLine.indexOf(60) + 1, headerLine.indexOf(62));
                    int perso = headerLine.indexOf(34);
                    if (perso > -1 && headerLine.indexOf(34, perso + 2) > -1) {
                        retVal[1] = headerLine.substring(perso + 1, headerLine.indexOf(34, perso + 2));
                        continue;
                    }
                    if (retVal[0].indexOf(64) > -1) {
                        retVal[1] = retVal[0].substring(0, retVal[0].indexOf(64));
                        continue;
                    }
                    retVal[1] = retVal[0];
                    continue;
                }
                if (headerLine.indexOf(34) != -1 || headerLine.indexOf(64) <= -1) continue;
                retVal[0] = headerLine.trim();
                retVal[1] = retVal[0].indexOf(64) > -1 ? retVal[0].substring(0, retVal[0].indexOf(64)) : retVal[0];
            }
        }
        return retVal;
    }

    public void abortReading() {
        this.connectionCut = true;
    }

    private static void readValuesFromHeader(RawReadMailData result, Part part) {
        Map<String, String> headerMap = result.getHeaderValues();
        try {
            EmailReader_HDProcessing.LOGGER.debug((Object)("PART: " + part.getClass().getName()));
            Enumeration allHeaders = part.getAllHeaders();
            while (allHeaders.hasMoreElements()) {
                Header header = (Header)allHeaders.nextElement();
                if (header == null) continue;
                EmailReader_HDProcessing.LOGGER.debug((Object)("HEADER: -" + header.getName() + "-" + header.getValue()));
                if ("X-Mailer".equalsIgnoreCase(header.getName())) {
                    headerMap.put("X-Mailer", header.getValue());
                    if (!"i-net HelpDesk".equals(header.getValue())) continue;
                    result.setResponseType(BlackListHandler.ResponseType.SUPPRESS_ANSWER);
                    continue;
                }
                if ("X-SendIdent".equalsIgnoreCase(header.getName())) {
                    headerMap.put("foreign key", header.getValue());
                    continue;
                }
                if ("X-SendReference".equalsIgnoreCase(header.getName())) {
                    headerMap.put("local key", header.getValue());
                    continue;
                }
                headerMap.put("#" + header.getName().toLowerCase(), header.getValue());
            }
        }
        catch (Exception ex) {
            EmailReader_HDProcessing.LOGGER.error((Object)ex);
        }
    }
}

