/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.valueprovider;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.List;

public class CombinedValueProvider
implements ServerValuesConnector.ValueProvider {
    private List<ServerValuesConnector.ValueProvider> providers = new ArrayList<ServerValuesConnector.ValueProvider>();
    private String fieldKey;

    public CombinedValueProvider(ServerValuesConnector.ValueProvider provider) {
        this.providers.add(provider);
        this.fieldKey = provider.getFieldKey();
    }

    public void addProvider(ServerValuesConnector.ValueProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public String getFieldKey() {
        return this.fieldKey;
    }

    @Override
    public void notifyRegisteredId(int yourId) {
        for (ServerValuesConnector.ValueProvider p : this.providers) {
            p.notifyRegisteredId(yourId);
        }
    }

    @Override
    public ArrayList<Entry> getData(UserAccount account, boolean emptyValue) throws ServerDataException {
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (ServerValuesConnector.ValueProvider p : this.providers) {
            ArrayList<Entry> data = p.getData(account, emptyValue);
            if (data == null) continue;
            emptyValue = false;
            result.addAll(data);
        }
        return result;
    }

    @Override
    public boolean allowMultipleValues() {
        for (ServerValuesConnector.ValueProvider p : this.providers) {
            if (!p.allowMultipleValues()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowCustomValues() {
        for (ServerValuesConnector.ValueProvider p : this.providers) {
            if (!p.allowCustomValues() || this.allowMultipleValues()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasData(UserAccount account) throws ServerDataException {
        for (ServerValuesConnector.ValueProvider p : this.providers) {
            if (!p.hasData(account)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Entry getDefaultValue(UserAccount account) throws ServerDataException {
        for (ServerValuesConnector.ValueProvider p : this.providers) {
            Entry defaultValue = p.getDefaultValue(account);
            if (defaultValue == null) continue;
            return defaultValue;
        }
        return null;
    }
}

