/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.itil;

import com.inet.error.ErrorCode;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.data.itil.ItilLinkCache;
import com.inet.plugin.ServerPluginManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import srv.ServerUtilities;
import srv.mail.Mail;

public class ItilLinkManagerImpl
implements ItilLinkManager,
ConnectionCreationListener {
    private static final String SELECT_ITIL_LINK = "Select * From tblItilLinks Where SlaveAufID = ?";
    private static final String UPDATE_ITIL_MASTERCOUNT = "Update tblAuftraege Set ItiCount = (Select count(*) From tblItilLinks Where MasterAufID = ?) Where AufID = ?";
    private static final String UPDATE_ITIL_COUNT = "Update tblAuftraege Set ItiCount = ? Where AufID = ?";
    private final CopyOnWriteArrayList<ItilLinkManager.ItilLinkChangeListener> listeners = new CopyOnWriteArrayList();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private ItilLinkCache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionCreated() {
        try {
            this.writeLock.lock();
            this.cache = new ItilLinkCache();
            try (Connection con = this.getConnection();
                 Statement stm = con.createStatement();
                 ResultSet rs = stm.executeQuery("Select * From tblItilLinks");){
                while (rs.next()) {
                    int masterID = rs.getInt("MasterAufID");
                    int slaveID = rs.getInt("SlaveAufID");
                    this.cache.addLink(masterID, slaveID);
                }
            }
            catch (SQLException ex) {
                HDLogger.fatal(ex);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void registerListener(ItilLinkManager.ItilLinkChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregisterListener(ItilLinkManager.ItilLinkChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(Map<Integer, Integer> changedTicketLinkCountDiff) {
        HashMap<Integer, ItilLinkManager.ItilCountChange> changedItils = new HashMap<Integer, ItilLinkManager.ItilCountChange>();
        for (Map.Entry<Integer, Integer> en : changedTicketLinkCountDiff.entrySet()) {
            if (en.getValue() == 0) continue;
            Integer ticketId = en.getKey();
            int newCount = this.getItilLinkCount(ticketId);
            int oldCount = newCount - en.getValue();
            changedItils.put(ticketId, new ItilLinkManager.ItilCountChange(oldCount, newCount));
        }
        ItilLinkManager.ItilLinkChangeEvent event = new ItilLinkManager.ItilLinkChangeEvent(changedItils);
        for (ItilLinkManager.ItilLinkChangeListener l : this.listeners) {
            try {
                l.dataChanged(event);
            }
            catch (Throwable t) {
                HDLogger.error(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int linkItilSlavesToItilMaster(int itilMasterID, @Nonnull Set<Integer> itilSlaveIDs, @Nonnull String producerEmail) {
        int retVal = 0;
        boolean changes = false;
        HashMap<Integer, Integer> changedTicketLinkCountDiff = new HashMap<Integer, Integer>();
        try {
            this.writeLock.lock();
            try (Connection con = this.getConnection();
                 PreparedStatement pstmSelect = con.prepareStatement(SELECT_ITIL_LINK, 1005, 1008);
                 PreparedStatement pstmUpdateMasterCount = con.prepareStatement(UPDATE_ITIL_MASTERCOUNT);
                 PreparedStatement pstmUpdateSlaveCount = con.prepareStatement(UPDATE_ITIL_COUNT);){
                for (int slaveID : itilSlaveIDs) {
                    pstmSelect.setInt(1, slaveID);
                    ResultSet rs = pstmSelect.executeQuery();
                    try {
                        boolean alreadyLinkedToMaster = rs.next();
                        if (alreadyLinkedToMaster) {
                            int previousMasterID = rs.getInt("MasterAufID");
                            if (previousMasterID == itilMasterID) continue;
                            rs.updateInt("MasterAufID", itilMasterID);
                            rs.updateRow();
                            this.updateItilLinkCount(pstmUpdateMasterCount, previousMasterID, previousMasterID);
                            this.storeItilCountDiff(previousMasterID, -1, changedTicketLinkCountDiff);
                            this.storeItilCountDiff(itilMasterID, 1, changedTicketLinkCountDiff);
                            this.cache.removeLink(previousMasterID, slaveID);
                            this.cache.addLink(itilMasterID, slaveID);
                            retVal = Math.max(retVal, ServerUtilities.getOpenOrderController().changeBuendelVersion(previousMasterID));
                            changes = true;
                            continue;
                        }
                        rs.moveToInsertRow();
                        rs.updateInt("MasterAufID", itilMasterID);
                        rs.updateInt("SlaveAufID", slaveID);
                        rs.insertRow();
                        this.updateItilLinkCount(pstmUpdateSlaveCount, 1, slaveID);
                        this.storeItilCountDiff(itilMasterID, 1, changedTicketLinkCountDiff);
                        this.storeItilCountDiff(slaveID, 1, changedTicketLinkCountDiff);
                        this.cache.addLink(itilMasterID, slaveID);
                        retVal = Math.max(retVal, ServerUtilities.getOpenOrderController().changeBuendelVersion(slaveID));
                        changes = true;
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                if (changes) {
                    this.updateItilLinkCount(pstmUpdateMasterCount, itilMasterID, itilMasterID);
                    retVal = Math.max(retVal, ServerUtilities.getOpenOrderController().changeBuendelVersion(itilMasterID));
                    try {
                        Hashtable<String, String> ht = new Hashtable<String, String>();
                        ht.put("aufid", String.valueOf(itilMasterID));
                        Mail.send(ht, 15, producerEmail);
                    }
                    catch (Exception ex) {
                        HDLogger.error(ex);
                    }
                }
            }
            catch (SQLException ex) {
                throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (retVal > 0) {
            ServerUtilities.getOpenOrderController().realizeAllChanges();
        }
        if (changes) {
            this.notifyListeners(changedTicketLinkCountDiff);
        }
        return retVal;
    }

    private void storeItilCountDiff(int ticketId, int diffChange, Map<Integer, Integer> changedTicketLinkCountDiff) {
        Integer diff = changedTicketLinkCountDiff.get(ticketId);
        if (diff == null) {
            diff = 0;
        }
        diff = diff + diffChange;
        changedTicketLinkCountDiff.put(ticketId, diff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeLinkFromItilSlaveToItilMaster(int itilSlaveID) {
        int retVal = 0;
        boolean changes = false;
        HashMap<Integer, Integer> changedTicketLinkCountDiff = new HashMap<Integer, Integer>();
        try {
            this.writeLock.lock();
            try (Connection con = this.getConnection();
                 PreparedStatement pstmSelect = con.prepareStatement(SELECT_ITIL_LINK, 1005, 1008);
                 PreparedStatement pstmUpdateMasterCount = con.prepareStatement(UPDATE_ITIL_MASTERCOUNT);
                 PreparedStatement pstmUpdateSlaveCount = con.prepareStatement(UPDATE_ITIL_COUNT);){
                pstmSelect.setInt(1, itilSlaveID);
                try (ResultSet rs = pstmSelect.executeQuery();){
                    if (rs.next()) {
                        int itilMasterID = rs.getInt("MasterAufID");
                        rs.deleteRow();
                        this.updateItilLinkCount(pstmUpdateMasterCount, itilMasterID, itilMasterID);
                        this.updateItilLinkCount(pstmUpdateSlaveCount, 0, itilSlaveID);
                        this.storeItilCountDiff(itilMasterID, -1, changedTicketLinkCountDiff);
                        this.storeItilCountDiff(itilSlaveID, -1, changedTicketLinkCountDiff);
                        this.cache.removeLink(itilMasterID, itilSlaveID);
                        retVal = Math.max(retVal, ServerUtilities.getOpenOrderController().changeBuendelVersion(itilMasterID));
                        retVal = Math.max(retVal, ServerUtilities.getOpenOrderController().changeBuendelVersion(itilSlaveID));
                        changes = true;
                    }
                }
            }
            catch (SQLException ex) {
                throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (retVal > 0) {
            ServerUtilities.getOpenOrderController().realizeAllChanges();
        }
        if (changes) {
            this.notifyListeners(changedTicketLinkCountDiff);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAllLinksToItilMaster(int itilMasterID) {
        int retVal = 0;
        boolean changes = false;
        HashMap<Integer, Integer> changedTicketLinkCountDiff = new HashMap<Integer, Integer>();
        try {
            this.writeLock.lock();
            try (Connection con = this.getConnection();
                 PreparedStatement pstmSelect = con.prepareStatement("Select * From tblItilLinks Where MasterAufID = ?", 1005, 1008);
                 PreparedStatement pstmUpdateCount = con.prepareStatement(UPDATE_ITIL_COUNT);){
                pstmSelect.setInt(1, itilMasterID);
                try (ResultSet rs = pstmSelect.executeQuery();){
                    while (rs.next()) {
                        int itilSlaveID = rs.getInt("SlaveAufID");
                        rs.deleteRow();
                        this.updateItilLinkCount(pstmUpdateCount, 0, itilSlaveID);
                        this.storeItilCountDiff(itilSlaveID, -1, changedTicketLinkCountDiff);
                        this.storeItilCountDiff(itilMasterID, -1, changedTicketLinkCountDiff);
                        this.cache.removeLink(itilMasterID, itilSlaveID);
                        retVal = Math.max(retVal, ServerUtilities.getOpenOrderController().changeBuendelVersion(itilSlaveID));
                        changes = true;
                    }
                    if (changes) {
                        this.updateItilLinkCount(pstmUpdateCount, 0, itilMasterID);
                        retVal = Math.max(retVal, ServerUtilities.getOpenOrderController().changeBuendelVersion(itilMasterID));
                    }
                }
            }
            catch (SQLException ex) {
                throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (retVal > 0) {
            ServerUtilities.getOpenOrderController().realizeAllChanges();
        }
        if (changes) {
            this.notifyListeners(changedTicketLinkCountDiff);
        }
        return retVal;
    }

    @Override
    public int getItilLinkCount(int ticketID) {
        try {
            this.readLock.lock();
            int n = this.cache.getItilLinkCount(ticketID);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Integer> getItilMastersLinkedToSlaves() {
        try {
            this.readLock.lock();
            Set<Integer> set = this.cache.getItilMastersLinkedToSlaves();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Integer> getItilSlavesLinkedTo(int itilMasterID) {
        try {
            this.readLock.lock();
            Set<Integer> set = this.cache.getItilSlavesLinkedTo(itilMasterID);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updateItilLinkCount(PreparedStatement pstm, int firstParam, int secondParam) throws SQLException {
        pstm.setInt(1, firstParam);
        pstm.setInt(2, secondParam);
        pstm.executeUpdate();
    }

    private Connection getConnection() throws SQLException {
        ConnectionFactory conFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        return conFactory.getConnection();
    }
}

