/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.data.UserAccessFilter;
import com.inet.helpdesk.data.UserSearchResponseCreator;
import com.inet.helpdesk.data.userfilter.UserFilterCombined;
import com.inet.helpdesk.search.user.SearchResultsBooster;
import com.inet.helpdesk.shared.search.rpc.UserListEntry;
import com.inet.helpdesk.shared.search.rpc.UserListEntry2;
import com.inet.helpdesk.shared.search.rpc.UserListFilterCondition;
import com.inet.helpdesk.shared.search.rpc.UserSearchResponse;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchResult;
import com.inet.search.SuggestedValue;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class UserSearchController {
    private UserSearchResponseCreator userSearchResponseCreator = new UserSearchResponseCreator(accountID -> UserManager.getInstance().getUserAccount(accountID));

    UserSearchController() {
    }

    UserSearchResponse runSearch(String searchPhrase, List<UserListFilterCondition> boostingConditions, boolean requestEmailAddresses, int maxResults, UserAccessFilter userAccessFilter, SearchID searchID) throws ServerDataException {
        SearchCondition condition;
        SearchResultsBooster booster = this.createSearchResultsBooster(boostingConditions);
        ArrayList<SearchCondition> additionalExpressions = new ArrayList<SearchCondition>();
        if (userAccessFilter != null && (condition = userAccessFilter.createSearchConditionThatLimitsResultsToUserLocation()) != null) {
            additionalExpressions.add(condition);
        }
        SearchResult searchResult = UserManager.getInstance().search(searchPhrase, additionalExpressions, Collections.emptyList(), 10000, searchID);
        return this.userSearchResponseCreator.prepareResultOfTheRequest((SearchResult<GUID>)searchResult, booster, requestEmailAddresses, maxResults);
    }

    private SearchResultsBooster createSearchResultsBooster(List<UserListFilterCondition> boostingConditions) throws ServerDataException {
        UserFilterCombined boostFilter = null;
        if (boostingConditions != null) {
            boostFilter = boostingConditions.size() > 0 ? new UserFilterCombined(boostingConditions) : null;
        }
        return new SearchResultsBooster(boostFilter);
    }

    List<UserListEntry2> generateSuggestedTags(String phrase) {
        if (StringFunctions.isEmpty((String)phrase) || phrase.endsWith(" ")) {
            return Collections.emptyList();
        }
        return UserManager.getInstance().getSearchEngine().getSuggestedValues(phrase, 0, null).stream().filter(value -> value.getType() == SuggestedValue.SuggestedValueType.FIELD).map(tag -> new UserListEntry2(null, "", tag.getDisplayName() + ":", tag.getDisplayName(), UserListEntry.UserListEntryType.Tag)).collect(Collectors.toList());
    }
}

