/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.UserDataConnector;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.data.ServerDataConnectorImpl;
import com.inet.helpdesk.data.UserAccessFilter;
import com.inet.helpdesk.data.UserSearchController;
import com.inet.helpdesk.shared.search.rpc.UserListEntry;
import com.inet.helpdesk.shared.search.rpc.UserListEntry2;
import com.inet.helpdesk.shared.search.rpc.UserListFilterCondition;
import com.inet.helpdesk.shared.search.rpc.UserSearchResponse;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpSession;

public class UserDataConnectorImpl
implements UserDataConnector {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", UserDataConnectorImpl.class);
    private static final String SQL_SELECT_GROUPS_WHERE_SUPERVISOR = "SELECT BgrID FROM tblBGSuperUser WHERE UsrID = ?";
    private final ConnectionFactory connectionFactory;
    private static final ConfigValue<Integer> USER_ACCESS_FILTER = new ConfigValue(HDConfigKeys.USER_ACCESS_FILTER);
    private UserSearchController userSearchController;

    public UserDataConnectorImpl(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected UserSearchController createUserSearchController() {
        return new UserSearchController();
    }

    private synchronized UserSearchController getUserSearchController() {
        if (this.userSearchController == null) {
            this.userSearchController = this.createUserSearchController();
        }
        return this.userSearchController;
    }

    public synchronized void initUserSearchController() {
        this.getUserSearchController();
    }

    @Override
    public UserSearchResponse getUserSearchResultForMobileClient(String request, String sortLanguage) throws ServerDataException {
        UserAccount supporterUserAccount = UserManager.getInstance().getCurrentUserAccount();
        HttpSession session = SessionStore.getHttpSession();
        return this.getUserSearchResult(supporterUserAccount, request, 0, true, new ArrayList<UserListFilterCondition>(), false, session == null ? null : new SearchID((Object)session.getId()));
    }

    private int getUserAccessFilter(@Nonnull UserAccount supporterAccount) {
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)supporterAccount, (Permission[])new Permission[]{HdPermissions.DISPATCHER, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER}) && HDUsersAndGroups.isResourceMember(supporterAccount)) {
            return (Integer)USER_ACCESS_FILTER.get();
        }
        return 0;
    }

    @Override
    public UserSearchResponse getUserSearchResult(UserAccount supporterUserAccount, String request, int maxResults, String sortLanguage, List<UserListFilterCondition> boostingConditions, boolean requestEmailAddresses, SearchID searchID) throws ServerDataException {
        return this.getUserSearchResult(supporterUserAccount, request, maxResults, false, boostingConditions, requestEmailAddresses, searchID);
    }

    private UserSearchResponse getUserSearchResult(UserAccount supporterAccount, String request, int maxResults, boolean mobile, List<UserListFilterCondition> boostingConditions, boolean requestEmailAddresses, SearchID searchID) throws ServerDataException {
        if (request == null) {
            request = "";
        }
        if (requestEmailAddresses) {
            request = "hasemail:1 " + (String)request;
        }
        int userAccessFilter = this.getUserAccessFilter(supporterAccount);
        UserAccessFilter uaf = UserAccessFilter.createIfRequired(userAccessFilter, supporterAccount);
        UserSearchResponse searchResponse = this.getUserSearchController().runSearch((String)request, boostingConditions, requestEmailAddresses, maxResults, uaf, searchID);
        ArrayList<UserListEntry2> searchResult = searchResponse.getResult();
        this.removeUsersNotInAllowedGroupsIfRequired(userAccessFilter, supporterAccount, searchResult);
        if (!mobile) {
            if (!((String)request).isEmpty()) {
                searchResult.addAll(0, this.getUserSearchController().generateSuggestedTags((String)request));
            }
            return new UserSearchResponse(searchResult, searchResponse.isPartialResult());
        }
        ArrayList<UserListEntry2> result = new ArrayList<UserListEntry2>();
        UserManager userManager = UserManager.getInstance();
        for (UserListEntry2 entry : searchResult) {
            int userID;
            try {
                userID = Integer.parseInt(entry.getIdName());
            }
            catch (NumberFormatException ex) {
                continue;
            }
            GUID accountID = HDUsersAndGroups.getUserAccount(userID).getID();
            UserAccount hduser = userManager.getUserAccount(accountID);
            if (hduser == null || !hduser.isActive()) continue;
            String userName = hduser.getDisplayName();
            String displayText = hduser.getDisplayName();
            String detailDisplayText = (String)hduser.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
            if (detailDisplayText == null) {
                detailDisplayText = userName;
            }
            UserListEntry2 e = new UserListEntry2(entry.getIdName(), "", displayText, detailDisplayText, UserListEntry.UserListEntryType.User);
            result.add(e);
        }
        return new UserSearchResponse(result, searchResponse.isPartialResult());
    }

    private void removeUsersNotInAllowedGroupsIfRequired(int userAccessFilter, UserAccount currentUserAccount, ArrayList<UserListEntry2> search) throws ServerDataException {
        if (userAccessFilter != 2) {
            return;
        }
        ArrayList<Integer> allowedGroups = new ArrayList<Integer>();
        Integer groupId = (Integer)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_GROUP_ID);
        if (groupId == null) {
            groupId = (Integer)HDUsersAndGroups.FIELD_GROUP_ID.getDefaultValue();
        }
        int usrID = HDUsersAndGroups.getUserID(currentUserAccount);
        allowedGroups.add(groupId);
        Connection con = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            con = this.connectionFactory.getConnection();
            pst = con.prepareStatement(SQL_SELECT_GROUPS_WHERE_SUPERVISOR);
            pst.setInt(1, usrID);
            rs = pst.executeQuery();
            while (rs.next()) {
                int bgrID = rs.getInt(1);
                allowedGroups.add(bgrID);
            }
        }
        catch (Exception ex) {
            try {
                throw new ServerDataException(ex);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, pst, rs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, pst, rs);
        Iterator<UserListEntry2> it = search.iterator();
        while (it.hasNext()) {
            UserListEntry2 entry = it.next();
            try {
                Integer groupID;
                Integer userID = Integer.valueOf(entry.getIdName());
                UserAccount userAccount = HDUsersAndGroups.getUserAccount(userID);
                if (userAccount == null || !userAccount.isActive() || allowedGroups.contains(groupID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_GROUP_ID))) continue;
                it.remove();
            }
            catch (NumberFormatException exc) {
                HDLogger.debug("unknown user id during search: " + exc.getMessage());
            }
        }
    }

    public static String getFieldValueAsString(Object data) {
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof String[]) {
            return String.join((CharSequence)"; ", (String[])data);
        }
        return null;
    }

    public static void checkEmailReceivers(String emailaddresses) throws AddressException {
        String[] mails = emailaddresses.split(";");
        if (mails != null && mails.length > 0) {
            for (String mail : mails) {
                if ((mail = mail.trim()).length() <= 0) continue;
                try {
                    new InternetAddress(mail, true);
                    int index = mail.indexOf(64);
                    if (index > 0) {
                        if ((index = mail.indexOf(46, index)) != -1) continue;
                        throw new AddressException(mail);
                    }
                    throw new AddressException(mail);
                }
                catch (AddressException ae) {
                    throw new AddressException(mail);
                }
            }
        }
    }
}

