/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TranslationTextConnectorImpl
implements TranslationTextConnector {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final ConnectionFactory connectionFactory;
    private final MemoryStoreMap<CacheEntryKey, Map<String, String>> cache;

    public TranslationTextConnectorImpl(ConnectionFactory connectionFactory) {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connection factory must not be null");
        }
        this.connectionFactory = connectionFactory;
        this.cache = new MemoryStoreMap();
        this.cache.setTimeout(900, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTranslationTexts(String pluginID, String textKey, Map<String, String> texts) throws SQLException {
        try {
            this.writeLock.lock();
            DatabaseTransactionUtils.executeAsTransaction(this.connectionFactory, con -> {
                int translationID = this.getTranslationID(con, pluginID, textKey);
                if (translationID < 0) {
                    translationID = this.createTranslation(con, pluginID, textKey);
                } else {
                    this.deleteAllTextsReferencedByTranslation(con, translationID);
                }
                this.insertTranslationTexts(con, translationID, texts);
                return null;
            });
            this.cache.put((Object)CacheEntryKey.of(pluginID, textKey), new HashMap<String, String>(texts));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTranslationText(String pluginID, String textKey, String lang, String value) throws SQLException {
        try {
            this.writeLock.lock();
            DatabaseTransactionUtils.executeAsTransaction(this.connectionFactory, con -> {
                int translationID = this.getTranslationID(con, pluginID, textKey);
                if (translationID < 0) {
                    translationID = this.createTranslation(con, pluginID, textKey);
                } else {
                    this.deleteTranslationText(con, translationID, lang);
                }
                HashMap<String, String> texts = new HashMap<String, String>();
                texts.put(lang, value);
                this.insertTranslationTexts(con, translationID, texts);
                return null;
            });
            CacheEntryKey cacheKey = CacheEntryKey.of(pluginID, textKey);
            HashMap<String, String> map = (HashMap<String, String>)this.cache.get((Object)cacheKey);
            if (map == null) {
                map = new HashMap<String, String>();
                map.put(lang, value);
                this.cache.put((Object)cacheKey, map);
            } else {
                map.put(lang, value);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getTranslationText(String pluginID, String textKey, String languageID) throws SQLException {
        return this.getTranslationTexts(pluginID, textKey).get(languageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getTranslationTexts(String pluginID, String textKey) throws SQLException {
        try {
            this.readLock.lock();
            CacheEntryKey cacheEntryKey = CacheEntryKey.of(pluginID, textKey);
            Map cacheEntry = (Map)this.cache.get((Object)cacheEntryKey);
            if (cacheEntry != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>(cacheEntry);
                return hashMap;
            }
            String sql = "SELECT LanguageID,Text FROM tblTranslationTexts WHERE TranslationID = (SELECT TranslationID FROM tblTranslations WHERE PluginID = ? AND TextKey = ?)";
            HashMap<String, String> texts = new HashMap<String, String>();
            if (!this.connectionFactory.isHelpDeskDatabaseConnectionValid()) {
                throw new SQLException("No valid Connection");
            }
            try (Connection con = this.connectionFactory.getConnection();
                 PreparedStatement pstm = con.prepareStatement(sql);){
                pstm.setString(1, pluginID);
                pstm.setString(2, textKey);
                try (ResultSet rs = pstm.executeQuery();){
                    while (rs.next()) {
                        String languageID = rs.getString(1);
                        String text = rs.getString(2);
                        texts.put(languageID, text);
                    }
                }
            }
            this.cache.put((Object)cacheEntryKey, texts);
            HashMap<String, String> hashMap = new HashMap<String, String>(texts);
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void deleteTranslationTexts(String pluginID, String textKey) throws SQLException {
        try {
            this.writeLock.lock();
            this.cache.remove((Object)CacheEntryKey.of(pluginID, textKey));
            DatabaseTransactionUtils.executeAsTransaction(this.connectionFactory, con -> {
                int translationID = this.getTranslationID(con, pluginID, textKey);
                if (translationID >= 0) {
                    this.deleteAllTextsReferencedByTranslation(con, translationID);
                    this.deleteTranslation(con, translationID);
                }
                return null;
            });
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private int getTranslationID(Connection con, String pluginID, String textKey) throws SQLException {
        String sql = "SELECT TranslationID FROM tblTranslations WHERE PluginID = ? AND TextKey = ?";
        try (PreparedStatement pstm = con.prepareStatement(sql);){
            int n;
            block16: {
                ResultSet rs;
                block14: {
                    int n2;
                    block15: {
                        pstm.setString(1, pluginID);
                        pstm.setString(2, textKey);
                        rs = pstm.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            n2 = rs.getInt(1);
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return n2;
                }
                n = -1;
                if (rs == null) break block16;
                rs.close();
            }
            return n;
        }
    }

    private int createTranslation(Connection con, String pluginID, String textKey) throws SQLException {
        String sql = "SELECT TranslationID,PluginID,TextKey FROM tblTranslations WHERE 1 = 0";
        try (Statement stm = con.createStatement(1005, 1008);){
            int n;
            block12: {
                ResultSet rs = stm.executeQuery(sql);
                try {
                    rs.moveToInsertRow();
                    rs.updateString(2, pluginID);
                    rs.updateString(3, textKey);
                    rs.insertRow();
                    rs.last();
                    n = rs.getInt(1);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
    }

    private void insertTranslationTexts(Connection con, int translationID, Map<String, String> texts) throws SQLException {
        String insertTextSql = "INSERT INTO tblTranslationTexts (TranslationID,LanguageID,Text) VALUES (?,?,?)";
        try (PreparedStatement pstm = con.prepareStatement(insertTextSql);){
            for (Map.Entry<String, String> entry : texts.entrySet()) {
                pstm.setInt(1, translationID);
                pstm.setString(2, entry.getKey());
                pstm.setString(3, entry.getValue());
                pstm.executeUpdate();
            }
        }
    }

    private void deleteAllTextsReferencedByTranslation(Connection con, int translationID) throws SQLException {
        String sql = "DELETE FROM tblTranslationTexts WHERE TranslationID = ?";
        try (PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setInt(1, translationID);
            pstm.executeUpdate();
        }
    }

    private void deleteTranslationText(Connection con, int translationID, String lang) throws SQLException {
        String sql = "DELETE FROM tblTranslationTexts WHERE TranslationID = ? and LanguageID = ?";
        try (PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setInt(1, translationID);
            pstm.setString(2, lang);
            pstm.executeUpdate();
        }
    }

    private void deleteTranslation(Connection con, int translationID) throws SQLException {
        String sql = "DELETE FROM tblTranslations WHERE TranslationID = ?";
        try (PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setInt(1, translationID);
            pstm.executeUpdate();
        }
    }

    @Override
    public List<String> getLanguages() throws SQLException {
        try (Connection conn = this.connectionFactory.getConnection();){
            ArrayList<String> arrayList;
            block13: {
                Statement stm = conn.createStatement();
                try {
                    ResultSet rs = stm.executeQuery("select SprID from tblSprachen");
                    ArrayList<String> langKeys = new ArrayList<String>();
                    while (rs.next()) {
                        langKeys.add(rs.getString(1));
                    }
                    rs.close();
                    arrayList = langKeys;
                    if (stm == null) break block13;
                }
                catch (Throwable throwable) {
                    if (stm != null) {
                        try {
                            stm.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stm.close();
            }
            return arrayList;
        }
    }

    private static class CacheEntryKey {
        private final String pluginID;
        private final String textKey;

        private CacheEntryKey(String pluginID, String textKey) {
            this.pluginID = pluginID;
            this.textKey = textKey;
        }

        public static CacheEntryKey of(String pluginID, String textKey) {
            return new CacheEntryKey(pluginID, textKey);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pluginID == null ? 0 : this.pluginID.hashCode());
            result = 31 * result + (this.textKey == null ? 0 : this.textKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheEntryKey other = (CacheEntryKey)obj;
            if (this.pluginID == null ? other.pluginID != null : !this.pluginID.equals(other.pluginID)) {
                return false;
            }
            return !(this.textKey == null ? other.textKey != null : !this.textKey.equals(other.textKey));
        }
    }
}

