/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.config.RecoveryConfigValue;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.data.ImportedDeviceDeletionListener;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.dataimport.ConnectionEntry;
import com.inet.helpdesk.core.model.dataimport.DataImportSchedule;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.model.inventory.DeviceType;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.utils.SubListTaskExecutor;
import com.inet.helpdesk.data.DataImportRunner;
import com.inet.helpdesk.data.ServerDataConnectorImpl;
import com.inet.helpdesk.shared.model.DataField;
import com.inet.helpdesk.shared.model.Field;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.annotation.SuppressFBWarnings;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import srv.ServerUtilities;
import srv.automatic.GeraeteImporter;
import srv.automatic.LdapUtilities;
import srv.automatic.StringIntHashMap;
import srv.automatic.UserImporter;

public class DataImportConnectorImpl
implements DataImportConnector {
    private static final long JOB_SCHEDULE_INTERVAL_IN_MS = 1800000L;
    private static final RecoveryConfigValue<DeviceImportConfigInfoMap> DEVICE_IMPORT_CONFIG_INFO_MAP = new RecoveryConfigValue(HDConfigKeys.DEVICE_IMPORT_CONFIGS);
    private static final RecoveryConfigValue<UserImportConfigInfoMap> USER_IMPORT_CONFIG_INFO_MAP = new RecoveryConfigValue(HDConfigKeys.USER_IMPORT_CONFIGS);
    private static final ConfigValue<LdapConnectionInfoMap> LDAP_CONNECTION_INFOS = new ConfigValue(HDConfigKeys.LDAP_CONNECTION_INFOS);
    private static final ConfigValue<DatabaseConfigInfoList> DATABASE_CONNECTION_INFOS = new ConfigValue(HDConfigKeys.DB_CONFIGS);
    private static final String SQL_GETUSERIMPORTNAMES = "SELECT DISTINCT ImpName from tblUser";
    private static final String SQL_GETDEVICEIMPORTNAMES = "SELECT DISTINCT ImpName from tblGeraeteBestand";
    private static final String SQL_GETDEVICESFORIMPORTNAME = "SELECT * from tblGeraeteBestand WHERE ImpName=?";
    private static final String SQL_IDS_OF_DEVICES_FOR_IMPORT_NAME = "SELECT GerID from tblGeraeteBestand WHERE ImpName=?";
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", DataImportConnectorImpl.class);
    private DataImportRunner runner = new DataImportRunner();
    private static final Logger logger = LogManager.getLogger((String)"Data Import");

    @Override
    public DeviceImportConfigInfoMap getDeviceImports() {
        return (DeviceImportConfigInfoMap)DEVICE_IMPORT_CONFIG_INFO_MAP.get();
    }

    @Override
    public UserImportConfigInfoMap getUserImports() {
        return (UserImportConfigInfoMap)USER_IMPORT_CONFIG_INFO_MAP.get();
    }

    @Override
    public void saveDeviceImports(DeviceImportConfigInfoMap deviceImports) {
        ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.DEVICE_IMPORT_CONFIGS.getKey(), deviceImports.toString());
    }

    @Override
    public void saveUserImports(UserImportConfigInfoMap userImports) {
        ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.USER_IMPORT_CONFIGS.getKey(), userImports.toString());
    }

    @Override
    public ArrayList<ConnectionEntry> getConnections() {
        ArrayList<ConnectionEntry> entries = new ArrayList<ConnectionEntry>();
        LdapConnectionInfoMap ldapConns = (LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get();
        for (Map.Entry entry : ldapConns.entrySet()) {
            entries.add(new ConnectionEntry(DataImportConnector.ConnectionType.ldap, ((LdapConnectionInfo)entry.getValue()).getName()));
        }
        DatabaseConfigInfoList dbConns = (DatabaseConfigInfoList)DATABASE_CONNECTION_INFOS.get();
        for (DatabaseConfigInfo dbConnection : dbConns) {
            if ("HDS".equals(dbConnection.getDbName())) continue;
            entries.add(new ConnectionEntry(DataImportConnector.ConnectionType.database, dbConnection.getDbName()));
        }
        return entries;
    }

    @Override
    public ArrayList<String> getTables(ConnectionEntry connection) throws ServerDataException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Vector<String> vec = new Vector<String>();
            if (connection.getConnectionType() == DataImportConnector.ConnectionType.ldap) {
                LdapConnectionInfo ldapConnectionInfo = ((LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get()).get(connection.getName());
                if (ldapConnectionInfo == null) {
                    throw new ServerDataException(new Exception(MSG.getMsg("dataImport.noConnectionFound", new Object[]{connection.getName()})));
                }
                DataImportConnectorImpl.getObjectClasses(vec, ldapConnectionInfo);
            } else if (connection.getConnectionType() == DataImportConnector.ConnectionType.database) {
                Connection dbConnection = this.getDatabaseConnection(connection);
                DatabaseConfigInfo databaseConfigInfo = ((DatabaseConfigInfoList)DATABASE_CONNECTION_INFOS.get()).get(connection.getName());
                DataImportConnectorImpl.getTables(dbConnection, databaseConfigInfo, vec);
            }
            for (Object e : vec) {
                list.add(e.toString());
            }
        }
        catch (SQLException | NamingException e) {
            throw new ServerDataException(e);
        }
        return list;
    }

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="Internal API structure")
    public static void getObjectClasses(Vector<String> data, LdapConnectionInfo ldapConnectionInfo) throws NamingException {
        InitialLdapContext ctx = LdapUtilities.getDirContext(ldapConnectionInfo);
        String[] searchContextValues = LdapUtilities.getSearchContext(ctx, ldapConnectionInfo.getSearchContext());
        StringIntHashMap hm = new StringIntHashMap();
        Attributes attrs = null;
        for (String searchContext : searchContextValues) {
            boolean searchSuccess;
            NamingEnumeration<SearchResult> enumeration = ctx.search(searchContext, "objectClass=*", LdapUtilities.getSearchControls(new String[]{"objectClass"}));
            try {
                searchSuccess = enumeration.hasMore();
            }
            catch (NamingException ex) {
                searchSuccess = false;
            }
            while (searchSuccess) {
                SearchResult si = (SearchResult)enumeration.nextElement();
                attrs = si.getAttributes();
                Attribute objKlasse = attrs.get("objectClass");
                if (objKlasse != null) {
                    int attributeCount = objKlasse.size();
                    for (int i = 0; i < attributeCount; ++i) {
                        String attrValue = attrs.get("objectClass").get(i).toString();
                        if (attrValue.equals("top") || attrValue.equals("person")) continue;
                        hm.putCounter(attrValue);
                    }
                }
                try {
                    searchSuccess = enumeration.hasMore();
                }
                catch (NamingException ex) {
                    searchSuccess = false;
                }
            }
            try {
                enumeration.close();
            }
            catch (NamingException e) {
                logger.error((Object)e);
            }
        }
        try {
            ctx.close();
        }
        catch (NamingException e) {
            logger.error((Object)e);
        }
        Vector<String> counterVec = new Vector<String>();
        DataImportConnectorImpl.sortElements(hm, data, counterVec);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Table name is quoted")
    public static void getColumns(Connection conlocal, Vector<String> vec, String tabelle) throws SQLException {
        StringIntHashMap hm = new StringIntHashMap();
        String sql = "Select * From " + conlocal.getMetaData().getIdentifierQuoteString() + tabelle + conlocal.getMetaData().getIdentifierQuoteString();
        Statement st = conlocal.createStatement();
        ResultSet rs = st.executeQuery(sql);
        ResultSetMetaData rsMeta = rs.getMetaData();
        int colCount = rsMeta.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            hm.putCounter(rsMeta.getColumnName(i));
        }
        try {
            rs.close();
        }
        catch (Throwable i) {
            // empty catch block
        }
        try {
            st.close();
        }
        catch (Throwable i) {
            // empty catch block
        }
        Vector<String> counterVec = new Vector<String>();
        DataImportConnectorImpl.sortElements(hm, vec, counterVec);
    }

    private static void getTables(Connection conlocal, DatabaseConfigInfo dbInfo, Vector<String> vec) throws SQLException {
        String table;
        String schema = null;
        String catalog = null;
        if (dbInfo != null) {
            switch (dbInfo.getDriver()) {
                case inetora: {
                    schema = dbInfo.getUser();
                    break;
                }
                case inetdae7: {
                    catalog = conlocal.getCatalog();
                    break;
                }
                case mysql: {
                    catalog = conlocal.getCatalog();
                    break;
                }
                case odbc: {
                    break;
                }
                default: {
                    catalog = conlocal.getCatalog();
                    schema = conlocal.getSchema();
                }
            }
        }
        String[] types = new String[]{"TABLE", "VIEW"};
        DatabaseMetaData dbmd = conlocal.getMetaData();
        HDLogger.info("DatabaseMetaData " + dbmd.getDatabaseProductName() + "-" + dbmd.getDatabaseProductVersion() + "-" + dbmd.getDriverName() + "-" + dbmd.getDriverVersion());
        ResultSet tables = dbmd.getTables(catalog, schema, null, types);
        HDLogger.info("DatabaseMetaData.getTables " + catalog + " " + schema);
        if (!tables.next()) {
            try {
                tables.close();
            }
            catch (Throwable e) {
                HDLogger.debug(e);
            }
            HDLogger.debug("No tables");
            tables = conlocal.getMetaData().getTables(catalog, schema, null, null);
        } else {
            table = tables.getString(3);
            HDLogger.info("Table: " + table);
            vec.addElement(table);
        }
        while (tables.next()) {
            table = tables.getString(3);
            HDLogger.info("Table: " + table);
            vec.addElement(table);
        }
        HDLogger.info("Number of tables " + vec.size());
        try {
            tables.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Connection getDatabaseConnection(ConnectionEntry connection) throws SQLException, ServerDataException {
        DatabaseConfigInfo dbInfo = ((DatabaseConfigInfoList)DATABASE_CONNECTION_INFOS.get()).get(connection.getName());
        if (dbInfo == null) {
            throw new ServerDataException(new Exception(MSG.getMsg("dataImport.noConnectionFound", new Object[]{connection.getName()})));
        }
        return UserImporter.getConnection(dbInfo);
    }

    @Override
    public synchronized ArrayList<String> getColumns(ConnectionEntry connection, String tableName, boolean useUserSyntax, String userSyntax) throws ServerDataException {
        long start = System.currentTimeMillis();
        ArrayList<String> columns = new ArrayList<String>();
        try {
            Vector<String> vec = new Vector<String>();
            if (connection != null) {
                if (connection.getConnectionType() == DataImportConnector.ConnectionType.ldap) {
                    LdapConnectionInfo ldapConnectionInfo = ((LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get()).get(connection.getName());
                    if (ldapConnectionInfo == null) {
                        throw new ServerDataException(new Exception(MSG.getMsg("dataImport.noConnectionFound", new Object[]{connection.getName()})));
                    }
                    UserImporter.getLdapAttributs(vec, ldapConnectionInfo, tableName, useUserSyntax, userSyntax);
                } else if (connection.getConnectionType() == DataImportConnector.ConnectionType.database) {
                    Connection dbConnection = this.getDatabaseConnection(connection);
                    DataImportConnectorImpl.getColumns(dbConnection, vec, tableName);
                }
                columns.addAll(vec);
            }
        }
        catch (SQLException | NamingException e) {
            throw new ServerDataException(e);
        }
        logger.debug((Object)("Column request: " + (System.currentTimeMillis() - start) + "ms"));
        return columns;
    }

    public static void sortElements(StringIntHashMap hm, Vector<String> names, Vector<String> counts) {
        int i;
        int size = hm.size();
        int pos = 0;
        String[][] all = new String[size + 1][3];
        hm.moveToStart();
        while (hm.hasMore()) {
            String theKey = hm.getCurrentKey();
            all[pos][0] = theKey.toLowerCase();
            all[pos][1] = theKey;
            all[pos][2] = String.valueOf(hm.getCurrentValue());
            ++pos;
        }
        for (i = 0; i < size - 1; ++i) {
            for (int n = i + 1; n < size; ++n) {
                if (all[i][0].compareTo(all[n][0]) <= 0) continue;
                for (int z = 0; z < 3; ++z) {
                    all[size][z] = all[i][z];
                    all[i][z] = all[n][z];
                    all[n][z] = all[size][z];
                }
            }
        }
        for (i = 0; i < size; ++i) {
            names.addElement(all[i][1]);
            counts.addElement(all[i][2]);
        }
    }

    @Override
    public void startDeviceImport(DeviceImportConfigInfo deviceConfig, String importName, ConnectionEntry connection) {
        this.runner.executeJob(deviceConfig, importName, connection);
    }

    @Override
    public void startUserImport(UserImportConfigInfo userConfig, String importName, ConnectionEntry connection) {
        this.runner.executeJob(userConfig, importName, connection);
    }

    @Override
    public DataImportJob createJob(String uid) {
        return this.runner.createJob(uid);
    }

    @Override
    public ArrayList<DataImportJob> getJobs(String uid) {
        return this.runner.getJobs(uid);
    }

    @Override
    public List<Map<String, String>> getExamples(DeviceImportConfigInfo dici, String importName) throws ServerDataException {
        List<Map<String, String>> list;
        block12: {
            ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            Connection hdsConnection = connectionFactory.getConnection();
            try {
                GeraeteImporter.SampleInvoker sampleInvoker = new GeraeteImporter.SampleInvoker();
                DataImportJob job = new DataImportJob();
                new GeraeteImporter(hdsConnection, dici, importName, sampleInvoker, job);
                if (job.getError() != null && !job.getError().isEmpty()) {
                    throw new ServerDataException(new Exception(job.getError()));
                }
                list = sampleInvoker.getResult();
                if (hdsConnection == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (hdsConnection != null) {
                        try {
                            hdsConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ServerDataException(e);
                }
            }
            hdsConnection.close();
        }
        return list;
    }

    @Override
    public List<Map<String, String>> getExamples(UserImportConfigInfo uici) throws ServerDataException {
        UserImporter.ReadRecordStateWithSamples readRecordStateWithSamples;
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)DATABASE_CONNECTION_INFOS.get();
        DataImportJob job = new DataImportJob();
        if (uici.isLdap()) {
            LdapConnectionInfo ldapConnectionInfo = ((LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get()).get(uici.getConnectionName());
            readRecordStateWithSamples = (UserImporter.ReadRecordStateWithSamples)new UserImporter(uici).runForLdap(job, new UserImporter.ReadSampleRecordStateFactory(), ldapConnectionInfo, false, uici);
        } else {
            DatabaseConfigInfo dbConn = list.get(uici.getConnectionName());
            readRecordStateWithSamples = (UserImporter.ReadRecordStateWithSamples)new UserImporter(uici).runForSqlDb(job, new UserImporter.ReadSampleRecordStateFactory(), dbConn, uici);
        }
        if (job.getEntriesError() > 0) {
            logger.warn((Object)("had " + job.getEntriesError() + " issues while importing!"));
        }
        if (job.getError() != null && !job.getError().isEmpty()) {
            throw new ServerDataException(new Exception(job.getError()));
        }
        return readRecordStateWithSamples == null ? null : readRecordStateWithSamples.getSamples();
    }

    @Override
    public boolean isTimeForJob(String uid, DataImportSchedule schedule, Calendar currentCal) {
        ArrayList<DataImportJob> jobs = this.getJobs(uid);
        long timeLastRun = 0L;
        for (DataImportJob job : jobs) {
            timeLastRun = Math.max(timeLastRun, job.getStartTime());
        }
        int endHour = schedule.getEndHour();
        int hourOfDay = schedule.getHourOfDay();
        int startHour = schedule.getStartHour();
        DataImportSchedule.MainTimeOption mainOption = schedule.getMainOption();
        DataImportSchedule.SubTimeOption subOption = schedule.getSubOption();
        Calendar startCal = Calendar.getInstance();
        startCal.setTimeInMillis(currentCal.getTimeInMillis());
        switch (mainOption) {
            case MANUAL: {
                return false;
            }
            case WEEKLY: {
                startCal.set(7, (1 + subOption.ordinal()) % 7 + 1);
                startCal.set(11, hourOfDay);
                startCal.set(12, 0);
                startCal.set(13, 0);
                break;
            }
            case DAILY: {
                startCal.set(11, hourOfDay);
                startCal.set(12, 0);
                startCal.set(13, 0);
                break;
            }
            case HOURLY: {
                if (startHour <= endHour) {
                    if (startCal.get(11) < startHour && startHour > 0) {
                        return false;
                    }
                    if (startCal.get(11) >= endHour && endHour > 0) {
                        return false;
                    }
                } else {
                    if (startCal.get(11) > startHour && startHour > 0 && startCal.get(11) < endHour && endHour > 0) {
                        return false;
                    }
                    if (startCal.get(11) < startHour && startHour > 0 && startCal.get(11) >= endHour && endHour > 0) {
                        return false;
                    }
                }
                startCal.set(12, 0);
                startCal.set(13, 0);
                break;
            }
            case HALFHOUR: {
                if (startHour <= endHour) {
                    if (startCal.get(11) < startHour && startHour > 0) {
                        return false;
                    }
                    if (startCal.get(11) >= endHour && endHour > 0) {
                        return false;
                    }
                } else {
                    if (startCal.get(11) > startHour && startHour > 0 && startCal.get(11) < endHour && endHour > 0) {
                        return false;
                    }
                    if (startCal.get(11) < startHour && startHour > 0 && startCal.get(11) >= endHour && endHour > 0) {
                        return false;
                    }
                }
                startCal.set(12, startCal.get(12) >= 30 ? 30 : 0);
                startCal.set(13, 0);
            }
        }
        if (timeLastRun > startCal.getTimeInMillis()) {
            return false;
        }
        long timeSinceStart = currentCal.getTimeInMillis() - startCal.getTimeInMillis();
        return timeSinceStart > 0L && timeSinceStart < 1800000L;
    }

    @Override
    public HashSet<String> getUserImportNamesFromDatabase() throws ServerDataException {
        HashSet<String> importNames = new HashSet<String>();
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = connectionFactory.getConnection();
            st = con.createStatement();
            rs = st.executeQuery(SQL_GETUSERIMPORTNAMES);
            while (rs.next()) {
                String impName = rs.getString(1);
                if (impName == null || impName.length() <= 0) continue;
                importNames.add(impName);
            }
        }
        catch (SQLException e) {
            try {
                throw new ServerDataException(e);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, st, rs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, st, rs);
        return importNames;
    }

    @Override
    public HashSet<String> getDeviceImportNamesFromDatabase() throws ServerDataException {
        HashSet<String> importNames = new HashSet<String>();
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = connectionFactory.getConnection();
            st = con.createStatement();
            rs = st.executeQuery(SQL_GETDEVICEIMPORTNAMES);
            while (rs.next()) {
                String impName = rs.getString(1);
                if (impName == null || impName.length() <= 0) continue;
                importNames.add(impName);
            }
        }
        catch (SQLException e) {
            try {
                throw new ServerDataException(e);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, st, rs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, st, rs);
        return importNames;
    }

    @Override
    public DataImportConnector.DevicesFromImport getDevicesFromImport(String importName, int count) throws ServerDataException {
        DataImportConnector.DevicesFromImport result = new DataImportConnector.DevicesFromImport();
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        ServerDataConnector serverDataConnector = (ServerDataConnector)ServerPluginManager.getInstance().getSingleInstance(ServerDataConnector.class);
        ArrayList<DeviceType> deviceTypes = serverDataConnector.getDeviceTypes();
        Connection con = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        int resultCount = 0;
        ArrayList<Entry> examples = new ArrayList<Entry>();
        try {
            con = connectionFactory.getConnection();
            pst = con.prepareStatement(SQL_GETDEVICESFORIMPORTNAME);
            pst.setString(1, importName);
            rs = pst.executeQuery();
            while (rs.next()) {
                LocationVO locationVO;
                if (++resultCount > count) continue;
                int id = rs.getInt("GerID");
                String displayName = rs.getString("GerBezeichnung");
                int type = rs.getInt("GTyID");
                int location = rs.getInt("GebID");
                String room = rs.getString("Zimmer");
                String serial = rs.getString("Seriennummer");
                String plant = rs.getString("Anlagennummer");
                String costcenter = rs.getString("Kostenstelle");
                Timestamp purchaseDate = rs.getTimestamp("KaufDatum");
                double price = rs.getDouble("Preis");
                Entry device = new Entry(-1, id, displayName);
                device.getDataFields().add(new DataField(Field.DEVICEDATA_TYPE, (Object)type));
                if (deviceTypes != null) {
                    for (DeviceType dType : deviceTypes) {
                        if (dType.getGerTypeId() != type) continue;
                        device.getDataFields().add(new DataField(Field.DEVICEDATA_TYPE_DISPLAYNAME, (Object)dType.getDisplayName()));
                    }
                }
                if ((locationVO = (LocationVO)LocationManager.getInstance().get(location)) != null) {
                    device.getDataFields().add(new DataField(Field.DEVICEDATA_LOCATION_DISPLAYNAME, (Object)locationVO.getDisplayValue()));
                }
                if (room != null && !room.isEmpty()) {
                    device.getDataFields().add(new DataField(Field.DEVICEDATA_ROOM, (Object)room));
                }
                if (serial != null && !serial.isEmpty()) {
                    device.getDataFields().add(new DataField(Field.DEVICEDATA_SERIALNUMBER, (Object)serial));
                }
                if (plant != null && !plant.isEmpty()) {
                    device.getDataFields().add(new DataField(Field.DEVICEDATA_PLANTNUMBER, (Object)plant));
                }
                if (costcenter != null && !costcenter.isEmpty()) {
                    device.getDataFields().add(new DataField(Field.DEVICEDATA_COSTCENTRE, (Object)costcenter));
                }
                if (purchaseDate != null) {
                    device.getDataFields().add(new DataField(Field.DEVICEDATA_PURCHASEDATE, (Object)new Date(purchaseDate.getTime())));
                }
                if (price > 0.0) {
                    device.getDataFields().add(new DataField(Field.DEVICEDATA_PRICE, (Object)price));
                }
                examples.add(device);
            }
        }
        catch (SQLException e) {
            try {
                throw new ServerDataException(e);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, pst, rs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, pst, rs);
        result.setCount(resultCount);
        result.setExamples(examples);
        return result;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Parameter is only Integer")
    public void deleteDevicesFromImport(String importName) throws ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        ConnectionFactory connectionFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
        try (Connection con = connectionFactory.getConnection();){
            List<Integer> deviceIds = this.readIdsOfDevicesFromImport(importName, con);
            if (deviceIds.isEmpty()) {
                return;
            }
            new SubListTaskExecutor().executeForEachSubList(deviceIds, 900, subList -> {
                Object ids = subList.toString();
                ids = "(" + ((String)ids).substring(1, ((String)ids).length() - 1) + ")";
                try (PreparedStatement pstm = con.prepareStatement("DELETE from tblGeraeteBestand WHERE GerID IN " + (String)ids);){
                    pstm.execute();
                }
            });
            for (ImportedDeviceDeletionListener listener : spm.get(ImportedDeviceDeletionListener.class)) {
                listener.devicesDeleted(deviceIds);
            }
            ServerUtilities.conti.setChanged(15, true);
        }
        catch (Exception e) {
            throw new ServerDataException(e);
        }
    }

    private List<Integer> readIdsOfDevicesFromImport(String importName, Connection con) throws SQLException {
        ArrayList<Integer> deviceIds = new ArrayList<Integer>();
        try (PreparedStatement pstm = con.prepareStatement(SQL_IDS_OF_DEVICES_FOR_IMPORT_NAME);){
            pstm.setString(1, importName);
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    deviceIds.add(rs.getInt(1));
                }
            }
        }
        return deviceIds;
    }
}

