/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.classloader.LoaderUtils;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.jj.srv.JJServer;
import com.inet.jj.srv.JavaCommand;
import com.inet.jj.srv.JavaCommandFactory;
import com.inet.lib.json.Json;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import srv.ServerUtilities;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    private static final int DEFAULT_QUERY_TIMEOUT = 30;
    private final JJServer jjServer;
    private Boolean hdsValid;

    public ConnectionFactoryImpl(JJServer jjServer) {
        this.jjServer = jjServer;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection("HDS");
    }

    @Override
    public boolean isHelpDeskDatabaseConnectionValid() {
        if (this.hdsValid == null) {
            try {
                Connection con = this.getConnection();
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                return false;
            }
        }
        return this.hdsValid;
    }

    @Override
    public Connection getConnection(String database) throws SQLException {
        if (ConfigurationManager.isHelpCenterMode()) {
            throw new SQLException("No connection in help center mode");
        }
        Connection alreadyExistingConnection = ConnectionFactory.getCurrentConnectionWithTransaction();
        if (alreadyExistingConnection != null && !alreadyExistingConnection.isClosed()) {
            Connection nonCloseableConnection = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (proxy, method, methodArgs) -> {
                if (method.getName().equals("close")) {
                    return null;
                }
                return method.invoke((Object)alreadyExistingConnection, methodArgs);
            });
            return nonCloseableConnection;
        }
        if (database == null) {
            database = "HDS";
        }
        try {
            Connection connection = this.jjServer.getConnection(database);
            if (database.equals("HDS")) {
                this.hdsValid = true;
            }
            return this.wrappedConnectionWithDefaultQueryTimeout(connection);
        }
        catch (SQLException exc) {
            if (database.equals("HDS")) {
                this.hdsValid = false;
                return this.wrappedConnectionWithDefaultQueryTimeout(this.getConnectionFromConfiguration(exc));
            }
            throw exc;
        }
    }

    protected Connection wrappedConnectionWithDefaultQueryTimeout(Connection connection) {
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (proxy, method, methodArgs) -> {
            String methodName = method.getName();
            if (methodName.equals("createStatement") || methodName.equals("prepareStatement") || methodName.equals("prepareCall")) {
                Statement st = (Statement)method.invoke((Object)connection, methodArgs);
                try {
                    st.setQueryTimeout(30);
                }
                catch (SQLException exc) {
                    HDLogger.debug(exc);
                }
                return st;
            }
            return method.invoke((Object)connection, methodArgs);
        });
    }

    private Connection getConnectionFromConfiguration(SQLException originalException) throws SQLException {
        String dbConfigs;
        Configuration config;
        Configuration configuration = config = ConfigurationManager.isRecoveryMode() ? ConfigurationManager.getInstance().get(ConfigurationManager.getRecoveryConfiguration()) : null;
        if (config == null) {
            config = ConfigurationManager.getInstance().getCurrent();
        }
        if ((dbConfigs = config.get(HDConfigKeys.DB_CONFIGS.getKey())) == null || dbConfigs.isEmpty()) {
            throw originalException;
        }
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        DatabaseConfigInfo dbInfo = list.get("HDS");
        if (dbInfo == null) {
            throw originalException;
        }
        try {
            LoaderUtils.classForName((String)dbInfo.getDriverClassName(), (Object)this);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
        Object url = dbInfo.getUrl();
        if (((String)url).startsWith("jdbc:") && !((String)url).startsWith("jdbc:inetpool:")) {
            url = "jdbc:inetpool:" + ((String)url).substring(5);
        }
        return DriverManager.getConnection((String)url, dbInfo.getUser(), dbInfo.getDecodedPassword());
    }

    @Override
    public Object getCommand(String cmd) {
        return this.jjServer.getCommand(cmd);
    }

    @Override
    public CallableStatement getCallableStatement(String commandName, Connection con) throws SQLException {
        Object command = this.getCommand(commandName);
        if (command == null || !(command instanceof JavaCommandFactory)) {
            throw new SQLException("There is no suitable callable command '" + commandName + "' registered");
        }
        JavaCommandFactory javaCommandFactory = (JavaCommandFactory)command;
        if (con == null) {
            throw new SQLException("Failed to aquire a connection to the server database.");
        }
        try {
            JavaCommand prepareCallCommand = javaCommandFactory.prepareCallCommand(con);
            return prepareCallCommand;
        }
        catch (SQLException e) {
            JavaCommand prepareCommand = javaCommandFactory.prepareCommand(con);
            return prepareCommand;
        }
    }

    @Override
    public String testDBConnection(String url, String pwd, String user, String driverClassName, String databaseName) {
        return this.testDBConnection(url, pwd, user, driverClassName, databaseName, true);
    }

    @Override
    public String testDBConnection(String url, String pwd, String user, String driverClassName, String databaseName, boolean logOnErrorLevel) {
        return ServerUtilities.testDB(url, pwd, user, driverClassName, databaseName, logOnErrorLevel);
    }
}

