/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import com.inet.helpdesk.core.HDLogger;
import java.lang.invoke.StringConcatFactory;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class SecurityUtils {
    private static final char[] BASE_64;
    private static byte[] convert_array;

    public static String decodePassword(String input) {
        String pwd;
        char[] xorVerschluessler;
        String encpwd = "";
        try {
            encpwd = new String(Base64.getDecoder().decode(input), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException ex) {
            HDLogger.debug("Password was not Base64.");
        }
        if (encpwd.length() > 0 && encpwd.charAt(0) == '\u0001') {
            input = encpwd;
        }
        if ((xorVerschluessler = input.toCharArray()).length > 1 && xorVerschluessler[0] == '\u0001') {
            for (int i = 1; i < xorVerschluessler.length; ++i) {
                xorVerschluessler[i] = (char)(xorVerschluessler[i] ^ 0x24);
            }
            pwd = new String(xorVerschluessler, 1, xorVerschluessler.length - 1);
        } else {
            pwd = xorVerschluessler.length == 0 || xorVerschluessler.length == 1 && xorVerschluessler[0] == '\u0001' ? "" : new String(xorVerschluessler);
        }
        return pwd;
    }

    public static String encodePassword(char[] xorVerschluessler) {
        char[] schluessel = new String(xorVerschluessler).toCharArray();
        for (int i = 0; i < schluessel.length; ++i) {
            schluessel[i] = (char)(schluessel[i] ^ 0x24);
        }
        return new String(Base64.getEncoder().encode(((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001", "\u0001"}, (String)new String(schluessel)))).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String decodeBase64(String src) {
        return new String(SecurityUtils.decodeBase64(src.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static byte[] decodeBase64(byte[] src) {
        int kor = src.length / 4 * 3;
        if (src[src.length - 1] == 61) {
            --kor;
            if (src[src.length - 2] == 61) {
                --kor;
            }
        }
        byte[] dest = new byte[kor];
        int i = 0;
        int j = 0;
        while (j + 3 < src.length) {
            byte a = convert_array[src[j]];
            byte b = convert_array[src[j + 1]];
            dest[i] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
            if (i + 1 < dest.length) {
                dest[i + 1] = (byte)(b << 4 & 0xF0 | convert_array[src[j + 2]] >>> 2 & 0xF);
            }
            if (i + 2 < dest.length) {
                dest[i + 2] = (byte)(convert_array[src[j + 2]] << 6 & 0xC0 | convert_array[src[j + 3]] & 0x3F);
            }
            i += 3;
            j += 4;
        }
        return dest;
    }

    static {
        int i;
        BASE_64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        convert_array = new byte[256];
        for (i = 0; i < 255; ++i) {
            SecurityUtils.convert_array[i] = -1;
        }
        for (i = 0; i < BASE_64.length; ++i) {
            SecurityUtils.convert_array[SecurityUtils.BASE_64[i]] = (byte)i;
        }
    }
}

