/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.utils.MailAttachmentUtilities;
import com.inet.helpdesk.core.utils.MailEncodingUtilities;
import com.inet.lib.util.IOFunctions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;

public class PartHandler {
    private static final String DELVERY_STATUS_PART = "message/delivery-status";
    private Part part;
    private String contentType;
    private String disposition;
    private String fileName;
    private String fileExtension;
    private String[] headerContentLocation;
    private String[] headerContentID;
    private String partContentString;
    private boolean isTextBodyPart = false;
    private boolean isMessage = false;
    private boolean alternativePart = false;
    private boolean isDeliveryStatusPart = false;

    public PartHandler(Part part, boolean alternativePart) {
        this.part = part != null ? part : new EmptyBody();
        this.alternativePart = alternativePart;
    }

    private void setContentTyp(String str) {
        this.contentType = str;
    }

    public void checkPart(ArrayList<PartHandler> list, int position) {
        try {
            String test;
            PartHandler currentBodyPart = null;
            this.contentType = MailAttachmentUtilities.getContentType(this.part);
            this.disposition = this.part.getDisposition();
            boolean uft7Codierung = this.contentType.indexOf("charset=utf-7") > -1;
            for (int i = position; i >= 0; --i) {
                if (!list.get((int)i).isTextBodyPart) continue;
                currentBodyPart = list.get(i);
            }
            if ((this.disposition == null || this.disposition.equalsIgnoreCase("inline")) && (this.isTextPart() || this.isHtmlPart())) {
                boolean bl = this.isTextBodyPart = currentBodyPart == null || currentBodyPart.isTextPart() && !uft7Codierung && this.isHtmlPart() || position == 0 && currentBodyPart.isHtmlPart() && this.isTextPart();
                if (this.alternativePart && this.isTextBodyPart) {
                    return;
                }
            }
            try {
                this.headerContentLocation = this.part.getHeader("Content-Location");
                if (this.headerContentLocation != null) {
                    for (int n = 0; n < this.headerContentLocation.length; ++n) {
                        if (this.headerContentLocation[n].indexOf("%20") <= -1) continue;
                        this.headerContentLocation[n] = this.headerContentLocation[n].replaceAll("%20", " ").trim();
                    }
                }
                this.headerContentID = this.part.getHeader("Content-ID");
            }
            catch (Exception mex) {
                HDLogger.error(mex);
            }
            String fn = this.part.getFileName();
            if (fn != null && (fn.length() == 1 || fn.length() == 60 || fn.toLowerCase().startsWith("iso-8859-15''") || fn.toLowerCase().startsWith("utf-8''")) && (test = PartHandler.getFilename(this.part)).length() > fn.length()) {
                fn = test;
            }
            if (fn != null) {
                fn = MailEncodingUtilities.tryEncoding(fn, false, false);
                char[] chars = fn.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] > '\ue000') {
                        chars[i] = 63;
                        continue;
                    }
                    if (chars[i] != '#') continue;
                    chars[i] = 95;
                }
                fn = new String(chars);
            }
            if (this.contentType.equals("message/rfc822") || this.contentType.startsWith("message/rfc822;")) {
                Object partContent = this.part.getContent();
                if (partContent instanceof Part) {
                    this.isMessage = true;
                } else if (partContent instanceof String) {
                    this.partContentString = (String)partContent;
                }
                this.fileName = fn == null || fn.length() == 0 ? "Message" : fn;
                this.fileExtension = this.isMessage ? ".mim" : ".txt";
            } else if (fn != null) {
                int dotPos = fn.lastIndexOf(46);
                if (dotPos > -1) {
                    this.fileName = fn.substring(0, dotPos);
                    this.fileExtension = "." + fn.substring(dotPos + 1).trim();
                    if (this.fileExtension.indexOf(32) > -1) {
                        StringBuilder buf = new StringBuilder();
                        for (int i = 0; i < this.fileExtension.length(); ++i) {
                            char chr = this.fileExtension.charAt(i);
                            if (chr == ' ') continue;
                            buf.append(chr);
                        }
                        this.fileExtension = buf.toString();
                    }
                } else {
                    this.fileName = fn;
                    this.fileExtension = "";
                }
            } else if (this.isTextPart() || this.contentType.indexOf(47) == -1) {
                if (currentBodyPart == null) {
                    this.isTextBodyPart = true;
                } else {
                    this.fileName = "attachet";
                    this.fileExtension = "";
                }
            } else {
                if (DELVERY_STATUS_PART.equalsIgnoreCase(this.contentType)) {
                    this.isDeliveryStatusPart = true;
                }
                fn = this.contentType.replace('/', '.');
                int dotPos = fn.lastIndexOf(46);
                this.fileName = fn.substring(0, dotPos);
                this.fileExtension = fn.substring(dotPos);
                if (this.fileExtension.indexOf(59) != -1) {
                    this.fileExtension = this.fileExtension.substring(0, this.fileExtension.indexOf(59));
                }
                if (this.fileExtension.indexOf(32) != -1) {
                    this.fileExtension = this.fileExtension.substring(0, this.fileExtension.indexOf(32));
                }
            }
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
    }

    public String getCharset() {
        int charsetIndex = this.contentType.indexOf("charset=");
        if (charsetIndex > -1) {
            return MailAttachmentUtilities.extractCharset(this.contentType, charsetIndex);
        }
        return "";
    }

    public String getContentTyp() {
        return this.contentType;
    }

    public String getPartContentString() {
        return this.partContentString;
    }

    public String getFileExtention() {
        return this.fileExtension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getContentLocation() {
        return this.headerContentLocation;
    }

    public String[] getContentID() {
        return this.headerContentID;
    }

    public boolean isMessage() {
        return this.isMessage;
    }

    public boolean isTextPart() {
        return this.contentType.startsWith("text/plain;") || this.contentType.equals("text/plain");
    }

    public boolean isHtmlPart() {
        return this.contentType.startsWith("text/html;") || this.contentType.equals("text/html");
    }

    public boolean isDeliveryStatusPart() {
        return this.isDeliveryStatusPart;
    }

    public String getPartHeader(String header) {
        try {
            Enumeration headers = this.part.getAllHeaders();
            if (headers != null) {
                while (headers.hasMoreElements()) {
                    Header h = (Header)headers.nextElement();
                    if (!header.equalsIgnoreCase(h.getName())) continue;
                    return h.getValue();
                }
            }
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
        return "";
    }

    public Part getPart() {
        return this.part;
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        try {
            Object content = this.part.getContent();
            String str = content instanceof InputStream ? IOFunctions.readAsciiString((InputStream)((InputStream)content)) : content.toString();
            if (this.isHtmlPart() && this.getCharset().length() == 0 && str.indexOf(195) > -1) {
                str = new String(str.getBytes("ISO8859_1"), "UTF8");
            }
            return str;
        }
        catch (Exception ex) {
            if (ex instanceof UnsupportedEncodingException) {
                throw (UnsupportedEncodingException)ex;
            }
            HDLogger.error(ex);
            return "";
        }
    }

    private static String getFilename(Part p) {
        try {
            Enumeration headers = p.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header h = (Header)headers.nextElement();
                int posFN = h.getValue().toLowerCase().indexOf("name=");
                if (posFN <= -1) continue;
                String someFileName = h.getValue().substring(posFN + 5);
                if (someFileName.startsWith("\"")) {
                    int end = someFileName.lastIndexOf(34);
                    end = end > 0 ? end : someFileName.length() - 1;
                    someFileName = someFileName.substring(1, end);
                }
                return someFileName;
            }
        }
        catch (Throwable e) {
            HDLogger.error(e);
        }
        return "unknown";
    }

    public static PartHandler getTextBodyPart(ArrayList<PartHandler> list) {
        int i;
        PartHandler bestPart = null;
        for (i = list.size() - 1; i >= 0; --i) {
            if (!list.get((int)i).isTextBodyPart) continue;
            if (bestPart == null || !list.get(i).isTextPart()) {
                if (bestPart != null && !list.get((int)i).alternativePart) {
                    list.add(bestPart);
                }
                bestPart = list.get(i);
            }
            list.remove(i);
        }
        if (bestPart == null) {
            for (i = list.size() - 1; i >= 0; --i) {
                if (!"inline".equals(list.get((int)i).disposition)) continue;
                bestPart = list.get(i);
                break;
            }
        }
        if (bestPart == null) {
            bestPart = new PartHandler(null, false);
            bestPart.setContentTyp("text/plain;");
        }
        return bestPart;
    }

    private class EmptyBody
    implements Part {
        private EmptyBody() {
        }

        public int getSize() throws MessagingException {
            return 0;
        }

        public int getLineCount() throws MessagingException {
            return 0;
        }

        public String getContentType() throws MessagingException {
            return "";
        }

        public boolean isMimeType(String mimeType) throws MessagingException {
            return true;
        }

        public String getDisposition() throws MessagingException {
            return "";
        }

        public void setDisposition(String disposition) throws MessagingException {
        }

        public String getDescription() throws MessagingException {
            return "";
        }

        public void setDescription(String description) throws MessagingException {
        }

        public String getFileName() throws MessagingException {
            return null;
        }

        public void setFileName(String filename) throws MessagingException {
        }

        public InputStream getInputStream() throws IOException, MessagingException {
            return null;
        }

        public DataHandler getDataHandler() throws MessagingException {
            return null;
        }

        public Object getContent() throws IOException, MessagingException {
            return "";
        }

        public void setDataHandler(DataHandler dh) throws MessagingException {
        }

        public void setContent(Object obj, String type) throws MessagingException {
        }

        public void setText(String text) throws MessagingException {
        }

        public void setContent(Multipart mp) throws MessagingException {
        }

        public void writeTo(OutputStream os) throws IOException, MessagingException {
        }

        public String[] getHeader(String header_name) throws MessagingException {
            return null;
        }

        public void setHeader(String header_name, String header_value) throws MessagingException {
        }

        public void addHeader(String header_name, String header_value) throws MessagingException {
        }

        public void removeHeader(String header_name) throws MessagingException {
        }

        public Enumeration<Header> getAllHeaders() throws MessagingException {
            return null;
        }

        public Enumeration<Header> getMatchingHeaders(String[] header_names) throws MessagingException {
            return null;
        }

        public Enumeration<Header> getNonMatchingHeaders(String[] header_names) throws MessagingException {
            return null;
        }
    }
}

