/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview.subview;

import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewSearchCommandFactory;
import com.inet.helpdesk.core.ticketview.TicketViewState;
import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class SimpleSubViewGrouping
implements SubViewGroupingDefinition {
    public static final int MAX_NODE_COUNT = 100;
    private static final SearchCondition UNREAD = new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{100, 101});
    private final String key;

    protected SimpleSubViewGrouping(String key) {
        this.key = Objects.requireNonNull(key);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDisplayName() {
        return Tickets.getFieldDisplayName(this.getKey());
    }

    @Override
    public void appendMarker(SearchCommand command) {
        command.addBoostingExpression((SearchExpression)new SearchCondition(this.key, SearchCondition.SearchTermOperator.StartsWith, (Object)""));
    }

    @Override
    public void patchSearchCommand(Object id, @Nonnull SearchCommand command, @Nonnull GUID accountID) {
        AndSearchExpression expressions = command.getSearchExpression();
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            SearchCondition cond;
            SearchExpression expr = (SearchExpression)it.next();
            if (expr.getType() != SearchExpression.Type.Condition || !this.key.equals((cond = (SearchCondition)expr).getLeftOperand())) continue;
            switch (cond.getOperator()) {
                case StartsWith: {
                    it.remove();
                }
            }
        }
        expressions.add((SearchExpression)new SearchCondition(this.key, SearchCondition.SearchTermOperator.Equals, id));
    }

    @Override
    public void appendSubViewStates(TicketViewState parentState, TicketViewFactory parentFactory, GUID accountID, @Nonnull Set<Integer> result, @Nullable Set<Integer> unreadResult, IndexSearchEngine<Integer> engine, @Nullable IndexSearchEngine<SlaveInfo> slaveInfoEngine) {
        PrefilteredSearchExpression all = new PrefilteredSearchExpression(result);
        PrefilteredSearchExpression unread = unreadResult == null ? null : new PrefilteredSearchExpression(unreadResult);
        List<TicketViewFactory> subViews = this.getSubViews(parentFactory, accountID, Locale.getDefault());
        if (subViews == null) {
            return;
        }
        TicketViewManager manager = TicketViewManager.getInstance();
        for (TicketViewFactory subView : subViews) {
            int unreadCount;
            if (parentState.size() >= 100) break;
            SearchCommand command = subView.createSearchCommand(accountID, Locale.getDefault(), engine);
            if (command == null) continue;
            AndSearchExpression searchExpression = command.getSearchExpression();
            searchExpression.add(0, (Object)all);
            command.setResultLimit(20000);
            Set subResult = engine.simpleSearch(command);
            manager.convertToBunIdsIfNeeded(slaveInfoEngine, subResult, accountID);
            int count = subResult.size();
            if (count == 0) continue;
            if (unread == null) {
                unreadCount = 0;
            } else {
                searchExpression.set(0, (Object)unread);
                searchExpression.add((SearchExpression)UNREAD);
                command.setResultLimit(20000);
                subResult = engine.simpleSearch(command);
                manager.convertToBunIdsIfNeeded(slaveInfoEngine, subResult, accountID);
                unreadCount = subResult.size();
            }
            TicketViewState subState = new TicketViewState(subView.getID(), count, unreadCount, subView, parentState);
            parentState.add(subState);
            SubViewGroupingDefinition grouping = subView.getSubViewGrouping();
            if (grouping == null) continue;
            grouping.appendSubViewStates(subState, subView, accountID, result, unreadResult, engine, slaveInfoEngine);
        }
    }

    @Nullable
    protected Supplier<SearchExpression> getConditionSupplier(@Nonnull String subID) {
        return () -> new SearchCondition(this.key, SearchCondition.SearchTermOperator.Equals, (Object)subID);
    }

    @Override
    @Nullable
    public TicketViewSearchCommandFactory getSearchCommandFactory(final TicketViewSearchCommandFactory parentFactory, final @Nonnull String fullID, @Nonnull String subID) {
        final Supplier<SearchExpression> condition = this.getConditionSupplier(subID);
        if (condition == null) {
            return null;
        }
        return new TicketViewSearchCommandFactory(){

            @Override
            public String getID() {
                return fullID;
            }

            @Override
            public SearchCommand createSearchCommand(GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
                SearchCommand command = parentFactory.createSearchCommand(accountID, locale, engine);
                if (command != null) {
                    AndSearchExpression expressions = command.getSearchExpression();
                    Iterator it = expressions.iterator();
                    while (it.hasNext()) {
                        SearchCondition cond;
                        SearchExpression expr = (SearchExpression)it.next();
                        if (expr.getType() != SearchExpression.Type.Condition || !SimpleSubViewGrouping.this.key.equals((cond = (SearchCondition)expr).getLeftOperand())) continue;
                        switch (cond.getOperator()) {
                            case StartsWith: {
                                it.remove();
                            }
                        }
                    }
                    try (UserAccountScope scope = UserAccountScope.create((GUID)accountID);){
                        expressions.add((SearchExpression)condition.get());
                    }
                }
                return command;
            }
        };
    }
}

