/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview;

import com.inet.helpdesk.core.ticketview.TicketViewCategory;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TicketViewState
extends ArrayList<TicketViewState> {
    private static Map<String, TicketViewCategory> viewCategories;
    private final int totalTicketCount;
    private final int unreadTicketCount;
    private final String id;
    private final TicketViewState parent;
    private final String parentId;
    private final TicketViewFactory factory;
    private final int metaDataVersion;

    public TicketViewState(String id, int totalTicketCount, int unreadTicketCount, TicketViewFactory factory, TicketViewState parent) {
        this(id, totalTicketCount, unreadTicketCount, factory, parent, parent.id, parent.metaDataVersion);
    }

    public TicketViewState(String id, int totalTicketCount, int unreadTicketCount, TicketViewFactory factory, int metaDataVersion) {
        this(id, totalTicketCount, unreadTicketCount, factory, null, null, metaDataVersion);
    }

    private TicketViewState(String id, int totalTicketCount, int unreadTicketCount, TicketViewFactory factory, TicketViewState parent, String parentID, int metaDataVersion) {
        super(0);
        this.id = id;
        this.parent = parent;
        this.parentId = parentID;
        this.totalTicketCount = totalTicketCount;
        this.unreadTicketCount = unreadTicketCount;
        this.factory = factory;
        this.metaDataVersion = metaDataVersion;
    }

    public String getID() {
        return this.id;
    }

    public String getParentID() {
        return this.parentId;
    }

    public String getDisplayName() {
        return this.factory.getDisplayName();
    }

    public String getDescription() {
        return this.factory.getDescription();
    }

    public String getIconKey() {
        return this.factory.getIconKey();
    }

    public int getTotalTicketCount() {
        return this.totalTicketCount;
    }

    public int getUnreadTicketCount() {
        return this.unreadTicketCount;
    }

    public TicketViewCategory getCategory() {
        String categoryKey;
        TicketViewCategory cat;
        Map<String, TicketViewCategory> map = viewCategories;
        if (map == null) {
            map = new HashMap<String, TicketViewCategory>();
            List categories = ServerPluginManager.getInstance().get(TicketViewCategory.class);
            for (TicketViewCategory cat2 : categories) {
                map.put(cat2.getKey(), cat2);
            }
            viewCategories = map;
        }
        if ((cat = map.get(categoryKey = this.factory.getCategoryKey())) != null) {
            return cat;
        }
        TicketViewState root = this.parent;
        String rootID = this.parentId;
        while (root != null) {
            rootID = root.id;
            root = root.parent;
        }
        return new TicketViewCategory(rootID + categoryKey, () -> categoryKey, () -> this.parent != null ? this.parent.getDescription() : null);
    }

    public boolean hasChanges(@Nonnull TicketViewState old) {
        return this.totalTicketCount != old.totalTicketCount || this.unreadTicketCount != old.unreadTicketCount || this.metaDataVersion != old.metaDataVersion || !Objects.equals(this.getIconKey(), old.getIconKey()) || !Objects.equals(this.getDisplayName(), old.getDisplayName()) || !Objects.equals(this.getDescription(), old.getDescription());
    }
}

