/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.ticketview.standardviews.OwnTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.SupervisorTicketViewDefinition;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nonnull;

@InternalApi
public class GlobalSearchViewDefinition
implements TicketViewFactory {
    public static final String KEY = "globalticketsearch";
    public static final GlobalSearchViewDefinition INSTANCE = new GlobalSearchViewDefinition();

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getCategoryKey() {
        return "globalsearch";
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        return HelpDeskServer.class.getResource("images/ticketview/ticketsearch.png");
    }

    @Override
    @Nonnull
    public SearchCommand createSearchCommand(@Nonnull GUID accountID, @Nonnull Locale locale, IndexSearchEngine<Integer> engine) {
        try (UserAccountScope scape = UserAccountScope.create((GUID)accountID);){
            AndSearchExpression searchExpression;
            boolean isDispatcher = SystemPermissionChecker.checkAccess((Permission)HdPermissions.DISPATCHER);
            if (SystemPermissionChecker.checkAccess((Permission)HdPermissions.TICKET_RESOURCES_READ)) {
                if (isDispatcher) {
                    SearchCommand searchCommand = new SearchCommand(locale, new SearchExpression[0]);
                    return searchCommand;
                }
                SearchCommand searchCommand = new SearchCommand(locale, "dispatchingreastepid", SearchCondition.SearchTermOperator.StartsWith, (Object)"");
                return searchCommand;
            }
            HashSet<GUID> resources = ResourceSubViewGrouping.getResourceIDs(accountID);
            AndSearchExpression supervisor = SupervisorTicketViewDefinition.createSearchExpression(accountID, locale);
            if (!isDispatcher && resources.size() == 0) {
                AndSearchExpression and = new AndSearchExpression();
                and.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString()));
                and.add((SearchExpression)OwnTicketViewDefinition.NO_WORKFLOW);
                if (supervisor != null) {
                    OrSearchExpression or = new OrSearchExpression();
                    or.add((Object)and);
                    or.add((Object)supervisor);
                    searchExpression = or;
                } else {
                    searchExpression = and;
                }
            } else {
                OrSearchExpression or = new OrSearchExpression();
                or.add((Object)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString()));
                if (isDispatcher) {
                    or.add((Object)new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{0, 99}));
                    or.add((Object)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.Equals, null));
                }
                if (resources.size() > 0) {
                    or.add((Object)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resources));
                }
                if (supervisor != null) {
                    or.add((Object)supervisor);
                }
                if (isDispatcher) {
                    searchExpression = or;
                } else {
                    AndSearchExpression and = new AndSearchExpression();
                    and.add((SearchExpression)or);
                    and.add((SearchExpression)new SubtractSearchExpression((SearchExpression)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.Equals, null)));
                    searchExpression = and;
                }
            }
            SearchCommand searchCommand = new SearchCommand(locale, new SearchExpression[]{searchExpression});
            return searchCommand;
        }
    }
}

