/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.ui.model;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.StringFunctions;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;

@InternalApi
public class ByDateRangeSortGroupInformation
extends SortGroupInformation {
    private static List<DateRange> dateRanges = null;
    private static long oneDay = 86400000L;
    private static long oneWeek = oneDay * 7L;
    private String columnKey;

    public ByDateRangeSortGroupInformation(String columnKey) {
        this.columnKey = columnKey;
    }

    protected Long getTimeStamp(TicketVO ticket) {
        return (Long)ticket.getForKey(this.columnKey);
    }

    @Override
    public boolean supportsSortGroups() {
        return true;
    }

    @Override
    public String getSortGroupKey(TicketVO ticket) {
        if (ticket == null) {
            return "";
        }
        Long forKey = this.getTimeStamp(ticket);
        if (forKey != null && forKey instanceof Long) {
            long timestamp = forKey;
            List<DateRange> dateRanges = ByDateRangeSortGroupInformation.getDateRanges();
            for (DateRange range : dateRanges) {
                if (!range.matches(timestamp)) continue;
                return String.valueOf(range.getStartTime());
            }
        }
        return "";
    }

    private static synchronized List<DateRange> getDateRanges() {
        if (dateRanges == null) {
            ByDateRangeSortGroupInformation.createDateRanges();
        }
        return dateRanges;
    }

    private static synchronized void createDateRanges() {
        dateRanges = new ArrayList<DateRange>();
        long now = System.currentTimeMillis();
        long todayStart = now - now % oneDay;
        dateRanges.add(new DateRange(todayStart, () -> Tickets.MSG.getMsg("value.daterange.today", new Object[0])));
        dateRanges.add(new DateRange(todayStart - oneDay, () -> Tickets.MSG.getMsg("value.daterange.yesterday", new Object[0])));
        for (int i = 2; i <= 6; ++i) {
            long weekdayStart = todayStart - (long)i * oneDay;
            dateRanges.add(new DateRange(weekdayStart, () -> new SimpleDateFormat("EEEE", ClientLocale.getThreadLocale()).format(new Date(weekdayStart))));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(todayStart);
        long todaysWeekDay = calendar.get(7) - 1;
        long lastWeek = todayStart - todaysWeekDay * oneDay - oneWeek;
        dateRanges.add(new DateRange(lastWeek, () -> Tickets.MSG.getMsg("value.daterange.lastweek", new Object[0])));
        calendar.set(5, 1);
        long thisMonth = calendar.getTimeInMillis();
        dateRanges.add(new DateRange(thisMonth, () -> new SimpleDateFormat("MMMMM", ClientLocale.getThreadLocale()).format(new Date(thisMonth))));
        calendar.add(2, -1);
        long lastMonth = calendar.getTimeInMillis();
        dateRanges.add(new DateRange(lastMonth, () -> new SimpleDateFormat("MMMMM", ClientLocale.getThreadLocale()).format(new Date(lastMonth))));
        calendar.setTimeInMillis(todayStart);
        calendar.set(5, 1);
        calendar.set(2, 0);
        long thisYear = calendar.getTimeInMillis();
        dateRanges.add(new DateRange(thisYear, () -> new SimpleDateFormat("yyyy", ClientLocale.getThreadLocale()).format(new Date(thisYear))));
        calendar.add(1, -1);
        long lastYear = calendar.getTimeInMillis();
        dateRanges.add(new DateRange(lastYear, () -> new SimpleDateFormat("yyyy", ClientLocale.getThreadLocale()).format(new Date(lastYear))));
        dateRanges.add(new DateRange(0L, () -> Tickets.MSG.getMsg("value.daterange.older", new Object[0])));
    }

    @Override
    public SortGroup getSortGroupForKey(String sortGroupKey) {
        if (!StringFunctions.isEmpty((String)sortGroupKey)) {
            long timestamp = Long.parseLong(sortGroupKey);
            List<DateRange> dateRanges = ByDateRangeSortGroupInformation.getDateRanges();
            for (DateRange range : dateRanges) {
                if (range.getStartTime() != timestamp) continue;
                return new SortGroup(range.getDisplayName());
            }
        }
        return new SortGroup(Tickets.MSG.getMsg("value.unset", new Object[0]));
    }

    static {
        long now = System.currentTimeMillis();
        long diffToEndOfDay = oneDay - now % oneDay;
        DefaultTimer.getInstance().scheduleAtFixedRate(new DefaultTimerTask(){

            public void runImpl() throws Throwable {
                ByDateRangeSortGroupInformation.createDateRanges();
            }
        }, diffToEndOfDay, oneDay);
    }

    private static class DateRange {
        private long start;
        private Supplier<String> displayNameFactory;

        public DateRange(long start, Supplier<String> displayNameFactory) {
            this.start = start;
            this.displayNameFactory = displayNameFactory;
        }

        public boolean matches(long timestamp) {
            return timestamp >= this.start;
        }

        public long getStartTime() {
            return this.start;
        }

        public String getDisplayName() {
            return this.displayNameFactory.get();
        }
    }
}

