/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.id.GUID;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.GuidTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Locale;

public class TicketFieldOwnerGuid
extends TicketField<GUID> {
    public static final String KEY = "ownerid";

    public TicketFieldOwnerGuid() {
        super(TicketFieldOwnerGuid.createSearchTag(), null);
    }

    private static SearchTag createSearchTag() {
        return new SearchTag(KEY, SearchDataType.ID, true, (SearchTokenizer)GuidTokenizer.INSTANCE, 100, KEY, false){

            public String getDisplayName() {
                return Tickets.getFieldDisplayName(TicketFieldOwnerGuid.KEY);
            }
        };
    }

    public GUID copyValue(GUID value) {
        return value;
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return slave;
    }

    @Override
    public String valueToString(GUID fieldValue) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(fieldValue);
        if (userAccount == null) {
            return null;
        }
        return userAccount.getDisplayName();
    }

    @Override
    protected int getFieldChangeReaStepActionId() {
        return -10;
    }

    @Override
    public String getFieldDisplayName(Locale locale) {
        return Tickets.getFieldDisplayName(this.getKey(), locale);
    }
}

