/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.ticketmanager.fielddefinitions.DateTimeUtils;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.Locale;

public class TicketFieldDeadline
extends TicketField<Long> {
    public static final String KEY = "deadline";

    public TicketFieldDeadline() {
        super(TicketFieldDeadline.createSearchTag());
    }

    private static SearchTag createSearchTag() {
        return new SearchTag(KEY, SearchDataType.Date, false, 100, KEY, true){

            public String getDisplayName() {
                return Tickets.getFieldDisplayName(TicketFieldDeadline.KEY);
            }
        };
    }

    public void validate(Long value) {
        super.validate((Object)value);
        if (value != null) {
            BasicFieldValidation.throwIfNegative((long)value);
        }
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    @Override
    public String valueToString(Long fieldValue) {
        return DateTimeUtils.dateTimeToLongFormat(fieldValue);
    }

    @Override
    protected int getFieldChangeReaStepActionId() {
        return -17;
    }

    @Override
    public String getFieldDisplayName(Locale locale) {
        return Tickets.getFieldDisplayName(this.getKey(), locale);
    }
}

