/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.events.domain;

import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class ChangedTicketVO {
    private TicketVO oldTicket;
    private TicketVO newTicket;
    private Set<Integer> stepIDs;

    public ChangedTicketVO(@Nullable TicketVO oldTicket, @Nullable TicketVO newTicket, @Nullable Set<Integer> stepIDs) {
        if (oldTicket == null && newTicket == null) {
            throw new IllegalArgumentException("You must provide at least one TicketVO instance");
        }
        if (oldTicket != null && newTicket != null && oldTicket.getID() != newTicket.getID()) {
            String msg = String.format("IDs of provided tickets must be the same: %d != %d", oldTicket.getID(), newTicket.getID());
            throw new IllegalArgumentException(msg);
        }
        this.oldTicket = oldTicket;
        this.newTicket = newTicket;
        this.stepIDs = stepIDs == null ? null : (stepIDs.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<Integer>(stepIDs)));
    }

    public int getTicketID() {
        return this.oldTicket != null ? this.oldTicket.getID() : this.newTicket.getID();
    }

    @Nullable
    public TicketVO getOldTicket() {
        return this.oldTicket;
    }

    @Nullable
    public TicketVO getNewTicket() {
        return this.newTicket;
    }

    @Nullable
    public Set<Integer> getReaStepIDs() {
        return this.stepIDs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangedTicket: " + this.getTicketID());
        for (Field attr : ServerPluginManager.getInstance().get(TicketAttribute.class)) {
            this.appendIfDiff(attr, sb);
        }
        for (Field attr : ServerPluginManager.getInstance().get(TicketField.class)) {
            this.appendIfDiff(attr, sb);
        }
        return sb.toString();
    }

    private <T> void appendIfDiff(Field<T> attr, StringBuilder sb) {
        T right;
        T left = this.oldTicket.getFieldOrAttributeValue(attr);
        if (!Objects.equals(left, right = this.newTicket.getFieldOrAttributeValue(attr))) {
            sb.append('\n').append(attr.getKey()).append(':').append(left).append(" -> ").append(right);
        }
    }
}

