/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.cache.MemorySize;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.http.servlet.ClientLocale;
import com.inet.usersandgroups.api.FieldValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MutableTicketData
implements MemorySize {
    private Map<TicketField<Object>, Object> map = new HashMap<TicketField<Object>, Object>();

    public <VALUE> void put(TicketField<VALUE> field, VALUE value) {
        try {
            field.validate(value);
        }
        catch (FieldValidationException ex) {
            throw new FieldValidationException(field.getFieldDisplayName(ClientLocale.getThreadLocale()) + ": " + ex.getMessage(), (Throwable)ex);
        }
        this.map.put(field, value);
    }

    public <VALUE> void putValidOrDefaultValue(TicketField<VALUE> field, VALUE value) {
        value = field.getValidOrDefaultValue(value, null);
        this.map.put(field, value);
    }

    public <VALUE> VALUE get(TicketField<VALUE> field) {
        return (VALUE)this.map.get(field);
    }

    public <VALUE> VALUE getOrDefault(TicketField<VALUE> field) {
        return (VALUE)this.map.getOrDefault(field, field.getDefaultValue());
    }

    public void remove(TicketField<?> field) {
        this.map.remove(field);
    }

    public boolean containsKey(TicketField<?> field) {
        return this.map.containsKey(field);
    }

    public boolean hasValue(TicketField<?> field) {
        return this.map.get(field) != null;
    }

    public Set<TicketField<Object>> getIncludedFields() {
        return new HashSet<TicketField<Object>>(this.map.keySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public MutableTicketData copy() {
        MutableTicketData copy = new MutableTicketData();
        for (Map.Entry<TicketField<Object>, Object> entry : this.map.entrySet()) {
            TicketField<Object> field = entry.getKey();
            copy.map.put(field, field.copyValue(entry.getValue()));
        }
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableTicketData other = (MutableTicketData)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TicketData:[");
        sb.append(this.map.toString()).append("]");
        return sb.toString();
    }

    public void putAll(MutableTicketData ticketData) {
        this.map.putAll(ticketData.map);
    }

    public long getSizeInMemory() {
        return 16L + MemorySize.getSizeOfMap(this.map);
    }
}

