/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextMember;
import java.util.List;

public class AutoTextVO
extends FieldVO {
    private Integer UserID;
    private String Label;
    private int Typ;
    private String ContentText;
    private String Shortcut;
    private List<AutoTextMember> Memberships;
    private String GroupLabel;

    private AutoTextVO() {
    }

    private AutoTextVO(int id) {
        super(id);
    }

    public static AutoTextVO of(int id, Integer userId, String label, int typ, String contentText, String shortcut, String groupLabel, List<AutoTextMember> memberships) {
        AutoTextVO vo = new AutoTextVO(id);
        vo.Typ = typ;
        vo.ContentText = contentText == null ? "" : contentText;
        vo.Shortcut = shortcut;
        vo.GroupLabel = groupLabel == null ? "" : groupLabel.trim();
        vo.UserID = userId;
        vo.Memberships = memberships;
        vo.Label = label;
        return vo;
    }

    public Integer getUserId() {
        return this.UserID;
    }

    public int getTyp() {
        return this.Typ;
    }

    public String getContentText() {
        return this.ContentText == null ? "" : this.ContentText;
    }

    public String getLabel() {
        return this.Label;
    }

    public String getGroupLabel() {
        return this.GroupLabel == null ? "" : this.GroupLabel.trim();
    }

    public String getShortcut() {
        return this.Shortcut;
    }

    public boolean isEmailSignature() {
        return (this.Typ & 0x10) == 16;
    }

    public boolean isEnduserInquiry() {
        return (this.Typ & 8) == 8;
    }

    @Override
    public String getDisplayValue() {
        return this.Label;
    }

    public List<AutoTextMember> getMemberships() {
        return this.Memberships;
    }

    public void setMemberships(List<AutoTextMember> memberships) {
        this.Memberships = memberships;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AutoTextVO other = (AutoTextVO)obj;
        if (this.UserID != other.UserID) {
            return false;
        }
        if (this.Label != other.Label) {
            return false;
        }
        if (this.Typ != other.Typ) {
            return false;
        }
        if (this.ContentText != other.ContentText) {
            return false;
        }
        if (this.Shortcut != other.Shortcut) {
            return false;
        }
        return this.Memberships == other.Memberships;
    }
}

