/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.resource;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.IHelpDeskUserGroupManager;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Deprecated
public class ResourceManager
extends GenericFieldsManager<ResourceVO> {
    private static final ResourceManager manager = new ResourceManager();
    private Map<GenericFieldsManager.DataChangeListener, EventProxy> listeners = new HashMap<GenericFieldsManager.DataChangeListener, EventProxy>();

    private ResourceManager() {
        super(ResourceVO.class, "tblRessourcen");
    }

    public static ResourceManager getInstance() {
        return manager;
    }

    @Override
    public int add(ResourceVO vo) throws SQLException {
        throw new IllegalStateException("ResourceManager.add() is not supported. Use the UserAndGroupsManager-API to create resources.");
    }

    @Override
    public void addDataChangeListener(GenericFieldsManager.DataChangeListener listener) {
        EventProxy wrapper = new EventProxy(listener);
        UserGroupManager.getInstance().registerListener((UserGroupEventListener)wrapper);
        this.listeners.put(listener, wrapper);
    }

    @Override
    public void removeDataChangeListener(GenericFieldsManager.DataChangeListener listener) {
        EventProxy wrapper = this.listeners.get(listener);
        if (wrapper == null) {
            return;
        }
        UserGroupManager.getInstance().unregisterListener((UserGroupEventListener)wrapper);
    }

    @Override
    public ResourceVO get(int id) {
        return ResourceManager.groupToVO(HDUsersAndGroups.getResource(id));
    }

    private static ResourceVO groupToVO(UserGroupInfo resource) {
        UserGroupInfo parentResource;
        if (resource == null) {
            return null;
        }
        int id = (Integer)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
        String name = resource.getName();
        GUID parentGUID = resource.getParentID();
        int parentResourceID = 0;
        if (parentGUID != null && (parentResource = UserGroupManager.getInstance().getGroup(parentGUID)) != null) {
            parentResourceID = ResourceManager.getInt((Number)parentResource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID));
        }
        String email = (String)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_EMAIL);
        int escalationResourceID = ResourceManager.getInt((Number)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ESC_RES_ID));
        double hourlyRate = ResourceManager.getDouble((Number)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_HOURLY_RATE));
        int message = ResourceManager.getInt((Number)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_NOTIF_SETTINGS));
        long permissions = ResourceManager.getLong((Number)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS));
        boolean deleted = !resource.isActive();
        return new ResourceVO(id, name, parentResourceID, email, escalationResourceID, hourlyRate, message, permissions, deleted);
    }

    private static int getInt(Number value) {
        return value != null ? value.intValue() : 0;
    }

    private static long getLong(Number value) {
        return value != null ? value.longValue() : 0L;
    }

    private static double getDouble(Number value) {
        return value != null ? value.doubleValue() : 0.0;
    }

    private MutableUserGroupData voToGroupData(ResourceVO resource) {
        MutableUserGroupData data = new MutableUserGroupData();
        data.put((UserGroupField)HDUsersAndGroups.RES_FIELD_EMAIL, (Object)resource.getEmail());
        data.put((UserGroupField)HDUsersAndGroups.RES_FIELD_ESC_RES_ID, (Object)resource.getEscalationID());
        data.put((UserGroupField)HDUsersAndGroups.RES_FIELD_HOURLY_RATE, (Object)resource.getHourlyRate());
        data.put((UserGroupField)HDUsersAndGroups.RES_FIELD_ID, (Object)resource.getId());
        data.put((UserGroupField)HDUsersAndGroups.RES_FIELD_NOTIF_SETTINGS, (Object)resource.getMsg());
        data.put((UserGroupField)HDUsersAndGroups.RES_FIELD_PARENT_ID, (Object)resource.getParentID());
        data.put((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS, (Object)((int)resource.getPermissionFlags()));
        return data;
    }

    @Override
    public List<ResourceVO> getAll(boolean validOnly) {
        UserGroupManager um = UserGroupManager.getInstance();
        Set resources = validOnly ? um.getGroups(HDUsersAndGroups.RESOURCE) : um.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE);
        return resources.stream().map(ResourceManager::groupToVO).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, String> getAllAttributeDisplayNames(boolean onlyActiveEntries) {
        UserGroupManager um = UserGroupManager.getInstance();
        Set resources = onlyActiveEntries ? um.getGroups(HDUsersAndGroups.RESOURCE) : um.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE);
        return resources.stream().collect(Collectors.toMap(r -> (Integer)r.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID), r -> r.getName() == null ? "" : r.getName()));
    }

    @Override
    public ResourceVO remove(int id) throws SQLException {
        UserGroupInfo resource = HDUsersAndGroups.getResource(id);
        if (resource != null) {
            UserGroupManager.getInstance().deleteGroup(resource.getID());
        }
        return ResourceManager.groupToVO(resource);
    }

    @Override
    public void update(ResourceVO vo) throws SQLException {
        UserGroupInfo parent;
        UserGroupInfo resource = HDUsersAndGroups.getResource(vo.getId());
        if (resource == null) {
            throw new IllegalArgumentException("Cannot update entry ID " + vo.getId() + " since there is no such entry in the database");
        }
        MutableUserGroupData groupData = this.voToGroupData(vo);
        groupData.remove((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
        groupData.remove((UserGroupField)HDUsersAndGroups.RES_FIELD_PARENT_ID);
        UserGroupManager ugm = UserGroupManager.getInstance();
        ugm.updateGroupData(resource.getID(), groupData);
        if (!vo.getDisplayValue().equals(resource.getDisplayName())) {
            ugm.renameGroup(resource.getID(), vo.getDisplayValue());
        }
        GUID currentParent = resource.getParentID();
        GUID voParent = null;
        if (vo.getParentID() > 0 && (parent = HDUsersAndGroups.getResource(vo.getParentID())) != null) {
            voParent = parent.getID();
        }
        if (currentParent != null ? !currentParent.equals(voParent) : voParent != null) {
            ugm.setParentGroup(resource.getID(), voParent);
        }
        if (resource.isActive() && vo.isDeleted()) {
            ugm.deactivateGroup(resource.getID(), false);
        }
    }

    @Override
    public URL getIcon(int id, int size) {
        IHelpDeskUserGroupManager groupManager = (IHelpDeskUserGroupManager)UserGroupManager.getInstance();
        UserGroupInfo ressourceGroup = groupManager.getUserGroupInfoForResourceId(id);
        String iconName = ressourceGroup == null ? "delete_16.gif" : (SystemPermissionChecker.checkAccess((Permission)HdPermissions.TICKET_RESOURCES_READ_WRITE) ? "resources_16.gif" : (HDUsersAndGroups.hasWritePermissionInResource(UserManager.getInstance().getCurrentUserAccountID(), ressourceGroup) ? "resources_16.gif" : (HDUsersAndGroups.hasReadPermissionInResource(UserManager.getInstance().getCurrentUserAccountID(), ressourceGroup) ? "resources_read_16.gif" : "resource_forign_16.gif")));
        return this.resolveImageURL(iconName, size);
    }

    public int[] getResources(UserAccount userAccount, boolean checkReadWriteAllPermissions) {
        if (userAccount == null) {
            return new int[0];
        }
        if (checkReadWriteAllPermissions && SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ, HdPermissions.TICKET_RESOURCES_READ_WRITE})) {
            return null;
        }
        Set allRessourceGroups = UserGroupManager.getInstance().getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE);
        return allRessourceGroups.stream().filter(r -> HDUsersAndGroups.hasAccessInResource(userAccount.getID(), r)).mapToInt(r -> (Integer)r.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID)).toArray();
    }

    public GUID[] getResourceUUIDs(UserAccount userAccount, boolean checkReadWriteAllPermissions) {
        if (userAccount == null) {
            return new GUID[0];
        }
        if (checkReadWriteAllPermissions && SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ, HdPermissions.TICKET_RESOURCES_READ_WRITE})) {
            return null;
        }
        Set allRessourceGroups = UserGroupManager.getInstance().getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE);
        return (GUID[])allRessourceGroups.stream().filter(r -> HDUsersAndGroups.hasAccessInResource(userAccount.getID(), r)).map(UserGroupInfo::getID).toArray(GUID[]::new);
    }

    private static class EventProxy
    implements UserGroupEventListener {
        private GenericFieldsManager.DataChangeListener forwardTo;

        public EventProxy(GenericFieldsManager.DataChangeListener forwardTo) {
            this.forwardTo = forwardTo;
        }

        private void checkNotification(UserGroupInfo groupInfo) {
            if (groupInfo.getType() == HDUsersAndGroups.RESOURCE) {
                this.forwardTo.cacheUpdated();
            }
        }

        public void groupCreated(UserGroupInfo groupInfo) {
            this.checkNotification(groupInfo);
        }

        public void groupRenamed(String previousGroupName, UserGroupInfo groupInfo) {
            this.checkNotification(groupInfo);
        }

        public void groupParentChanged(UserGroupInfo groupInfo) {
            this.checkNotification(groupInfo);
        }

        public void groupDataUpdated(UserGroupInfo groupInfo) {
            this.checkNotification(groupInfo);
        }

        public void groupMembersUpdated(UserGroupInfo groupInfo) {
            this.checkNotification(groupInfo);
        }

        public void groupDeleted(UserGroupInfo groupInfo) {
            this.checkNotification(groupInfo);
        }

        public void groupDeactivated(UserGroupInfo groupInfo) {
            this.checkNotification(groupInfo);
        }
    }
}

