/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.category;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CategoryManager
extends GenericFieldsManager<CategoryVO> {
    private static final int CATEGORY_MAX_LENGTH = 49;
    private static CategoryManager manager = new CategoryManager();

    private CategoryManager() {
        super(CategoryVO.class, "tblBetreffs");
    }

    public static CategoryManager getInstance() {
        return manager;
    }

    @Override
    public URL getIcon(int id, int size) {
        return this.resolveImageURL("kategorie_16.gif", size);
    }

    @Override
    protected void addDefaultData(Map<Integer, CategoryVO> map) {
        map.put(0, new CategoryVO(0, "", null, 0, false, false, null));
    }

    public CategoryVO getCategoryByPath(String path) {
        Optional<CategoryVO> first;
        if (path != null && (first = this.getAll(false).stream().filter(cat -> cat.getPath().equals(path)).findFirst()).isPresent()) {
            return first.get();
        }
        HDLogger.warn("No Category can be found for path: " + path);
        return null;
    }

    public String findCategoryPathOrThrow(@Nullable Integer categoryID) throws ServerDataException {
        if (categoryID == null) {
            return "";
        }
        CategoryVO category = (CategoryVO)this.get(categoryID);
        if (category == null) {
            String msg = String.format("category with ID = \"%d\" does not exist", categoryID);
            throw new ServerDataException(new IllegalArgumentException(msg));
        }
        return category.getPath();
    }

    public Integer findOrCreateCategory(String categoryPath) throws SQLException {
        return this.findOrCreateCategory(categoryPath, false);
    }

    public Integer findOrCreateCategory(String categoryPath, boolean createAsDeleted) throws SQLException {
        List<String> splittedCategoryPath = CategoryManager.splitIntoCategoryNames(categoryPath);
        if (splittedCategoryPath.isEmpty()) {
            return null;
        }
        Integer categoryID = null;
        String currentPath = "";
        for (String categoryName : splittedCategoryPath) {
            currentPath = currentPath.isEmpty() ? categoryName : currentPath + "\\" + categoryName;
            CategoryVO createdCategory = this.findOrCreateCategory(categoryName, currentPath, categoryID, createAsDeleted);
            categoryID = createdCategory.getId();
        }
        return categoryID;
    }

    private CategoryVO findOrCreateCategory(String categoryName, String categoryPath, @Nullable Integer parentCategoryID, boolean createAsDeleted) throws SQLException {
        CategoryVO category = this.getCategoryByPath(categoryPath);
        if (category != null) {
            return category;
        }
        int parentID = parentCategoryID == null ? 0 : parentCategoryID;
        CategoryVO vo = new CategoryVO(-1, categoryName, parentID, 0, false, createAsDeleted, null);
        this.add(vo);
        return vo;
    }

    private static List<String> splitIntoCategoryNames(String value) {
        ArrayList<String> categoryNames = new ArrayList<String>();
        for (String token : value.split("\\\\")) {
            if (token.trim().isEmpty()) continue;
            if (token.length() > 49) {
                token = token.substring(0, 49);
            }
            categoryNames.add(token);
        }
        return categoryNames;
    }

    @Override
    protected void setDataFromResult(ResultSet rs, CategoryVO instance) throws SQLException, IllegalAccessException {
        super.setDataFromResult(rs, instance);
        instance.resetPath();
    }

    public Map<Integer, String> getAllPathNames(boolean onlyActiveEntries) {
        List all = CategoryManager.getInstance().getAll(onlyActiveEntries);
        return all.stream().collect(Collectors.toMap(c -> c.getId(), c -> c.getPath()));
    }
}

