/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.lib.util.StringFunctions;
import java.net.URL;
import java.util.Comparator;

public class TicketFieldDefinitionWorkflowImage
extends TicketFieldDefinition {
    public TicketFieldDefinitionWorkflowImage() {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET, Tickets.ATTRIBUTE_WORKFLOW_ID + ".icon", false, true);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_workflow_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_workflow_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_workflow_16@3x.png");
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        if (ticket.getWorkflowID() != null) {
            if (ticket.isSubTicketInWorkflow()) {
                return Tickets.MSG.getMsg("field.workflowid.sub", new Object[0]);
            }
            return Tickets.MSG.getMsg("field.workflowid.main", new Object[0]);
        }
        return null;
    }

    private String getWFKey(TicketVO ticket) {
        if (ticket.getWorkflowID() != null) {
            if (ticket.isSubTicketInWorkflow()) {
                return "wfsub";
            }
            return "wfmain";
        }
        return null;
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        return this.getWFKey(ticket);
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        if ("wfmain".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/workflow_main.png");
        }
        if ("wfsub".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/workflow_sub.png");
        }
        return null;
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation(Tickets.ATTRIBUTE_WORKFLOW_ID.getKey(), sortGroupKey -> {
            if (StringFunctions.isEmpty((String)sortGroupKey)) {
                return new SortGroup(Tickets.MSG.getMsg("value.unset", new Object[0]), false, null);
            }
            String displayName = sortGroupKey;
            if ("wfmain".equals(sortGroupKey)) {
                displayName = Tickets.MSG.getMsg("field.workflowid.main", new Object[0]);
            } else if ("wfsub".equals(sortGroupKey)) {
                displayName = Tickets.MSG.getMsg("field.workflowid.sub", new Object[0]);
            }
            return new SortGroup(displayName, true, (String)sortGroupKey);
        }){

            @Override
            public String getSortGroupKey(TicketVO ticket) {
                String wfKey = TicketFieldDefinitionWorkflowImage.this.getWFKey(ticket);
                return wfKey == null ? "" : wfKey;
            }
        };
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator nullsLast = Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER);
        return (a, b) -> nullsLast.compare(this.getWFKey((TicketVO)b), this.getWFKey((TicketVO)a));
    }
}

