/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionTargetTime
extends AbstractTicketFieldDefinitionWithField<Integer> {
    public TicketFieldDefinitionTargetTime() {
        super(Tickets.FIELD_TARGET_TIME, true, false);
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                if (!HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
                    return false;
                }
                if (tickets != null) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(-30);
                    for (TicketVO ticket : tickets) {
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String targetTimeStr = values.get(this.getFieldKey());
                if (StringFunctions.isEmpty((String)targetTimeStr)) {
                    ticketData.put(Tickets.FIELD_TARGET_TIME, null);
                    return;
                }
                try {
                    String[] split = targetTimeStr.split(":");
                    if (split.length == 2) {
                        int targetTime = Integer.parseInt(split[0]) * 60 + Integer.parseInt(split[1]);
                        ticketData.put(Tickets.FIELD_TARGET_TIME, targetTime);
                        return;
                    }
                    if (split.length == 1) {
                        int targetTime = Integer.parseInt(split[0]);
                        ticketData.put(Tickets.FIELD_TARGET_TIME, targetTime);
                        return;
                    }
                }
                catch (Throwable t) {
                    HDLogger.debug(t);
                }
                throw new ClientMessageException(TicketFieldDefinitionTargetTime.this.getDisplayName() + ": " + Tickets.MSG.getMsg("error.targettime.invalidformat", new Object[0]));
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    String displayValue = TicketFieldDefinitionTargetTime.this.getDisplayValue(ticket);
                    values.put(this.getFieldKey(), displayValue);
                } else {
                    values.put(this.getFieldKey(), "");
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionTargetTime.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return TEXTINPUT;
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionTargetTime.this.getDisplayName();
            }
        };
    }
}

