/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.core.model.general.Localization;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithGenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.ItilSelectOption;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOption;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOptions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionItilId
extends AbstractTicketFieldDefinitionWithGenericFieldsManager {
    private static ConfigValue<Integer> ITIL = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_ITIL_ID);

    public TicketFieldDefinitionItilId() {
        super(Tickets.FIELD_ITIL_ID, ItilManager.getInstance());
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        LocalizationBundle localizationBundle = (LocalizationBundle)spm.getSingleInstance(LocalizationBundle.class);
        final Localization localization = localizationBundle.getInstance(ClientLocale.getThreadLocale(), (TranslationTextConnector)spm.getSingleInstance(TranslationTextConnector.class));
        final boolean isManagment = SystemPermissionChecker.checkAccess((Permission)HdPermissions.ITIL_MANAGEMENT);
        return new SelectEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                if (!HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
                    return false;
                }
                if (tickets != null) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(-15);
                    for (TicketVO ticket : tickets) {
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    Integer itilId;
                    SelectOption selectOption = null;
                    selectOption = (SelectOption)new Json().fromJson(value, ItilSelectOption.class);
                    String valueString = selectOption.getValue();
                    if (!StringFunctions.isEmpty((String)valueString) && (itilId = Integer.valueOf(selectOption.getValue())) != null) {
                        ticketData.put(Tickets.FIELD_ITIL_ID, itilId);
                    }
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                ItilVO itilVO;
                Integer itilId = (Integer)ITIL.get();
                if (ticket != null) {
                    itilId = ticket.getItilID();
                }
                SelectOption option = new SelectOption(null, "");
                if (itilId != null && (itilVO = (ItilVO)ItilManager.getInstance().get(itilId)) != null) {
                    option = new SelectOption(String.valueOf(itilId), itilVO.getDisplayValue(), String.valueOf(itilVO.getId()));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionItilId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionItilId.this.getDisplayName();
            }

            @Override
            public String getDisplayType() {
                return isManagment ? "itilselect" : SELECT;
            }

            @Override
            public SelectOptions getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                Comparator<ItilVO> comparator = new Comparator<ItilVO>(){

                    @Override
                    public int compare(ItilVO o1, ItilVO o2) {
                        if (o1.isMasterType() && !o2.isMasterType()) {
                            return 1;
                        }
                        if (!o1.isMasterType() && o2.isMasterType()) {
                            return -1;
                        }
                        return o1.getDisplayValue().compareToIgnoreCase(o2.getDisplayValue());
                    }
                };
                searchTerm = searchTerm != null ? searchTerm : "";
                ItilManager manager = ItilManager.getInstance();
                List itils = manager.getAll(true);
                itils.sort(comparator);
                for (ItilVO itilVO : itils) {
                    String itilDisplayValue = itilVO.getDisplayValue();
                    if (itilDisplayValue == null) {
                        itilDisplayValue = "";
                    }
                    if (!itilDisplayValue.toLowerCase().contains(searchTerm.toLowerCase()) || !isManagment && itilVO.isMasterType() || itilVO.getProtectedContent() > 0 && !SystemPermissionChecker.checkAccess((Permission)HdPermissions.ITIL_PROTECTED)) continue;
                    list.add(this.createOtion(itilVO));
                }
                if (list.size() < currentSize) {
                    return new SelectOptions(new ArrayList<SelectOption>(), 0);
                }
                List<SelectOption> subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptions(subList, list.size());
            }

            private SelectOption createOtion(ItilVO itilVO) {
                String parent = null;
                parent = itilVO.isMasterType() ? localization.getTranslation("helpdesk", "_itilmaster") : localization.getTranslation("helpdesk", "_itilslave");
                return new ItilSelectOption(String.valueOf(itilVO.getId()), itilVO.getDisplayValue(), String.valueOf(itilVO.getId()), itilVO.getInfo(), parent);
            }
        };
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/itil_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/itil_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/itil_16@3x.png");
    }
}

