/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionIdentifier
extends AbstractTicketFieldDefinitionWithField<String> {
    public TicketFieldDefinitionIdentifier() {
        super(Tickets.FIELD_IDENTIFIER, true, false);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(a.getForKey(this.getKey()), b.getForKey(this.getKey()));
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                if (!HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
                    return false;
                }
                if (tickets != null) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(-27);
                    for (TicketVO ticket : tickets) {
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String identifier = values.get(this.getFieldKey());
                if (identifier != null) {
                    ticketData.put(Tickets.FIELD_IDENTIFIER, identifier);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    String identifier = ticket.getIdentifier();
                    values.put(this.getFieldKey(), String.valueOf(identifier));
                } else {
                    String fieldValue;
                    UserAccount userAccount;
                    String value = "";
                    DefaultValuesManager defaultValuesManager = (DefaultValuesManager)ServerPluginManager.getInstance().getSingleInstance(DefaultValuesManager.class);
                    UserField<String> fieldForIdentifierValue = defaultValuesManager.getFieldForIdentifierValue();
                    if (fieldForIdentifierValue != null && ownerId != null && (userAccount = UserManager.getInstance().getUserAccount(ownerId)) != null && (fieldValue = (String)userAccount.getValue(fieldForIdentifierValue)) != null) {
                        value = fieldValue;
                    }
                    values.put(this.getFieldKey(), value);
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionIdentifier.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return TEXTINPUT;
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionIdentifier.this.getDisplayName();
            }
        };
    }
}

